"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.migrationSchematic = exports.migrationGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const path = require("path");
const generator_1 = require("../lint-checks/generator");
const package_json_1 = require("nx/src/utils/package-json");
function normalizeOptions(host, options) {
    var _a;
    let name;
    if (options.name) {
        name = (0, devkit_1.names)(options.name).fileName;
    }
    else {
        name = (0, devkit_1.names)(`update-${options.packageVersion}`).fileName;
    }
    const description = (_a = options.description) !== null && _a !== void 0 ? _a : name;
    const { root: projectRoot, sourceRoot: projectSourceRoot } = (0, devkit_1.readProjectConfiguration)(host, options.project);
    const normalized = Object.assign(Object.assign({}, options), { name,
        description,
        projectRoot,
        projectSourceRoot });
    return normalized;
}
function addFiles(host, options) {
    (0, devkit_1.generateFiles)(host, path.join(__dirname, 'files/migration'), `${options.projectSourceRoot}/migrations`, Object.assign(Object.assign({}, options), { tmpl: '' }));
}
function updateMigrationsJson(host, options) {
    var _a, _b;
    const configuredMigrationPath = (0, package_json_1.readNxMigrateConfig)((0, devkit_1.readJson)(host, (0, devkit_1.joinPathFragments)(options.projectRoot, 'package.json'))).migrations;
    const migrationsPath = (0, devkit_1.joinPathFragments)(options.projectRoot, configuredMigrationPath !== null && configuredMigrationPath !== void 0 ? configuredMigrationPath : 'migrations.json');
    const migrations = host.exists(migrationsPath)
        ? (0, devkit_1.readJson)(host, migrationsPath)
        : {};
    if (migrations.schematics) {
        migrations.generators = migrations.schematics;
        delete migrations.schematics;
    }
    const generators = (_a = migrations.generators) !== null && _a !== void 0 ? _a : {};
    generators[options.name] = {
        version: options.packageVersion,
        description: options.description,
        cli: 'nx',
        implementation: `./src/migrations/${options.name}/${options.name}`,
    };
    migrations.generators = generators;
    if (options.packageJsonUpdates) {
        const packageJsonUpdatesObj = (_b = migrations.packageJsonUpdates) !== null && _b !== void 0 ? _b : {};
        if (!packageJsonUpdatesObj[options.packageVersion]) {
            packageJsonUpdatesObj[options.packageVersion] = {
                version: options.packageVersion,
                packages: {},
            };
        }
        migrations.packageJsonUpdates = packageJsonUpdatesObj;
    }
    (0, devkit_1.writeJson)(host, migrationsPath, migrations);
}
function updatePackageJson(host, options) {
    (0, devkit_1.updateJson)(host, path.join(options.projectRoot, 'package.json'), (json) => {
        if (!json['nx-migrations'] || !json['nx-migrations'].migrations) {
            if (json['nx-migrations']) {
                json['nx-migrations'].migrations = './migrations.json';
            }
            else {
                json['nx-migrations'] = {
                    migrations: './migrations.json',
                };
            }
        }
        return json;
    });
}
function updateWorkspaceJson(host, options) {
    var _a, _b;
    const project = (0, devkit_1.readProjectConfiguration)(host, options.project);
    const assets = (_b = (_a = project.targets.build) === null || _a === void 0 ? void 0 : _a.options) === null || _b === void 0 ? void 0 : _b.assets;
    if (assets &&
        assets.filter((a) => a.glob === 'migrations.json').length === 0) {
        project.targets.build.options.assets = [
            ...assets,
            {
                input: `./${options.projectRoot}`,
                glob: 'migrations.json',
                output: '.',
            },
        ];
        (0, devkit_1.updateProjectConfiguration)(host, options.project, project);
    }
}
function migrationGenerator(host, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = normalizeOptions(host, schema);
        addFiles(host, options);
        updateMigrationsJson(host, options);
        updateWorkspaceJson(host, options);
        updateMigrationsJson(host, options);
        updatePackageJson(host, options);
        if (!host.exists('migrations.json')) {
            const packageJsonPath = (0, devkit_1.joinPathFragments)(options.projectRoot, 'package.json');
            (0, generator_1.addMigrationJsonChecks)(host, { projectName: schema.project }, (0, devkit_1.readJson)(host, packageJsonPath));
        }
        yield (0, devkit_1.formatFiles)(host);
    });
}
exports.migrationGenerator = migrationGenerator;
exports.default = migrationGenerator;
exports.migrationSchematic = (0, devkit_1.convertNxGenerator)(migrationGenerator);
//# sourceMappingURL=migration.js.map