"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
const devkit_1 = require("@nrwl/devkit");
function normalizeOptions(host, options) {
    const { npmScope, libsDir } = (0, devkit_1.getWorkspaceLayout)(host);
    const name = (0, devkit_1.names)(options.name).fileName;
    const projectDirectory = options.directory
        ? `${(0, devkit_1.names)(options.directory).fileName}/${name}`
        : name;
    const projectName = projectDirectory.replace(new RegExp('/', 'g'), '-');
    const fileName = projectName;
    const projectRoot = (0, devkit_1.joinPathFragments)(libsDir, projectDirectory);
    const parsedTags = options.tags
        ? options.tags.split(',').map((s) => s.trim())
        : [];
    const npmPackageName = options.importPath || (0, devkit_1.getImportPath)(npmScope, name);
    return Object.assign(Object.assign({}, options), { fileName,
        npmScope,
        libsDir, name: projectName, projectRoot,
        projectDirectory,
        parsedTags,
        npmPackageName });
}
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=normalize-schema.js.map