"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureNxProject = exports.newNxProject = exports.runPackageManagerInstall = exports.uniq = exports.patchPackageJsonForPlugin = void 0;
const devkit_1 = require("@nrwl/devkit");
const devkit_2 = require("@nrwl/devkit");
const child_process_1 = require("child_process");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const paths_1 = require("./paths");
const utils_1 = require("./utils");
function runNxNewCommand(args, silent) {
    const localTmpDir = (0, path_1.dirname)((0, paths_1.tmpProjPath)());
    return (0, child_process_1.execSync)(`node ${require.resolve('nx')} new proj --nx-workspace-root=${localTmpDir} --no-interactive --skip-install --collection=@nrwl/workspace --npmScope=proj --preset=empty ${args || ''}`, Object.assign({ cwd: localTmpDir }, (silent && false ? { stdio: ['ignore', 'ignore', 'ignore'] } : {})));
}
function patchPackageJsonForPlugin(npmPackageName, distPath) {
    const path = (0, paths_1.tmpProjPath)('package.json');
    const json = (0, devkit_2.readJsonFile)(path);
    json.devDependencies[npmPackageName] = `file:${devkit_1.workspaceRoot}/${distPath}`;
    (0, devkit_2.writeJsonFile)(path, json);
}
exports.patchPackageJsonForPlugin = patchPackageJsonForPlugin;
/**
 * Generate a unique name for running CLI commands
 * @param prefix
 *
 * @returns `'<prefix><random number>'`
 */
function uniq(prefix) {
    return `${prefix}${Math.floor(Math.random() * 10000000)}`;
}
exports.uniq = uniq;
/**
 * Run the appropriate package manager install command in the e2e directory
 * @param silent silent output from the install
 */
function runPackageManagerInstall(silent = true) {
    const pmc = (0, devkit_2.getPackageManagerCommand)();
    const install = (0, child_process_1.execSync)(pmc.install, Object.assign({ cwd: (0, paths_1.tmpProjPath)() }, (silent ? { stdio: ['ignore', 'ignore', 'ignore'] } : {})));
    return install ? install.toString() : '';
}
exports.runPackageManagerInstall = runPackageManagerInstall;
/**
 * Creates a new nx project in the e2e directory
 *
 * @param npmPackageName package name to test
 * @param pluginDistPath dist path where the plugin was outputted to
 */
function newNxProject(npmPackageName, pluginDistPath) {
    (0, utils_1.cleanup)();
    runNxNewCommand('', true);
    patchPackageJsonForPlugin(npmPackageName, pluginDistPath);
    runPackageManagerInstall();
}
exports.newNxProject = newNxProject;
/**
 * Ensures that a project has been setup in the e2e directory
 * It will also copy `@nrwl` packages to the e2e directory
 */
function ensureNxProject(npmPackageName, pluginDistPath) {
    (0, fs_extra_1.ensureDirSync)((0, paths_1.tmpProjPath)());
    newNxProject(npmPackageName, pluginDistPath);
}
exports.ensureNxProject = ensureNxProject;
//# sourceMappingURL=nx-project.js.map