"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.componentStorySchematic = exports.componentStoryGenerator = exports.findPropsAndGenerateFile = exports.createComponentStoriesFile = exports.getArgsDefaultValue = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const ts = require("typescript");
const ast_utils_1 = require("../../utils/ast-utils");
// TODO: candidate to refactor with the angular component story
function getArgsDefaultValue(property) {
    const typeNameToDefault = {
        [ts.SyntaxKind.StringKeyword]: "''",
        [ts.SyntaxKind.NumberKeyword]: 0,
        [ts.SyntaxKind.BooleanKeyword]: false,
    };
    const resolvedValue = typeNameToDefault[property];
    if (typeof resolvedValue === undefined) {
        return "''";
    }
    else {
        return resolvedValue;
    }
}
exports.getArgsDefaultValue = getArgsDefaultValue;
function createComponentStoriesFile(host, { project, componentPath }) {
    const proj = (0, devkit_1.getProjects)(host).get(project);
    const sourceRoot = proj.sourceRoot;
    const componentFilePath = (0, devkit_1.joinPathFragments)(sourceRoot, componentPath);
    const componentDirectory = componentFilePath.replace(componentFilePath.slice(componentFilePath.lastIndexOf('/')), '');
    const isPlainJs = componentFilePath.endsWith('.jsx') || componentFilePath.endsWith('.js');
    let fileExt = 'tsx';
    if (componentFilePath.endsWith('.jsx')) {
        fileExt = 'jsx';
    }
    else if (componentFilePath.endsWith('.js')) {
        fileExt = 'js';
    }
    const componentFileName = componentFilePath
        .slice(componentFilePath.lastIndexOf('/') + 1)
        .replace('.tsx', '')
        .replace('.jsx', '')
        .replace('.js', '');
    const name = componentFileName;
    const contents = host.read(componentFilePath, 'utf-8');
    if (contents === null) {
        throw new Error(`Failed to read ${componentFilePath}`);
    }
    const sourceFile = ts.createSourceFile(componentFilePath, contents, ts.ScriptTarget.Latest, true);
    const cmpDeclaration = (0, ast_utils_1.getComponentNode)(sourceFile);
    if (!cmpDeclaration) {
        const componentNodes = (0, ast_utils_1.findExportDeclarationsForJsx)(sourceFile);
        if (componentNodes === null || componentNodes === void 0 ? void 0 : componentNodes.length) {
            componentNodes.forEach((declaration) => {
                findPropsAndGenerateFile(host, sourceFile, declaration, componentDirectory, name, isPlainJs, fileExt, componentNodes.length > 1);
            });
        }
        else {
            throw new Error(`Could not find any React component in file ${componentFilePath}`);
        }
    }
    else {
        findPropsAndGenerateFile(host, sourceFile, cmpDeclaration, componentDirectory, name, isPlainJs, fileExt);
    }
}
exports.createComponentStoriesFile = createComponentStoriesFile;
function findPropsAndGenerateFile(host, sourceFile, cmpDeclaration, componentDirectory, name, isPlainJs, fileExt, fromNodeArray) {
    const propsInterface = (0, ast_utils_1.getComponentPropsInterface)(sourceFile, cmpDeclaration);
    let propsTypeName = null;
    let props = [];
    let argTypes = [];
    if (propsInterface) {
        propsTypeName = propsInterface.name.text;
        props = propsInterface.members.map((member) => {
            if (member.type.kind === ts.SyntaxKind.FunctionType) {
                argTypes.push({
                    name: member.name.text,
                    type: 'action',
                    actionText: `${member.name.text} executed!`,
                });
            }
            else {
                return {
                    name: member.name.text,
                    defaultValue: getArgsDefaultValue(member.type.kind),
                };
            }
        });
        props = props.filter((p) => p && p.defaultValue !== undefined);
    }
    (0, devkit_1.generateFiles)(host, (0, devkit_1.joinPathFragments)(__dirname, './files'), (0, devkit_1.normalizePath)(componentDirectory), {
        componentFileName: fromNodeArray
            ? `${name}--${cmpDeclaration.name.text}`
            : name,
        componentImportFileName: name,
        propsTypeName,
        props,
        argTypes,
        componentName: cmpDeclaration.name.text,
        isPlainJs,
        fileExt,
    });
}
exports.findPropsAndGenerateFile = findPropsAndGenerateFile;
function componentStoryGenerator(host, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        createComponentStoriesFile(host, schema);
        yield (0, devkit_1.formatFiles)(host);
    });
}
exports.componentStoryGenerator = componentStoryGenerator;
exports.default = componentStoryGenerator;
exports.componentStorySchematic = (0, devkit_1.convertNxGenerator)(componentStoryGenerator);
//# sourceMappingURL=component-story.js.map