"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.update = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
function update(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(tree);
        projects.forEach((config) => {
            var _a, _b;
            if (((_b = (_a = config.targets) === null || _a === void 0 ? void 0 : _a.test) === null || _b === void 0 ? void 0 : _b.executor) !== '@nrwl/jest:jest')
                return;
            (0, devkit_1.visitNotIgnoredFiles)(tree, config.sourceRoot, (file) => {
                if (!file.endsWith('.spec.ts'))
                    return;
                const content = tree.read(file).toString();
                if (content.includes('@testing-library/react-hook')) {
                    tree.write(file, content.replace(/@testing-library\/react-hook/g, '@testing-library/react'));
                }
            });
        });
        (0, devkit_1.removeDependenciesFromPackageJson)(tree, ['@testing-library/react-hooks'], ['@testing-library/react-hooks']);
    });
}
exports.update = update;
exports.default = update;
//# sourceMappingURL=replace-testing-library-react-hook.js.map