"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createReactEslintJson = exports.extraEslintDependencies = void 0;
const devkit_1 = require("@nrwl/devkit");
const versions_1 = require("./versions");
exports.extraEslintDependencies = {
    dependencies: {},
    devDependencies: {
        'eslint-plugin-import': versions_1.eslintPluginImportVersion,
        'eslint-plugin-jsx-a11y': versions_1.eslintPluginJsxA11yVersion,
        'eslint-plugin-react': versions_1.eslintPluginReactVersion,
        'eslint-plugin-react-hooks': versions_1.eslintPluginReactHooksVersion,
    },
};
const createReactEslintJson = (projectRoot, setParserOptionsProject) => ({
    extends: [
        'plugin:@nrwl/nx/react',
        `${(0, devkit_1.offsetFromRoot)(projectRoot)}.eslintrc.json`,
    ],
    ignorePatterns: ['!**/*'],
    overrides: [
        {
            files: ['*.ts', '*.tsx', '*.js', '*.jsx'],
            /**
             * NOTE: We no longer set parserOptions.project by default when creating new projects.
             *
             * We have observed that users rarely add rules requiring type-checking to their Nx workspaces, and therefore
             * do not actually need the capabilites which parserOptions.project provides. When specifying parserOptions.project,
             * typescript-eslint needs to create full TypeScript Programs for you. When omitting it, it can perform a simple
             * parse (and AST tranformation) of the source files it encounters during a lint run, which is much faster and much
             * less memory intensive.
             *
             * In the rare case that users attempt to add rules requiring type-checking to their setup later on (and haven't set
             * parserOptions.project), the executor will attempt to look for the particular error typescript-eslint gives you
             * and provide feedback to the user.
             */
            parserOptions: !setParserOptionsProject
                ? undefined
                : {
                    project: [`${projectRoot}/tsconfig.*?.json`],
                },
            /**
             * Having an empty rules object present makes it more obvious to the user where they would
             * extend things from if they needed to
             */
            rules: {},
        },
        {
            files: ['*.ts', '*.tsx'],
            rules: {},
        },
        {
            files: ['*.js', '*.jsx'],
            rules: {},
        },
    ],
});
exports.createReactEslintJson = createReactEslintJson;
//# sourceMappingURL=lint.js.map