"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findAllAngularProjectsWithStorybookConfiguration = exports.migrateStoriesTo62Generator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const utilities_1 = require("@nrwl/storybook/src/utils/utilities");
const fileutils_1 = require("@nrwl/workspace/src/utilities/fileutils");
const find_nodes_1 = require("@nrwl/workspace/src/utilities/typescript/find-nodes");
const path_1 = require("path");
const typescript_1 = require("typescript");
const ts = require("typescript");
function migrateStoriesTo62Generator(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        let allComponentsWithStories = [];
        const result = findAllAngularProjectsWithStorybookConfiguration(tree);
        result === null || result === void 0 ? void 0 : result.forEach((angularProjectWithStorybook) => {
            const componentResult = findAllComponentsWithStoriesForSpecificProject(tree, angularProjectWithStorybook.projectRoot);
            allComponentsWithStories = [
                ...allComponentsWithStories,
                ...componentResult,
            ];
        });
        allComponentsWithStories === null || allComponentsWithStories === void 0 ? void 0 : allComponentsWithStories.forEach((componentInfo) => {
            changeSyntaxOfStory(tree, componentInfo.componentStoryPath);
        });
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.migrateStoriesTo62Generator = migrateStoriesTo62Generator;
function findAllAngularProjectsWithStorybookConfiguration(tree) {
    var _a, _b;
    const projects = (0, devkit_1.getProjects)(tree);
    const projectsThatHaveStorybookConfiguration = (_b = (_a = [...projects.entries()]) === null || _a === void 0 ? void 0 : _a.filter(([_, projectConfig]) => {
        var _a, _b, _c;
        return ((_c = (_b = (_a = projectConfig === null || projectConfig === void 0 ? void 0 : projectConfig.targets) === null || _a === void 0 ? void 0 : _a.storybook) === null || _b === void 0 ? void 0 : _b.options) === null || _c === void 0 ? void 0 : _c.uiFramework) ===
            '@storybook/angular';
    })) === null || _b === void 0 ? void 0 : _b.map(([projectName, projectConfig]) => {
        var _a, _b, _c;
        return {
            name: projectName,
            configFolder: (_c = (_b = (_a = projectConfig.targets.storybook) === null || _a === void 0 ? void 0 : _a.options) === null || _b === void 0 ? void 0 : _b.config) === null || _c === void 0 ? void 0 : _c.configFolder,
            projectRoot: projectConfig.root,
            projectSrc: projectConfig.sourceRoot,
        };
    });
    return projectsThatHaveStorybookConfiguration;
}
exports.findAllAngularProjectsWithStorybookConfiguration = findAllAngularProjectsWithStorybookConfiguration;
function findAllComponentsWithStoriesForSpecificProject(tree, projectPath) {
    let moduleFilePaths = [];
    (0, devkit_1.visitNotIgnoredFiles)(tree, projectPath, (filePath) => {
        if (filePath === null || filePath === void 0 ? void 0 : filePath.endsWith('.module.ts')) {
            moduleFilePaths.push(filePath);
        }
    });
    let componentFileInfos = [];
    moduleFilePaths === null || moduleFilePaths === void 0 ? void 0 : moduleFilePaths.map((moduleFilePath) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const file = (0, utilities_1.getTsSourceFile)(tree, moduleFilePath);
        const ngModuleDecorators = (0, find_nodes_1.findNodes)(file, ts.SyntaxKind.Decorator);
        if (ngModuleDecorators.length === 0) {
            return;
        }
        const ngModuleDecorator = ngModuleDecorators[0];
        const ngModuleNode = (_a = ngModuleDecorator === null || ngModuleDecorator === void 0 ? void 0 : ngModuleDecorator.getChildren()) === null || _a === void 0 ? void 0 : _a.find((node) => {
            var _a;
            return (_a = node === null || node === void 0 ? void 0 : node.getText()) === null || _a === void 0 ? void 0 : _a.startsWith('NgModule');
        });
        const ngModulePropertiesObject = (_b = ngModuleNode === null || ngModuleNode === void 0 ? void 0 : ngModuleNode.getChildren()) === null || _b === void 0 ? void 0 : _b.find((node) => {
            return node.kind === typescript_1.SyntaxKind.SyntaxList;
        });
        const ngModuleProperties = (_d = (_c = ngModulePropertiesObject === null || ngModulePropertiesObject === void 0 ? void 0 : ngModulePropertiesObject.getChildren()[0]) === null || _c === void 0 ? void 0 : _c.getChildren()) === null || _d === void 0 ? void 0 : _d.find((node) => {
            var _a;
            return (_a = node === null || node === void 0 ? void 0 : node.getText()) === null || _a === void 0 ? void 0 : _a.includes('declarations');
        });
        const declarationsPropertyAssignment = (_e = ngModuleProperties === null || ngModuleProperties === void 0 ? void 0 : ngModuleProperties.getChildren()) === null || _e === void 0 ? void 0 : _e.find((node) => {
            var _a;
            return (_a = node === null || node === void 0 ? void 0 : node.getText()) === null || _a === void 0 ? void 0 : _a.startsWith('declarations');
        });
        if (!declarationsPropertyAssignment) {
            devkit_1.logger.warn((0, devkit_1.stripIndents) `No components declared in ${moduleFilePath}.`);
        }
        let declarationArray = (_f = declarationsPropertyAssignment === null || declarationsPropertyAssignment === void 0 ? void 0 : declarationsPropertyAssignment.getChildren()) === null || _f === void 0 ? void 0 : _f.find((node) => node.kind === typescript_1.SyntaxKind.ArrayLiteralExpression);
        if (!declarationArray) {
            // Attempt to follow a variable instead of the literal
            const declarationVariable = (_g = declarationsPropertyAssignment === null || declarationsPropertyAssignment === void 0 ? void 0 : declarationsPropertyAssignment.getChildren()) === null || _g === void 0 ? void 0 : _g.filter((node) => node.kind === typescript_1.SyntaxKind.Identifier)[1];
            const variableName = declarationVariable === null || declarationVariable === void 0 ? void 0 : declarationVariable.getText();
            const variableDeclaration = (_h = (0, find_nodes_1.findNodes)(file, typescript_1.SyntaxKind.VariableDeclaration)) === null || _h === void 0 ? void 0 : _h.find((variableDeclaration) => {
                var _a;
                const identifier = (_a = variableDeclaration === null || variableDeclaration === void 0 ? void 0 : variableDeclaration.getChildren()) === null || _a === void 0 ? void 0 : _a.find((node) => node.kind === typescript_1.SyntaxKind.Identifier);
                return (identifier === null || identifier === void 0 ? void 0 : identifier.getText()) === variableName;
            });
            if (variableDeclaration) {
                declarationArray = (_j = variableDeclaration === null || variableDeclaration === void 0 ? void 0 : variableDeclaration.getChildren()) === null || _j === void 0 ? void 0 : _j.find((node) => node.kind === typescript_1.SyntaxKind.ArrayLiteralExpression);
            }
        }
        const declaredComponents = (_p = (_o = (_m = (_l = (_k = declarationArray === null || declarationArray === void 0 ? void 0 : declarationArray.getChildren()) === null || _k === void 0 ? void 0 : _k.find((node) => node.kind === typescript_1.SyntaxKind.SyntaxList)) === null || _l === void 0 ? void 0 : _l.getChildren()) === null || _m === void 0 ? void 0 : _m.filter((node) => node.kind === typescript_1.SyntaxKind.Identifier)) === null || _o === void 0 ? void 0 : _o.map((node) => node === null || node === void 0 ? void 0 : node.getText())) === null || _p === void 0 ? void 0 : _p.filter((name) => name === null || name === void 0 ? void 0 : name.endsWith('Component'));
        const imports = (_q = file.statements) === null || _q === void 0 ? void 0 : _q.filter((statement) => statement.kind === typescript_1.SyntaxKind.ImportDeclaration);
        const modulePath = moduleFilePath.slice(0, moduleFilePath === null || moduleFilePath === void 0 ? void 0 : moduleFilePath.lastIndexOf('/'));
        let componentInfo = declaredComponents === null || declaredComponents === void 0 ? void 0 : declaredComponents.map((componentName) => {
            var _a, _b, _c;
            try {
                const importStatement = imports === null || imports === void 0 ? void 0 : imports.find((statement) => {
                    var _a, _b, _c, _d, _e, _f, _g;
                    const namedImports = (_c = (_b = (_a = statement === null || statement === void 0 ? void 0 : statement.getChildren()) === null || _a === void 0 ? void 0 : _a.find((node) => node.kind === typescript_1.SyntaxKind.ImportClause)) === null || _b === void 0 ? void 0 : _b.getChildren()) === null || _c === void 0 ? void 0 : _c.find((node) => node.kind === typescript_1.SyntaxKind.NamedImports);
                    if (namedImports === undefined)
                        return false;
                    const importedIdentifiers = (_g = (_f = (_e = (_d = namedImports === null || namedImports === void 0 ? void 0 : namedImports.getChildren()) === null || _d === void 0 ? void 0 : _d.find((node) => node.kind === typescript_1.SyntaxKind.SyntaxList)) === null || _e === void 0 ? void 0 : _e.getChildren()) === null || _f === void 0 ? void 0 : _f.filter((node) => node.kind === typescript_1.SyntaxKind.ImportSpecifier)) === null || _g === void 0 ? void 0 : _g.map((node) => node === null || node === void 0 ? void 0 : node.getText());
                    return importedIdentifiers === null || importedIdentifiers === void 0 ? void 0 : importedIdentifiers.includes(componentName);
                });
                const fullPath = (_c = (_b = (_a = importStatement === null || importStatement === void 0 ? void 0 : importStatement.getChildren()) === null || _a === void 0 ? void 0 : _a.find((node) => node.kind === typescript_1.SyntaxKind.StringLiteral)) === null || _b === void 0 ? void 0 : _b.getText()) === null || _c === void 0 ? void 0 : _c.slice(1, -1);
                // if it is a directory, search recursively for the component
                let fullCmpImportPath = moduleFilePath === null || moduleFilePath === void 0 ? void 0 : moduleFilePath.slice(0, moduleFilePath === null || moduleFilePath === void 0 ? void 0 : moduleFilePath.lastIndexOf('/'));
                if (fullCmpImportPath === null || fullCmpImportPath === void 0 ? void 0 : fullCmpImportPath.startsWith('/')) {
                    fullCmpImportPath = fullCmpImportPath === null || fullCmpImportPath === void 0 ? void 0 : fullCmpImportPath.slice(1, fullCmpImportPath.length);
                }
                let componentImportPath = (0, path_1.join)((0, path_1.normalize)(fullCmpImportPath), fullPath);
                let path = null;
                let componentFileName = null;
                let componentStoryPath = null;
                let storyExists = false;
                let componentExists = false;
                /**
                 * Here we want to remove the <component-name>.component
                 * part of the path, to just keep the
                 * apps/<project-name>/src/app/<component-name>
                 * or
                 * libs/<project-name>/src/lib/<component-name>
                 * part of the path
                 */
                componentImportPath = componentImportPath.slice(0, componentImportPath.lastIndexOf('/'));
                (0, devkit_1.visitNotIgnoredFiles)(tree, componentImportPath, (componentFilePath) => {
                    if (componentFilePath === null || componentFilePath === void 0 ? void 0 : componentFilePath.endsWith('.ts')) {
                        const content = tree.read(componentFilePath).toString('utf-8');
                        if ((content === null || content === void 0 ? void 0 : content.indexOf(`class ${componentName}`)) > -1) {
                            componentExists = true;
                            path = componentFilePath;
                            componentFileName =
                                (componentFilePath === null || componentFilePath === void 0 ? void 0 : componentFilePath.slice((componentFilePath === null || componentFilePath === void 0 ? void 0 : componentFilePath.lastIndexOf('/')) + 1, componentFilePath === null || componentFilePath === void 0 ? void 0 : componentFilePath.lastIndexOf('.'))) + '.ts';
                        }
                        if (componentFilePath === null || componentFilePath === void 0 ? void 0 : componentFilePath.endsWith('.stories.ts')) {
                            componentStoryPath = componentFilePath;
                            storyExists = true;
                        }
                    }
                });
                if (!storyExists || !componentExists) {
                    path = null;
                    componentFileName = null;
                    componentStoryPath = null;
                }
                if (path !== null) {
                    return {
                        componentName: componentName,
                        componentPath: path,
                        componentFileName,
                        componentStoryPath: componentStoryPath,
                    };
                }
                else {
                    const path = fullPath === null || fullPath === void 0 ? void 0 : fullPath.slice(0, fullPath === null || fullPath === void 0 ? void 0 : fullPath.lastIndexOf('/'));
                    const componentFileName = (fullPath === null || fullPath === void 0 ? void 0 : fullPath.slice((fullPath === null || fullPath === void 0 ? void 0 : fullPath.lastIndexOf('/')) + 1)) + '.ts';
                    componentStoryPath = fullPath + '.stories.ts';
                    if ((0, fileutils_1.fileExists)(componentStoryPath)) {
                        return {
                            componentName: componentName,
                            componentPath: path + componentFileName,
                            componentFileName,
                            componentStoryPath: componentStoryPath,
                        };
                    }
                    else {
                        return undefined;
                    }
                }
            }
            catch (e) {
                devkit_1.logger.warn(`Could not find file for ${componentName}. Error: ${e}`);
                return undefined;
            }
        });
        if (componentInfo) {
            componentInfo = componentInfo === null || componentInfo === void 0 ? void 0 : componentInfo.filter((info) => info !== undefined);
            componentFileInfos = [...componentFileInfos, ...componentInfo];
        }
    });
    return componentFileInfos;
}
function changeSyntaxOfStory(tree, storyFilePath) {
    var _a, _b, _c;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const file = (0, utilities_1.getTsSourceFile)(tree, storyFilePath);
        const appFileContent = tree.read(storyFilePath, 'utf-8');
        let newContents = appFileContent;
        const storiesVariableDeclaration = (0, find_nodes_1.findNodes)(file, [
            ts.SyntaxKind.VariableDeclaration,
        ]);
        const storiesExportDefault = (0, find_nodes_1.findNodes)(file, [
            ts.SyntaxKind.ExportAssignment,
        ]);
        const defaultExportNode = storiesExportDefault[0];
        const defaultExportObject = (_a = defaultExportNode === null || defaultExportNode === void 0 ? void 0 : defaultExportNode.getChildren()) === null || _a === void 0 ? void 0 : _a.find((node) => {
            return node.kind === typescript_1.SyntaxKind.ObjectLiteralExpression;
        });
        const defaultPropertiesList = (_b = defaultExportObject === null || defaultExportObject === void 0 ? void 0 : defaultExportObject.getChildren()) === null || _b === void 0 ? void 0 : _b.find((node) => {
            return node.kind === typescript_1.SyntaxKind.SyntaxList;
        });
        const hasTitle = (_c = defaultPropertiesList === null || defaultPropertiesList === void 0 ? void 0 : defaultPropertiesList.getChildren()) === null || _c === void 0 ? void 0 : _c.find((node) => {
            return (node.kind === typescript_1.SyntaxKind.PropertyAssignment &&
                node.getText().startsWith('title'));
        });
        /**
         * A component node will look like this:
         *
         * component: MyTestComponent
         *
         * And this is what we need to remove.
         */
        let firstComponentNode;
        /**
         * The result of ts.Node.getStart() will give us the index
         * of that node in the whole original file.
         * While we're editing that file, the getStart() will
         * still reference the original file. So, during deletion,
         * it would go and delete characters using the original index.
         *
         * We need to save the length of the characters that have been removed
         * so far, so that we can substract it from the index.
         * Since it's parsing the file linearly and in order, then this
         * logic works.
         *  */
        let lengthOfRemovalsSoFar = 0;
        storiesVariableDeclaration === null || storiesVariableDeclaration === void 0 ? void 0 : storiesVariableDeclaration.forEach((oneStory) => {
            var _a, _b, _c, _d, _e, _f;
            const oneExportedStoryArrowFunction = (_a = oneStory === null || oneStory === void 0 ? void 0 : oneStory.getChildren()) === null || _a === void 0 ? void 0 : _a.find((node) => {
                return node.kind === typescript_1.SyntaxKind.ArrowFunction;
            });
            const inParenthesis = (_b = oneExportedStoryArrowFunction === null || oneExportedStoryArrowFunction === void 0 ? void 0 : oneExportedStoryArrowFunction.getChildren()) === null || _b === void 0 ? void 0 : _b.find((node) => {
                return node.kind === typescript_1.SyntaxKind.ParenthesizedExpression;
            });
            const objectLiteralOfStory = (_c = inParenthesis === null || inParenthesis === void 0 ? void 0 : inParenthesis.getChildren()) === null || _c === void 0 ? void 0 : _c.find((node) => {
                return node.kind === typescript_1.SyntaxKind.ObjectLiteralExpression;
            });
            const propertiesList = (_d = objectLiteralOfStory === null || objectLiteralOfStory === void 0 ? void 0 : objectLiteralOfStory.getChildren()) === null || _d === void 0 ? void 0 : _d.find((node) => {
                return node.kind === typescript_1.SyntaxKind.SyntaxList;
            });
            const hasComponentDeclared = (_e = propertiesList === null || propertiesList === void 0 ? void 0 : propertiesList.getChildren()) === null || _e === void 0 ? void 0 : _e.find((node) => {
                return (node.kind === typescript_1.SyntaxKind.PropertyAssignment &&
                    node.getText().startsWith('component'));
            });
            if (hasComponentDeclared) {
                /**
                 * Here I am saving the first component to appear
                 * in the case where we have multiple stories
                 */
                if (!firstComponentNode) {
                    firstComponentNode = hasComponentDeclared;
                }
                /**
                 * Here we are performing the following check:
                 * If the component we will be adding in the default declaration
                 * which is the first component that we find
                 * is the same for this story as well,
                 * then remove it.
                 */
                if (hasComponentDeclared.getText() === firstComponentNode.getText()) {
                    const indexOfPropertyName = hasComponentDeclared.getStart();
                    const lengthOfRemoval = ((_f = hasComponentDeclared === null || hasComponentDeclared === void 0 ? void 0 : hasComponentDeclared.getText()) === null || _f === void 0 ? void 0 : _f.length) + 1;
                    newContents = (0, devkit_1.applyChangesToString)(newContents, [
                        {
                            type: devkit_1.ChangeType.Delete,
                            start: indexOfPropertyName - lengthOfRemovalsSoFar,
                            length: lengthOfRemoval,
                        },
                    ]);
                    lengthOfRemovalsSoFar = lengthOfRemovalsSoFar + lengthOfRemoval;
                }
            }
        });
        if (hasTitle && firstComponentNode) {
            const indexOfPropertyName = hasTitle.getEnd();
            newContents = (0, devkit_1.applyChangesToString)(newContents, [
                {
                    type: devkit_1.ChangeType.Insert,
                    index: indexOfPropertyName + 2,
                    text: firstComponentNode.getText() + ',',
                },
            ]);
            tree.write(storyFilePath, newContents);
        }
        yield (0, devkit_1.formatFiles)(tree);
    });
}
//# sourceMappingURL=migrate-stories-to-6-2.js.map