"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updatePackageJson = void 0;
const path_1 = require("path");
const buildable_libs_utils_1 = require("@nrwl/workspace/src/utilities/buildable-libs-utils");
const fileutils_1 = require("nx/src/utils/fileutils");
function updatePackageJson(options, context, target, dependencies, packageJson) {
    const hasEsmFormat = options.format.includes('esm');
    const hasCjsFormat = options.format.includes('umd') || options.format.includes('cjs');
    const types = `./${(0, path_1.relative)(options.entryRoot, options.entryFile).replace(/\.[jt]sx?$/, '.d.ts')}`;
    const exports = {
        // TS 4.5+
        '.': {
            types,
        },
    };
    if (hasEsmFormat) {
        // `module` field is used by bundlers like rollup and webpack to detect ESM.
        // May not be required in the future if type is already "module".
        packageJson.module = './index.js';
        exports['.']['import'] = './index.js';
        if (!hasCjsFormat) {
            packageJson.main = './index.js';
        }
    }
    if (hasCjsFormat) {
        packageJson.main = './index.cjs';
        exports['.']['require'] = './index.cjs';
    }
    if (!options.skipTypeField) {
        packageJson.type = options.format.includes('esm') ? 'module' : 'commonjs';
    }
    // Support for older TS versions < 4.5
    packageJson.types = types;
    // TODO(jack): remove this for Nx 15
    if (options.generateExportsField) {
        packageJson.exports = Object.assign(Object.assign({}, packageJson.exports), exports);
    }
    (0, fileutils_1.writeJsonFile)(`${options.outputPath}/package.json`, packageJson);
    if (dependencies.length > 0 &&
        options.updateBuildableProjectDepsInPackageJson) {
        (0, buildable_libs_utils_1.updateBuildableProjectPackageJsonDependencies)(context.root, context.projectName, context.targetName, context.configurationName, target, dependencies, options.buildableProjectDepsInPackageJsonType);
    }
}
exports.updatePackageJson = updatePackageJson;
//# sourceMappingURL=update-package-json.js.map