"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.npm7 = void 0;

require("core-js/modules/es.promise.js");

var _chalk = _interopRequireDefault(require("chalk"));

var _tsDedent = _interopRequireDefault(require("ts-dedent"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Is the user using npm7+? If so create a .npmrc with legacy-peer-deps=true
 */
const npm7 = {
  id: 'npm7',

  async check({
    packageManager
  }) {
    if (packageManager.type !== 'npm') return null;
    const npmVersion = packageManager.getNpmVersion();

    if (packageManager.needsLegacyPeerDeps(npmVersion)) {
      return {
        npmVersion
      };
    }

    return null;
  },

  prompt({
    npmVersion
  }) {
    const npmFormatted = _chalk.default.cyan(`npm ${npmVersion}`);

    return (0, _tsDedent.default)`
      We've detected you are running ${npmFormatted} which has peer dependency semantics which Storybook is incompatible with.

      In order to work with Storybook's package structure, you'll need to run \`npm\` with the
      \`--legacy-peer-deps=true\` flag. We can generate an \`.npmrc\` which will do that automatically.
      
      More info: ${_chalk.default.yellow('https://github.com/storybookjs/storybook/issues/18298')}
    `;
  },

  async run({
    packageManager
  }) {
    packageManager.setLegacyPeerDeps();
  }

};
exports.npm7 = npm7;