import { Configuration } from 'webpack';
export declare function webpackFinal(config: Configuration): Promise<{
    plugins: import("webpack").Plugin[];
    mode?: "none" | "production" | "development";
    name?: string;
    context?: string;
    entry?: string | string[] | import("webpack").Entry | import("webpack").EntryFunc;
    devtool?: string | boolean;
    output?: import("webpack").Output;
    module?: import("webpack").Module;
    resolve?: import("webpack").Resolve;
    resolveLoader?: import("webpack").ResolveLoader;
    externals?: string | RegExp | import("webpack").ExternalsObjectElement | import("webpack").ExternalsFunctionElement | import("webpack").ExternalsElement[];
    target?: "node" | "web" | "webworker" | "async-node" | "node-webkit" | "atom" | "electron" | "electron-renderer" | "electron-preload" | "electron-main" | ((compiler?: any) => void);
    bail?: boolean;
    profile?: boolean;
    cache?: boolean | object;
    watch?: boolean;
    watchOptions?: import("webpack").ICompiler.WatchOptions;
    node?: false | import("webpack").Node;
    amd?: {
        [moduleName: string]: boolean;
    };
    recordsPath?: string;
    recordsInputPath?: string;
    recordsOutputPath?: string;
    stats?: import("webpack").Stats.ToStringOptions;
    performance?: false | import("webpack").Options.Performance;
    parallelism?: number;
    optimization?: import("webpack").Options.Optimization;
    infrastructureLogging?: import("webpack").Options.InfrastructureLogging;
}>;
