import { Headers } from 'headers-utils';
import { MockedResponse, ResponseComposition } from '../response';
import { set } from '../context/set';
import { ResponseResolutionContext } from '../utils/getResponse';
import { SerializedResponse } from '../setupWorker/glossary';
export declare const defaultContext: {
    status: (statusCode: number, statusText?: string | undefined) => import("../response").ResponseTransformer<any, any>;
    set: typeof set;
    delay: (durationOrMode?: number | import("../context/delay").DelayMode | undefined) => import("../response").ResponseTransformer<any, any>;
    fetch: (input: string | MockedRequest<DefaultRequestBody>, requestInit?: RequestInit) => Promise<Response>;
};
export declare type DefaultRequestMultipartBody = Record<string, string | File | (string | File)[]>;
export declare type DefaultRequestBody = Record<string, any> | DefaultRequestMultipartBody | string | number | boolean | null | undefined;
export interface MockedRequest<Body = DefaultRequestBody> {
    id: string;
    url: URL;
    method: Request['method'];
    headers: Headers;
    cookies: Record<string, string>;
    mode: Request['mode'];
    keepalive: Request['keepalive'];
    cache: Request['cache'];
    destination: Request['destination'];
    integrity: Request['integrity'];
    credentials: Request['credentials'];
    redirect: Request['redirect'];
    referrer: Request['referrer'];
    referrerPolicy: Request['referrerPolicy'];
    body: Body;
    bodyUsed: Request['bodyUsed'];
}
export interface RequestHandlerDefaultInfo {
    header: string;
}
export interface RequestHandlerInternalInfo {
    callFrame?: string;
}
declare type ContextMap = Record<string, (...args: any[]) => any>;
export declare type ResponseResolverReturnType<ReturnType> = ReturnType | undefined | void;
export declare type MaybeAsyncResponseResolverReturnType<ReturnType> = ResponseResolverReturnType<ReturnType> | Promise<ResponseResolverReturnType<ReturnType>>;
export declare type AsyncResponseResolverReturnType<ReturnType> = MaybeAsyncResponseResolverReturnType<ReturnType> | Generator<MaybeAsyncResponseResolverReturnType<ReturnType>, MaybeAsyncResponseResolverReturnType<ReturnType>, MaybeAsyncResponseResolverReturnType<ReturnType>>;
export declare type ResponseResolver<RequestType = MockedRequest, ContextType = typeof defaultContext, BodyType = any> = (req: RequestType, res: ResponseComposition<BodyType>, context: ContextType) => AsyncResponseResolverReturnType<MockedResponse<BodyType>>;
export interface RequestHandlerOptions<HandlerInfo> {
    info: HandlerInfo;
    resolver: ResponseResolver<any, any>;
    ctx?: ContextMap;
}
export interface RequestHandlerExecutionResult<PublicRequestType> {
    handler: RequestHandler;
    parsedResult: any;
    request: PublicRequestType;
    response?: MockedResponse;
}
export declare abstract class RequestHandler<HandlerInfo extends RequestHandlerDefaultInfo = RequestHandlerDefaultInfo, Request extends MockedRequest = MockedRequest, ParsedResult = any, PublicRequest extends MockedRequest = Request> {
    info: HandlerInfo & RequestHandlerInternalInfo;
    shouldSkip: boolean;
    private ctx;
    private resolverGenerator?;
    private resolverGeneratorResult?;
    protected resolver: ResponseResolver<any, any>;
    constructor(options: RequestHandlerOptions<HandlerInfo>);
    /**
     * Determine if the captured request should be mocked.
     */
    abstract predicate(request: MockedRequest, parsedResult: ParsedResult, resolutionContext?: ResponseResolutionContext): boolean;
    /**
     * Print out the successfully handled request.
     */
    abstract log(request: Request, response: SerializedResponse<any>, handler: this, parsedResult: ParsedResult): void;
    /**
     * Parse the captured request to extract additional information from it.
     * Parsed result is then exposed to other methods of this request handler.
     */
    parse(_request: MockedRequest, _resolutionContext?: ResponseResolutionContext): ParsedResult;
    /**
     * Test if this handler matches the given request.
     */
    test(request: MockedRequest, resolutionContext?: ResponseResolutionContext): boolean;
    /**
     * Derive the publicly exposed request (`req`) instance of the response resolver
     * from the captured request and its parsed result.
     */
    protected getPublicRequest(request: MockedRequest, _parsedResult: ParsedResult): PublicRequest;
    markAsSkipped(shouldSkip?: boolean): void;
    /**
     * Execute this request handler and produce a mocked response
     * using the given resolver function.
     */
    run(request: MockedRequest, resolutionContext?: ResponseResolutionContext): Promise<RequestHandlerExecutionResult<PublicRequest> | null>;
    private wrapResolver;
    private createExecutionResult;
}
export {};
