"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports["default"] = void 0;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRedux = require("react-redux");

var _createFieldProps2 = _interopRequireDefault(require("./createFieldProps"));

var _onChangeValue = _interopRequireDefault(require("./events/onChangeValue"));

var _eventConsts = require("./util/eventConsts");

var _plain = _interopRequireDefault(require("./structure/plain"));

var _isReactNative = _interopRequireDefault(require("./isReactNative"));

var _validateComponentProp = _interopRequireDefault(require("./util/validateComponentProp"));

var _isEvent = _interopRequireDefault(require("./events/isEvent"));

var propsToNotUpdateFor = ['_reduxForm'];

var isObject = function isObject(entity) {
  return entity && typeof entity === 'object';
};

var isFunction = function isFunction(entity) {
  return entity && typeof entity === 'function';
};

var eventPreventDefault = function eventPreventDefault(event) {
  if (isObject(event) && isFunction(event.preventDefault)) {
    event.preventDefault();
  }
};

var eventDataTransferGetData = function eventDataTransferGetData(event, key) {
  if (isObject(event) && isObject(event.dataTransfer) && isFunction(event.dataTransfer.getData)) {
    return event.dataTransfer.getData(key);
  }
};

var eventDataTransferSetData = function eventDataTransferSetData(event, key, value) {
  if (isObject(event) && isObject(event.dataTransfer) && isFunction(event.dataTransfer.setData)) {
    event.dataTransfer.setData(key, value);
  }
};

function createConnectedField(structure) {
  var deepEqual = structure.deepEqual,
      getIn = structure.getIn;

  var getSyncError = function getSyncError(syncErrors, name) {
    var error = _plain["default"].getIn(syncErrors, name); // Because the error for this field might not be at a level in the error structure where
    // it can be set directly, it might need to be unwrapped from the _error property


    return error && error._error ? error._error : error;
  };

  var getSyncWarning = function getSyncWarning(syncWarnings, name) {
    var warning = getIn(syncWarnings, name); // Because the warning for this field might not be at a level in the warning structure where
    // it can be set directly, it might need to be unwrapped from the _warning property

    return warning && warning._warning ? warning._warning : warning;
  };

  var ConnectedField = /*#__PURE__*/function (_Component) {
    (0, _inheritsLoose2["default"])(ConnectedField, _Component);

    function ConnectedField() {
      var _this;

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _Component.call.apply(_Component, [this].concat(args)) || this;
      _this.ref = _react["default"].createRef();

      _this.isPristine = function () {
        return _this.props.pristine;
      };

      _this.getValue = function () {
        return _this.props.value;
      };

      _this.handleChange = function (event) {
        var _this$props = _this.props,
            name = _this$props.name,
            dispatch = _this$props.dispatch,
            parse = _this$props.parse,
            normalize = _this$props.normalize,
            onChange = _this$props.onChange,
            _reduxForm = _this$props._reduxForm,
            previousValue = _this$props.value;
        var newValue = (0, _onChangeValue["default"])(event, {
          name: name,
          parse: parse,
          normalize: normalize
        });
        var defaultPrevented = false;

        if (onChange) {
          // Can't seem to find a way to extend Event in React Native,
          // thus I simply avoid adding preventDefault() in a RN environment
          // to prevent the following error:
          // `One of the sources for assign has an enumerable key on the prototype chain`
          // Reference: https://github.com/facebook/react-native/issues/5507
          if (!_isReactNative["default"] && (0, _isEvent["default"])(event)) {
            onChange((0, _extends2["default"])({}, event, {
              preventDefault: function preventDefault() {
                defaultPrevented = true;
                return eventPreventDefault(event);
              }
            }), newValue, previousValue, name);
          } else {
            var onChangeResult = onChange(event, newValue, previousValue, name); // Return value of change handler affecting preventDefault is RN
            // specific behavior.

            if (_isReactNative["default"]) {
              defaultPrevented = onChangeResult;
            }
          }
        }

        if (!defaultPrevented) {
          // dispatch change action
          dispatch(_reduxForm.change(name, newValue)); // call post-change callback

          if (_reduxForm.asyncValidate) {
            _reduxForm.asyncValidate(name, newValue, 'change');
          }
        }
      };

      _this.handleFocus = function (event) {
        var _this$props2 = _this.props,
            name = _this$props2.name,
            dispatch = _this$props2.dispatch,
            onFocus = _this$props2.onFocus,
            _reduxForm = _this$props2._reduxForm;
        var defaultPrevented = false;

        if (onFocus) {
          if (!_isReactNative["default"]) {
            onFocus((0, _extends2["default"])({}, event, {
              preventDefault: function preventDefault() {
                defaultPrevented = true;
                return eventPreventDefault(event);
              }
            }), name);
          } else {
            defaultPrevented = onFocus(event, name);
          }
        }

        if (!defaultPrevented) {
          dispatch(_reduxForm.focus(name));
        }
      };

      _this.handleBlur = function (event) {
        var _this$props3 = _this.props,
            name = _this$props3.name,
            dispatch = _this$props3.dispatch,
            parse = _this$props3.parse,
            normalize = _this$props3.normalize,
            onBlur = _this$props3.onBlur,
            _reduxForm = _this$props3._reduxForm,
            _value = _this$props3._value,
            previousValue = _this$props3.value;
        var newValue = (0, _onChangeValue["default"])(event, {
          name: name,
          parse: parse,
          normalize: normalize
        }); // for checkbox and radio, if the value property of checkbox or radio equals
        // the value passed by blur event, then fire blur action with previousValue.

        if (newValue === _value && _value !== undefined) {
          newValue = previousValue;
        }

        var defaultPrevented = false;

        if (onBlur) {
          if (!_isReactNative["default"]) {
            onBlur((0, _extends2["default"])({}, event, {
              preventDefault: function preventDefault() {
                defaultPrevented = true;
                return eventPreventDefault(event);
              }
            }), newValue, previousValue, name);
          } else {
            defaultPrevented = onBlur(event, newValue, previousValue, name);
          }
        }

        if (!defaultPrevented) {
          // dispatch blur action
          dispatch(_reduxForm.blur(name, newValue)); // call post-blur callback

          if (_reduxForm.asyncValidate) {
            _reduxForm.asyncValidate(name, newValue, 'blur');
          }
        }
      };

      _this.handleDragStart = function (event) {
        var _this$props4 = _this.props,
            name = _this$props4.name,
            onDragStart = _this$props4.onDragStart,
            value = _this$props4.value;
        eventDataTransferSetData(event, _eventConsts.dataKey, value == null ? '' : value);

        if (onDragStart) {
          onDragStart(event, name);
        }
      };

      _this.handleDrop = function (event) {
        var _this$props5 = _this.props,
            name = _this$props5.name,
            dispatch = _this$props5.dispatch,
            onDrop = _this$props5.onDrop,
            _reduxForm = _this$props5._reduxForm,
            previousValue = _this$props5.value;
        var newValue = eventDataTransferGetData(event, _eventConsts.dataKey);
        var defaultPrevented = false;

        if (onDrop) {
          onDrop((0, _extends2["default"])({}, event, {
            preventDefault: function preventDefault() {
              defaultPrevented = true;
              return eventPreventDefault(event);
            }
          }), newValue, previousValue, name);
        }

        if (!defaultPrevented) {
          // dispatch change action
          dispatch(_reduxForm.change(name, newValue));
          eventPreventDefault(event);
        }
      };

      return _this;
    }

    var _proto = ConnectedField.prototype;

    _proto.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
      var _this2 = this;

      var nextPropsKeys = Object.keys(nextProps);
      var thisPropsKeys = Object.keys(this.props); // if we have children, we MUST update in React 16
      // https://twitter.com/erikras/status/915866544558788608

      return !!(this.props.children || nextProps.children || nextPropsKeys.length !== thisPropsKeys.length || nextPropsKeys.some(function (prop) {
        if (~(nextProps.immutableProps || []).indexOf(prop)) {
          return _this2.props[prop] !== nextProps[prop];
        }

        return !~propsToNotUpdateFor.indexOf(prop) && !deepEqual(_this2.props[prop], nextProps[prop]);
      }));
    };

    _proto.getRenderedComponent = function getRenderedComponent() {
      return this.ref.current;
    };

    _proto.render = function render() {
      var _this$props6 = this.props,
          component = _this$props6.component,
          forwardRef = _this$props6.forwardRef,
          name = _this$props6.name,
          _reduxForm = _this$props6._reduxForm,
          normalize = _this$props6.normalize,
          onBlur = _this$props6.onBlur,
          onChange = _this$props6.onChange,
          onFocus = _this$props6.onFocus,
          onDragStart = _this$props6.onDragStart,
          onDrop = _this$props6.onDrop,
          immutableProps = _this$props6.immutableProps,
          rest = (0, _objectWithoutPropertiesLoose2["default"])(_this$props6, ["component", "forwardRef", "name", "_reduxForm", "normalize", "onBlur", "onChange", "onFocus", "onDragStart", "onDrop", "immutableProps"]);

      var _createFieldProps = (0, _createFieldProps2["default"])(structure, name, (0, _extends2["default"])({}, rest, {
        form: _reduxForm.form,
        onBlur: this.handleBlur,
        onChange: this.handleChange,
        onDrop: this.handleDrop,
        onDragStart: this.handleDragStart,
        onFocus: this.handleFocus
      })),
          custom = _createFieldProps.custom,
          props = (0, _objectWithoutPropertiesLoose2["default"])(_createFieldProps, ["custom"]);

      if (forwardRef) {
        custom.ref = this.ref;
      }

      if (typeof component === 'string') {
        var input = props.input,
            meta = props.meta; // eslint-disable-line no-unused-vars
        // flatten input into other props

        return (0, _react.createElement)(component, (0, _extends2["default"])({}, input, {}, custom));
      } else {
        return (0, _react.createElement)(component, (0, _extends2["default"])({}, props, {}, custom));
      }
    };

    return ConnectedField;
  }(_react.Component);

  ConnectedField.propTypes = {
    component: _validateComponentProp["default"],
    props: _propTypes["default"].object
  };
  var connector = (0, _reactRedux.connect)(function (state, ownProps) {
    var name = ownProps.name,
        _ownProps$_reduxForm = ownProps._reduxForm,
        initialValues = _ownProps$_reduxForm.initialValues,
        getFormState = _ownProps$_reduxForm.getFormState;
    var formState = getFormState(state);
    var initialState = getIn(formState, "initial." + name);
    var initial = initialState !== undefined ? initialState : initialValues && getIn(initialValues, name);
    var value = getIn(formState, "values." + name);
    var submitting = getIn(formState, 'submitting');
    var syncError = getSyncError(getIn(formState, 'syncErrors'), name);
    var syncWarning = getSyncWarning(getIn(formState, 'syncWarnings'), name);
    var pristine = deepEqual(value, initial);
    return {
      asyncError: getIn(formState, "asyncErrors." + name),
      asyncValidating: getIn(formState, 'asyncValidating') === name,
      dirty: !pristine,
      pristine: pristine,
      state: getIn(formState, "fields." + name),
      submitError: getIn(formState, "submitErrors." + name),
      submitFailed: getIn(formState, 'submitFailed'),
      submitting: submitting,
      syncError: syncError,
      syncWarning: syncWarning,
      initial: initial,
      value: value,
      _value: ownProps.value // save value passed in (for radios)

    };
  }, undefined, undefined, {
    forwardRef: true
  });
  return connector(ConnectedField);
}

var _default = createConnectedField;
exports["default"] = _default;