/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/**
 * Class containing IDP Templates Page constants.
 */
export declare class IdentityProviderTemplatesPageConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    static readonly PAGE_URL_MATCHER: string;
    static readonly PAGE_LAYOUT_HEADER_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_TITLE_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_SUB_TITLE_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_BACK_BUTTON_DATA_ATTR: string;
    static readonly QUICK_START_TEMPLATE_GRID: string;
    static readonly MANUAL_SETUP_TEMPLATE_GRID: string;
    static readonly GOOGLE_IDP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly FACEBOOK_IDP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly OIDC_IDP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly EXPERT_IDP_TEMPLATE_CARD_DATA_ATTR: string;
    static readonly CREATION_WIZARD_DATA_ATTR: string;
    static readonly CREATION_WIZARD_IDP_NAME_INPUT_DATA_ATTR: string;
    static readonly CREATION_WIZARD_IDP_DESCRIPTION_DATA_ATTR: string;
    static readonly CREATION_WIZARD_IDP_IMAGE_DATA_ATTR: string;
    static readonly CREATION_WIZARD_NEXT_BUTTON_DATA_ATTR: string;
    static readonly CREATION_WIZARD_FINISH_BUTTON_DATA_ATTR: string;
    static readonly CREATION_WIZARD_CANCEL_BUTTON_DATA_ATTR: string;
}
