/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.util;

public class AppPortalConstants {
    public static final String INBOUND_AUTH2_TYPE = "oauth2";
    public static final String EMAIL_CLAIM_URI = "http://wso2.org/claims/emailaddress";
    public static final String DISPLAY_NAME_CLAIM_URI = "http://wso2.org/claims/displayName";
    public static final String TOKEN_BINDING_TYPE_COOKIE = "cookie";
    public static final String GRANT_TYPE_ACCOUNT_SWITCH = "account_switch";

    private AppPortalConstants() {
    }

    public static enum AppPortal {
        USER_PORTAL("User Portal", "This is the user portal application.", "USER_PORTAL", "/user-portal/login"),
        ADMIN_PORTAL("Admin Portal", "This is the admin portal application.", "ADMIN_PORTAL", "/admin-portal/login");

        private final String name;
        private final String description;
        private final String consumerKey;
        private final String path;

        private AppPortal(String name, String description, String consumerKey, String path) {
            this.name = name;
            this.description = description;
            this.consumerKey = consumerKey;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public String getPath() {
            return this.path;
        }
    }
}

