/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.util;

public class AppPortalConstants {
    public static final String INBOUND_AUTH2_TYPE = "oauth2";
    public static final String INBOUND_CONFIG_TYPE = "standardAPP";
    public static final String EMAIL_CLAIM_URI = "http://wso2.org/claims/emailaddress";
    public static final String DISPLAY_NAME_CLAIM_URI = "http://wso2.org/claims/displayName";
    public static final String TOKEN_BINDING_TYPE_COOKIE = "cookie";
    public static final String GRANT_TYPE_ACCOUNT_SWITCH = "account_switch";
    public static final String SYSTEM_PROP_SKIP_SERVER_INITIALIZATION = "skipServerInitialization";

    private AppPortalConstants() {
    }

    public static enum AppPortal {
        MY_ACCOUNT("My Account", "This is the my account application.", "MY_ACCOUNT", "/myaccount", "/myaccount/"),
        CONSOLE("Console", "This is the console application.", "CONSOLE", "/console", "/console/");

        private final String name;
        private final String description;
        private final String consumerKey;
        private final String path;
        private final String endpoint;

        private AppPortal(String name, String description, String consumerKey, String path, String endpoint) {
            this.name = name;
            this.description = description;
            this.consumerKey = consumerKey;
            this.path = path;
            this.endpoint = endpoint;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public String getPath() {
            return this.path;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

