/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;
import org.wso2.identity.apps.common.util.AppPortalConstants;

public class AppPortalUtils {
    private AppPortalUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOAuth2Application(String applicationName, String portalPath, String consumerKey, String consumerSecret, String appOwner, int tenantId, String tenantDomain, String bindingType, List<String> grantTypes) throws IdentityOAuthAdminException {
        OAuthConsumerAppDTO oAuthConsumerAppDTO = new OAuthConsumerAppDTO();
        oAuthConsumerAppDTO.setApplicationName(applicationName);
        oAuthConsumerAppDTO.setOAuthVersion("OAuth-2.0");
        oAuthConsumerAppDTO.setOauthConsumerKey(consumerKey);
        oAuthConsumerAppDTO.setOauthConsumerSecret(consumerSecret);
        String callbackUrl = IdentityUtil.getServerURL((String)portalPath, (boolean)true, (boolean)true);
        callbackUrl = !"carbon.super".equals(tenantDomain) ? callbackUrl.replace(portalPath, "/t/" + tenantDomain.trim() + portalPath) : (StringUtils.equals((String)"Console", (String)applicationName) && AppsCommonDataHolder.getInstance().isOrganizationManagementEnabled() ? "regexp=(" + callbackUrl + "|" + callbackUrl.replace(portalPath, "/t/(.*)" + portalPath) + "|" + callbackUrl.replace(portalPath, "/o/(.*)" + portalPath) + ")" : "regexp=(" + callbackUrl + "|" + callbackUrl.replace(portalPath, "/t/(.*)" + portalPath) + ")");
        oAuthConsumerAppDTO.setCallbackUrl(callbackUrl);
        oAuthConsumerAppDTO.setBypassClientCredentials(true);
        if (grantTypes != null && !grantTypes.isEmpty()) {
            oAuthConsumerAppDTO.setGrantTypes(String.join((CharSequence)" ", grantTypes));
        }
        oAuthConsumerAppDTO.setPkceMandatory(true);
        oAuthConsumerAppDTO.setTokenBindingType(bindingType);
        oAuthConsumerAppDTO.setTokenBindingValidationEnabled(true);
        oAuthConsumerAppDTO.setTokenRevocationWithIDPSessionTerminationEnabled(true);
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(tenantId);
            privilegedCarbonContext.setTenantDomain(tenantDomain);
            privilegedCarbonContext.setUsername(appOwner);
            AppsCommonDataHolder.getInstance().getOAuthAdminService().registerOAuthApplicationData(oAuthConsumerAppDTO);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Deprecated
    public static void createApplication(String appName, String appOwner, String appDescription, String consumerKey, String consumerSecret, String tenantDomain) throws IdentityApplicationManagementException {
        AppPortalUtils.createApplication(appName, appOwner, appDescription, consumerKey, consumerSecret, tenantDomain, "");
    }

    public static void createApplication(String appName, String appOwner, String appDescription, String consumerKey, String consumerSecret, String tenantDomain, String portalPath) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = new ServiceProvider();
        serviceProvider.setApplicationName(appName);
        serviceProvider.setDescription(appDescription);
        serviceProvider.setSaasApp(true);
        serviceProvider.setManagementApp(true);
        if (StringUtils.isNotEmpty((String)portalPath)) {
            serviceProvider.setAccessUrl(IdentityUtil.getServerURL((String)portalPath, (boolean)true, (boolean)true));
        }
        InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = new InboundAuthenticationRequestConfig();
        inboundAuthenticationRequestConfig.setInboundAuthKey(consumerKey);
        inboundAuthenticationRequestConfig.setInboundAuthType("oauth2");
        inboundAuthenticationRequestConfig.setInboundConfigType("standardAPP");
        List<InboundAuthenticationRequestConfig> inboundAuthenticationRequestConfigs = Arrays.asList(inboundAuthenticationRequestConfig);
        InboundAuthenticationConfig inboundAuthenticationConfig = new InboundAuthenticationConfig();
        inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs(inboundAuthenticationRequestConfigs.toArray(new InboundAuthenticationRequestConfig[0]));
        serviceProvider.setInboundAuthenticationConfig(inboundAuthenticationConfig);
        LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = new LocalAndOutboundAuthenticationConfig();
        localAndOutboundAuthenticationConfig.setUseUserstoreDomainInLocalSubjectIdentifier(true);
        localAndOutboundAuthenticationConfig.setUseTenantDomainInLocalSubjectIdentifier(true);
        localAndOutboundAuthenticationConfig.setSkipConsent(true);
        localAndOutboundAuthenticationConfig.setSkipLogoutConsent(true);
        if ("Console".equals(appName) && AppsCommonDataHolder.getInstance().isOrganizationManagementEnabled()) {
            AuthenticationStep authenticationStep1 = new AuthenticationStep();
            LocalAuthenticatorConfig identifierFirst = new LocalAuthenticatorConfig();
            identifierFirst.setName("IdentifierExecutor");
            identifierFirst.setDisplayName("identifier-first");
            authenticationStep1.setLocalAuthenticatorConfigs(new LocalAuthenticatorConfig[]{identifierFirst});
            authenticationStep1.setSubjectStep(false);
            authenticationStep1.setAttributeStep(false);
            authenticationStep1.setStepOrder(1);
            AuthenticationStep authenticationStep2 = new AuthenticationStep();
            LocalAuthenticatorConfig basic = new LocalAuthenticatorConfig();
            basic.setName("BasicAuthenticator");
            basic.setDisplayName("basic");
            authenticationStep2.setLocalAuthenticatorConfigs(new LocalAuthenticatorConfig[]{basic});
            authenticationStep2.setAttributeStep(true);
            authenticationStep2.setSubjectStep(true);
            authenticationStep2.setStepOrder(2);
            localAndOutboundAuthenticationConfig.setAuthenticationType("flow");
            localAndOutboundAuthenticationConfig.setAuthenticationSteps(new AuthenticationStep[]{authenticationStep1, authenticationStep2});
        }
        serviceProvider.setLocalAndOutBoundAuthenticationConfig(localAndOutboundAuthenticationConfig);
        ClaimConfig claimConfig = new ClaimConfig();
        claimConfig.setClaimMappings(AppPortalUtils.getRequestedClaimMappings());
        claimConfig.setLocalClaimDialect(true);
        serviceProvider.setClaimConfig(claimConfig);
        AppsCommonDataHolder.getInstance().getApplicationManagementService().createApplication(serviceProvider, tenantDomain, appOwner);
    }

    private static ClaimMapping[] getRequestedClaimMappings() {
        Claim emailClaim = new Claim();
        emailClaim.setClaimUri("http://wso2.org/claims/emailaddress");
        ClaimMapping emailClaimMapping = new ClaimMapping();
        emailClaimMapping.setRequested(true);
        emailClaimMapping.setLocalClaim(emailClaim);
        emailClaimMapping.setRemoteClaim(emailClaim);
        Claim displayNameClaim = new Claim();
        displayNameClaim.setClaimUri("http://wso2.org/claims/displayName");
        ClaimMapping displayNameClaimMapping = new ClaimMapping();
        displayNameClaimMapping.setRequested(true);
        displayNameClaimMapping.setLocalClaim(displayNameClaim);
        displayNameClaimMapping.setRemoteClaim(displayNameClaim);
        Claim usernameClaim = new Claim();
        usernameClaim.setClaimUri("http://wso2.org/claims/username");
        ClaimMapping usernameClaimMapping = new ClaimMapping();
        usernameClaimMapping.setRequested(true);
        usernameClaimMapping.setLocalClaim(usernameClaim);
        usernameClaimMapping.setRemoteClaim(usernameClaim);
        return new ClaimMapping[]{emailClaimMapping, displayNameClaimMapping, usernameClaimMapping};
    }

    public static void initiatePortals(String tenantDomain, int tenantId) throws IdentityApplicationManagementException, IdentityOAuthAdminException, RegistryException, UserStoreException {
        ApplicationManagementService applicationMgtService = AppsCommonDataHolder.getInstance().getApplicationManagementService();
        UserRealm userRealm = AppsCommonDataHolder.getInstance().getRegistryService().getUserRealm(tenantId);
        String adminUsername = userRealm.getRealmConfiguration().getAdminUserName();
        for (AppPortalConstants.AppPortal appPortal : AppPortalConstants.AppPortal.values()) {
            if (applicationMgtService.getApplicationExcludingFileBasedSPs(appPortal.getName(), tenantDomain) != null) continue;
            String consumerSecret = OAuthUtil.getRandomNumber();
            List<String> grantTypes = Arrays.asList("authorization_code", "refresh_token", "account_switch");
            if ("Console".equals(appPortal.getName())) {
                grantTypes = Arrays.asList("authorization_code", "refresh_token", "account_switch", "organization_switch");
            }
            List<String> allowedGrantTypes = Arrays.asList(AppsCommonDataHolder.getInstance().getOAuthAdminService().getAllowedGrantTypes());
            grantTypes = grantTypes.stream().filter(allowedGrantTypes::contains).collect(Collectors.toList());
            String consumerKey = appPortal.getConsumerKey();
            if (!"carbon.super".equals(tenantDomain)) {
                consumerKey = consumerKey + "_" + tenantDomain;
            }
            try {
                AppPortalUtils.createOAuth2Application(appPortal.getName(), appPortal.getPath(), consumerKey, consumerSecret, adminUsername, tenantId, tenantDomain, "cookie", grantTypes);
            }
            catch (IdentityOAuthAdminException e) {
                if ("Error when adding the application. An application with the same name already exists.".equals(e.getMessage())) continue;
                throw e;
            }
            AppPortalUtils.createApplication(appPortal.getName(), adminUsername, appPortal.getDescription(), consumerKey, consumerSecret, tenantDomain, appPortal.getPath());
        }
    }

    public static InboundAuthenticationRequestConfig getOAuthInboundAuthenticationRequestConfig(ServiceProvider application) {
        if (application == null || application.getInboundAuthenticationConfig() == null || application.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() == null || application.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs().length == 0) {
            return null;
        }
        for (InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig : application.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
            if (!"oauth2".equals(inboundAuthenticationRequestConfig.getInboundAuthType())) continue;
            return inboundAuthenticationRequestConfig;
        }
        return null;
    }
}

