/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.internal;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.identity.api.resource.mgt.APIResourceManager;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.organization.management.application.OrgApplicationManager;
import org.wso2.carbon.identity.organization.management.service.OrganizationManagementInitialize;
import org.wso2.carbon.identity.role.v2.mgt.core.RoleManagementService;
import org.wso2.carbon.identity.role.v2.mgt.core.listener.RoleManagementListener;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;
import org.wso2.identity.apps.common.internal.AppsCommonServiceStartupObserver;
import org.wso2.identity.apps.common.listner.AppPortalApplicationMgtListener;
import org.wso2.identity.apps.common.listner.AppPortalOAuthAppMgtListener;
import org.wso2.identity.apps.common.listner.AppPortalRoleManagementListener;
import org.wso2.identity.apps.common.listner.AppPortalTenantMgtListener;
import org.wso2.identity.apps.common.util.AppPortalUtils;

@Component(name="org.wso2.identity.apps.common.AppsCommonServiceComponent", immediate=true, property={"componentName=identity-apps-common"})
public class AppsCommonServiceComponent {
    private static Log log = LogFactory.getLog(AppsCommonServiceComponent.class);

    @Activate
    protected void activate(BundleContext bundleContext) {
        try {
            Set<String> systemApplications;
            if (this.skipPortalInitialization()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Portal application initialization is skipped.");
                }
            } else {
                Set<String> defaultApplications = this.getDefaultApplications();
                if (!defaultApplications.isEmpty()) {
                    AppsCommonDataHolder.getInstance().setDefaultApplications(defaultApplications);
                }
                AppPortalUtils.initiatePortals("carbon.super", -1234);
            }
            if (!(systemApplications = this.getSystemApplications()).isEmpty()) {
                AppsCommonDataHolder.getInstance().setSystemApplications(systemApplications);
                Set<String> systemAppConsumerKeys = this.getSystemAppConsumerKeys(systemApplications);
                if (!systemAppConsumerKeys.isEmpty()) {
                    AppsCommonDataHolder.getInstance().setSystemAppConsumerKeys(systemAppConsumerKeys);
                }
                AppPortalOAuthAppMgtListener oAuthApplicationMgtListener = new AppPortalOAuthAppMgtListener(true);
                bundleContext.registerService(OAuthApplicationMgtListener.class.getName(), (Object)oAuthApplicationMgtListener, null);
                log.debug((Object)"AppPortalOAuthAppMgtListener registered successfully.");
                AppPortalApplicationMgtListener applicationMgtListener = new AppPortalApplicationMgtListener(true);
                bundleContext.registerService(ApplicationMgtListener.class.getName(), (Object)applicationMgtListener, null);
                log.debug((Object)"AppPortalApplicationMgtListener registered successfully.");
                AppPortalRoleManagementListener roleManagementListener = new AppPortalRoleManagementListener(true);
                bundleContext.registerService(RoleManagementListener.class.getName(), (Object)roleManagementListener, null);
                log.debug((Object)"AppPortalRoleManagementListener registered successfully.");
            }
            if (!CarbonConstants.ENABLE_LEGACY_AUTHZ_RUNTIME.booleanValue()) {
                AppPortalTenantMgtListener tenantManagementListener = new AppPortalTenantMgtListener();
                bundleContext.registerService(TenantMgtListener.class.getName(), (Object)tenantManagementListener, null);
                log.debug((Object)"AppPortalTenantMgtListener registered successfully.");
            }
            bundleContext.registerService(ServerStartupObserver.class.getName(), (Object)new AppsCommonServiceStartupObserver(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate identity apps common service component.", e);
        }
    }

    @Reference(name="application.mgt.service", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationManagementService")
    protected void setApplicationManagementService(ApplicationManagementService applicationManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Application Management Service.");
        }
        AppsCommonDataHolder.getInstance().setApplicationManagementService(applicationManagementService);
    }

    protected void unsetApplicationManagementService(ApplicationManagementService applicationManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Application Management Service.");
        }
        AppsCommonDataHolder.getInstance().setApplicationManagementService(null);
    }

    @Reference(name="oauth.admin.service", service=OAuthAdminServiceImpl.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetOAuthAdminService")
    protected void setOAuthAdminService(OAuthAdminServiceImpl oAuthAdminService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the OAuth Admin Service.");
        }
        AppsCommonDataHolder.getInstance().setOAuthAdminService(oAuthAdminService);
    }

    protected void unsetOAuthAdminService(OAuthAdminServiceImpl oAuthAdminService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the OAuth Admin Service.");
        }
        AppsCommonDataHolder.getInstance().setOAuthAdminService(null);
    }

    @Reference(name="identity.core.init.event.service", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="organization.mgt.initialize.service", service=OrganizationManagementInitialize.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetOrganizationManagementEnablingService")
    protected void setOrganizationManagementEnablingService(OrganizationManagementInitialize organizationManagementInitializeService) {
        AppsCommonDataHolder.getInstance().setOrganizationManagementEnabled(organizationManagementInitializeService);
    }

    protected void unsetOrganizationManagementEnablingService(OrganizationManagementInitialize organizationManagementInitializeInstance) {
        AppsCommonDataHolder.getInstance().setOrganizationManagementEnabled(null);
    }

    @Reference(name="organization.app.management.service", service=OrgApplicationManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetOrgApplicationManager")
    protected void setOrgApplicationManager(OrgApplicationManager organizationManager) {
        AppsCommonDataHolder.getInstance().setOrgApplicationManager(organizationManager);
    }

    protected void unsetOrgApplicationManager(OrgApplicationManager organizationManager) {
        AppsCommonDataHolder.getInstance().setOrgApplicationManager(null);
    }

    @Reference(name="user.realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        AppsCommonDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        AppsCommonDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="role.management.service.v2", service=RoleManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRoleManagementServiceV2")
    protected void setRoleManagementServiceV2(RoleManagementService roleManagementService) {
        AppsCommonDataHolder.getInstance().setRoleManagementServiceV2(roleManagementService);
    }

    protected void unsetRoleManagementServiceV2(RoleManagementService roleManagementService) {
        AppsCommonDataHolder.getInstance().setRoleManagementServiceV2(null);
    }

    @Reference(name="api.resource.mgt.service", service=APIResourceManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAPIResourceManager")
    protected void setAPIResourceManager(APIResourceManager apiResourceManager) {
        AppsCommonDataHolder.getInstance().setAPIResourceManager(apiResourceManager);
    }

    protected void unsetAPIResourceManager(APIResourceManager apiResourceManager) {
        AppsCommonDataHolder.getInstance().setAPIResourceManager(null);
    }

    private boolean skipPortalInitialization() {
        return System.getProperty("skipServerInitialization") != null;
    }

    private Set<String> getSystemApplications() {
        return AppsCommonDataHolder.getInstance().getApplicationManagementService().getSystemApplications();
    }

    private Set<String> getDefaultApplications() {
        return AppsCommonDataHolder.getInstance().getApplicationManagementService().getDefaultApplications();
    }

    private Set<String> getSystemAppConsumerKeys(Set<String> systemApplications) throws IdentityApplicationManagementException {
        HashSet<String> systemAppConsumerKeys = new HashSet<String>();
        for (String applicationName : systemApplications) {
            InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig;
            ServiceProvider systemApplication = AppsCommonDataHolder.getInstance().getApplicationManagementService().getApplicationExcludingFileBasedSPs(applicationName, "carbon.super");
            if (systemApplication == null || (inboundAuthenticationRequestConfig = AppPortalUtils.getOAuthInboundAuthenticationRequestConfig(systemApplication)) == null || !StringUtils.isNotBlank((String)inboundAuthenticationRequestConfig.getInboundAuthKey())) continue;
            systemAppConsumerKeys.add(inboundAuthenticationRequestConfig.getInboundAuthKey());
        }
        return systemAppConsumerKeys;
    }
}

