/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.listner;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.organization.management.service.exception.OrganizationManagementException;
import org.wso2.carbon.identity.organization.management.service.util.OrganizationManagementUtil;
import org.wso2.carbon.identity.role.v2.mgt.core.RoleConstants;
import org.wso2.carbon.identity.role.v2.mgt.core.exception.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.v2.mgt.core.listener.AbstractRoleManagementListener;
import org.wso2.carbon.identity.role.v2.mgt.core.model.Permission;
import org.wso2.carbon.identity.role.v2.mgt.core.model.Role;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;

public class AppPortalRoleManagementListener
extends AbstractRoleManagementListener {
    private boolean isEnable;

    public AppPortalRoleManagementListener(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public int getExecutionOrderId() {
        return 50;
    }

    public int getDefaultOrderId() {
        return 50;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void preUpdateRoleName(String roleId, String newRoleName, String tenantDomain) throws IdentityRoleManagementException {
        if (this.isAdministratorRole(roleId, tenantDomain)) {
            throw new IdentityRoleManagementException(RoleConstants.Error.INVALID_REQUEST.getCode(), "Updating name of the 'Administrator' role belongs to the 'Console' application is not allowed.");
        }
    }

    public void preDeleteRole(String roleId, String tenantDomain) throws IdentityRoleManagementException {
        if (this.isAdministratorRole(roleId, tenantDomain)) {
            throw new IdentityRoleManagementException(RoleConstants.Error.INVALID_REQUEST.getCode(), "Deleting the 'Administrator' role belongs to the 'Console' application is not allowed.");
        }
    }

    public void preUpdateUserListOfRole(String roleId, List<String> newUserIDList, List<String> deletedUserIDList, String tenantDomain) throws IdentityRoleManagementException {
        String adminUserId;
        if (deletedUserIDList == null || !this.isAdministratorRole(roleId, tenantDomain)) {
            return;
        }
        try {
            if (OrganizationManagementUtil.isOrganization((String)tenantDomain)) {
                return;
            }
        }
        catch (OrganizationManagementException e) {
            throw new IdentityRoleManagementException("Failed to determine if the tenant is a sub-organization for tenant domain: " + tenantDomain, (Throwable)e);
        }
        try {
            UserRealm userRealm = (UserRealm)PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm();
            String adminUsername = userRealm.getRealmConfiguration().getAdminUserName();
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            adminUserId = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(adminUsername);
        }
        catch (UserStoreException e) {
            throw new IdentityRoleManagementException("Failed to retrieve user id of the tenant admin.", (Throwable)e);
        }
        if (deletedUserIDList.contains(adminUserId)) {
            throw new IdentityRoleManagementException(RoleConstants.Error.INVALID_REQUEST.getCode(), "Deleting the tenant admin from 'Administrator' role belongs to the 'Console' application is not allowed.");
        }
    }

    public void preUpdatePermissionsForRole(String roleId, List<Permission> addedPermissions, List<Permission> deletedPermissions, String audience, String audienceId, String tenantDomain) throws IdentityRoleManagementException {
        String requestInitiatedTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if ("carbon.super".equals(requestInitiatedTenantDomain) && !StringUtils.equals((String)tenantDomain, (String)requestInitiatedTenantDomain)) {
            return;
        }
        if (this.isAdministratorRole(roleId, tenantDomain)) {
            throw new IdentityRoleManagementException(RoleConstants.Error.INVALID_REQUEST.getCode(), "Updating permissions of the 'Administrator' role belongs to the 'Console' application is not allowed.");
        }
    }

    private boolean isAdministratorRole(String roleId, String tenantDomain) throws IdentityRoleManagementException {
        Role role = AppsCommonDataHolder.getInstance().getRoleManagementServiceV2().getRole(roleId, tenantDomain);
        return role != null && StringUtils.equalsIgnoreCase((String)"Administrator", (String)role.getName()) && StringUtils.equalsIgnoreCase((String)"application", (String)role.getAudience()) && StringUtils.equalsIgnoreCase((String)"Console", (String)role.getAudienceName());
    }
}

