/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.AssociatedRolesConfig;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.ServiceProviderProperty;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.ApplicationMgtUtil;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.organization.management.service.exception.OrganizationManagementException;
import org.wso2.carbon.identity.role.v2.mgt.core.exception.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.v2.mgt.core.model.RoleBasicInfo;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;
import org.wso2.identity.apps.common.util.AppPortalConstants;

public class AppPortalUtils {
    private AppPortalUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOAuth2Application(String applicationName, String portalPath, String consumerKey, String consumerSecret, String appOwner, int tenantId, String tenantDomain, String bindingType, List<String> grantTypes) throws IdentityOAuthAdminException {
        OAuthConsumerAppDTO oAuthConsumerAppDTO = new OAuthConsumerAppDTO();
        oAuthConsumerAppDTO.setApplicationName(applicationName);
        oAuthConsumerAppDTO.setOAuthVersion("OAuth-2.0");
        oAuthConsumerAppDTO.setOauthConsumerKey(consumerKey);
        oAuthConsumerAppDTO.setOauthConsumerSecret(consumerSecret);
        if ("Console".equals(applicationName) && StringUtils.isNotEmpty((String)IdentityUtil.getProperty((String)"Console.AppBaseName"))) {
            portalPath = IdentityUtil.getProperty((String)"Console.AppBaseName");
        }
        if ("My Account".equals(applicationName) && StringUtils.isNotEmpty((String)IdentityUtil.getProperty((String)"MyAccount.AppBaseName"))) {
            portalPath = IdentityUtil.getProperty((String)"MyAccount.AppBaseName");
        }
        if (!portalPath.startsWith("/")) {
            portalPath = "/" + portalPath;
        }
        String callbackUrl = IdentityUtil.getServerURL((String)portalPath, (boolean)true, (boolean)true);
        try {
            callbackUrl = ApplicationMgtUtil.replaceUrlOriginWithPlaceholders((String)callbackUrl);
            callbackUrl = ApplicationMgtUtil.resolveOriginUrlFromPlaceholders((String)callbackUrl, (String)applicationName);
        }
        catch (URLBuilderException e) {
            throw new IdentityOAuthAdminException("Server encountered an error while building callback URL with placeholders for the server URL", (Throwable)e);
        }
        if (CarbonConstants.ENABLE_LEGACY_AUTHZ_RUNTIME.booleanValue()) {
            if ("carbon.super".equals(tenantDomain)) {
                callbackUrl = StringUtils.equals((String)"Console", (String)applicationName) && AppsCommonDataHolder.getInstance().isOrganizationManagementEnabled() ? "regexp=(" + callbackUrl + "|" + callbackUrl.replace(portalPath, "/t/(.*)" + portalPath) + "|" + callbackUrl.replace(portalPath, "/o/(.*)" + portalPath) + ")" : "regexp=(" + callbackUrl + "|" + callbackUrl.replace(portalPath, "/t/(.*)" + portalPath) + ")";
            }
        } else {
            callbackUrl = "carbon.super".equals(tenantDomain) ? "regexp=(" + callbackUrl + "|" + callbackUrl.replace(portalPath, "/o/(.*)" + portalPath) + "|" + callbackUrl.replace(portalPath, "/t/carbon.super" + portalPath) + "|" + callbackUrl.replace(portalPath, "/t/carbon.super/o/(.*)" + portalPath) + ")" : "regexp=(" + callbackUrl.replace(portalPath, "/t/(.*)" + portalPath) + "|" + callbackUrl.replace(portalPath, "/t/(.*)/o/(.*)" + portalPath) + ")";
        }
        oAuthConsumerAppDTO.setCallbackUrl(callbackUrl);
        oAuthConsumerAppDTO.setBypassClientCredentials(true);
        if (grantTypes != null && !grantTypes.isEmpty()) {
            oAuthConsumerAppDTO.setGrantTypes(String.join((CharSequence)" ", grantTypes));
        }
        oAuthConsumerAppDTO.setPkceMandatory(true);
        oAuthConsumerAppDTO.setTokenBindingType(bindingType);
        oAuthConsumerAppDTO.setTokenBindingValidationEnabled(true);
        oAuthConsumerAppDTO.setTokenRevocationWithIDPSessionTerminationEnabled(true);
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(tenantId);
            privilegedCarbonContext.setTenantDomain(tenantDomain);
            privilegedCarbonContext.setUsername(appOwner);
            AppsCommonDataHolder.getInstance().getOAuthAdminService().registerOAuthApplicationData(oAuthConsumerAppDTO);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Deprecated
    public static void createApplication(String appName, String appOwner, String appDescription, String consumerKey, String consumerSecret, String tenantDomain) throws IdentityApplicationManagementException {
        AppPortalUtils.createApplication(appName, appOwner, appDescription, consumerKey, consumerSecret, tenantDomain, "");
    }

    public static void createApplication(String appName, String appOwner, String appDescription, String consumerKey, String consumerSecret, String tenantDomain, String portalPath) throws IdentityApplicationManagementException {
        int tenantId;
        RealmService realmService = AppsCommonDataHolder.getInstance().getRealmService();
        try {
            tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityApplicationManagementException("Failed to retrieve tenant id for tenant domain: " + tenantDomain, (Throwable)e);
        }
        AppPortalUtils.createApplication(appName, appOwner, appDescription, consumerKey, consumerSecret, tenantDomain, tenantId, portalPath);
    }

    public static void createApplication(String appName, String appOwner, String appDescription, String consumerKey, String consumerSecret, String tenantDomain, int tenantId, String portalPath) throws IdentityApplicationManagementException {
        ServiceProvider serviceProvider = new ServiceProvider();
        serviceProvider.setApplicationName(appName);
        serviceProvider.setDescription(appDescription);
        if (CarbonConstants.ENABLE_LEGACY_AUTHZ_RUNTIME.booleanValue()) {
            AppPortalUtils.enableLegacyBehaviour(serviceProvider, portalPath);
        } else {
            AppPortalUtils.enableNewBehaviour(serviceProvider, portalPath, tenantDomain);
        }
        AppPortalUtils.updateInboundConfiguration(consumerKey, serviceProvider);
        AppPortalUtils.updateLocalAndOutboundConfiguration(serviceProvider);
        AppPortalUtils.updateClaimConfigs(serviceProvider);
        String appId = AppsCommonDataHolder.getInstance().getApplicationManagementService().createApplication(serviceProvider, tenantDomain, appOwner);
        if (!CarbonConstants.ENABLE_LEGACY_AUTHZ_RUNTIME.booleanValue() && "Console".equals(appName)) {
            AppPortalUtils.shareApplication(tenantDomain, tenantId, appId, appName, appOwner);
        }
    }

    public static void initiatePortals(String tenantDomain, int tenantId) throws IdentityApplicationManagementException, IdentityOAuthAdminException, UserStoreException {
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        tenantInfoBean.setTenantDomain(tenantDomain);
        tenantInfoBean.setTenantId(tenantId);
        UserRealm userRealm = (UserRealm)PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String adminUsername = userRealm.getRealmConfiguration().getAdminUserName();
        tenantInfoBean.setAdmin(adminUsername);
        AppPortalUtils.initiatePortals(tenantInfoBean);
    }

    public static void initiatePortals(TenantInfoBean tenantInfoBean) throws IdentityApplicationManagementException, IdentityOAuthAdminException {
        ApplicationManagementService applicationMgtService = AppsCommonDataHolder.getInstance().getApplicationManagementService();
        for (AppPortalConstants.AppPortal appPortal : AppPortalConstants.AppPortal.values()) {
            if (!StringUtils.equalsIgnoreCase((String)"Console", (String)appPortal.getName()) && !AppsCommonDataHolder.getInstance().getDefaultApplications().contains(appPortal.getName())) continue;
            if (applicationMgtService.getApplicationExcludingFileBasedSPs(appPortal.getName(), tenantInfoBean.getTenantDomain()) == null) {
                String consumerSecret = OAuthUtil.getRandomNumber();
                List<String> grantTypes = Arrays.asList("authorization_code", "refresh_token", "account_switch");
                if ("Console".equals(appPortal.getName())) {
                    grantTypes = Arrays.asList("authorization_code", "refresh_token", "account_switch", "organization_switch");
                }
                List<String> allowedGrantTypes = Arrays.asList(AppsCommonDataHolder.getInstance().getOAuthAdminService().getAllowedGrantTypes());
                grantTypes = grantTypes.stream().filter(allowedGrantTypes::contains).collect(Collectors.toList());
                String consumerKey = appPortal.getConsumerKey();
                try {
                    AppPortalUtils.createOAuth2Application(appPortal.getName(), appPortal.getPath(), consumerKey, consumerSecret, tenantInfoBean.getAdmin(), tenantInfoBean.getTenantId(), tenantInfoBean.getTenantDomain(), "cookie", grantTypes);
                }
                catch (IdentityOAuthAdminException e) {
                    if ("Error when adding the application. An application with the same name already exists.".equals(e.getMessage())) continue;
                    throw e;
                }
                AppPortalUtils.createApplication(appPortal.getName(), tenantInfoBean.getAdmin(), appPortal.getDescription(), consumerKey, consumerSecret, tenantInfoBean.getTenantDomain(), tenantInfoBean.getTenantId(), appPortal.getPath());
                continue;
            }
            if (CarbonConstants.ENABLE_LEGACY_AUTHZ_RUNTIME.booleanValue() || !StringUtils.equalsIgnoreCase((String)"Console", (String)appPortal.getName())) continue;
            try {
                String userId = AppPortalUtils.getUserId(tenantInfoBean.getAdmin(), tenantInfoBean.getTenantId());
                List assignedRoles = AppsCommonDataHolder.getInstance().getRoleManagementServiceV2().getRoleListOfUser(userId, tenantInfoBean.getTenantDomain());
                String audienceId = AppsCommonDataHolder.getInstance().getApplicationManagementService().getApplicationResourceIDByInboundKey(AppPortalConstants.AppPortal.CONSOLE.getConsumerKey(), "oauth2", tenantInfoBean.getTenantDomain());
                for (RoleBasicInfo roleBasicInfo : assignedRoles) {
                    if (!"Administrator".equalsIgnoreCase(roleBasicInfo.getName()) || !"application".equalsIgnoreCase(roleBasicInfo.getAudience()) || !audienceId.equals(roleBasicInfo.getAudienceId())) continue;
                    return;
                }
                String roleId = AppPortalUtils.getAdministratorRoleId("Administrator", "application", audienceId, tenantInfoBean.getTenantDomain());
                AppPortalUtils.assignAdministratorRole(userId, roleId, tenantInfoBean.getTenantId(), tenantInfoBean.getTenantDomain());
            }
            catch (IdentityRoleManagementException | org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityApplicationManagementException("Error occured while assigning administrator role to the admin user.", e);
            }
        }
    }

    public static InboundAuthenticationRequestConfig getOAuthInboundAuthenticationRequestConfig(ServiceProvider application) {
        if (application == null || application.getInboundAuthenticationConfig() == null || application.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() == null || application.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs().length == 0) {
            return null;
        }
        for (InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig : application.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
            if (!"oauth2".equals(inboundAuthenticationRequestConfig.getInboundAuthType())) continue;
            return inboundAuthenticationRequestConfig;
        }
        return null;
    }

    private static void shareApplication(String tenantDomain, int tenantId, String appId, String appName, String appOwner) throws IdentityApplicationManagementException {
        String organizationId;
        RealmService realmService = AppsCommonDataHolder.getInstance().getRealmService();
        if ("carbon.super".equals(tenantDomain)) {
            organizationId = "10084a8d-113f-4211-a0d5-efe36b082211";
        } else {
            try {
                organizationId = realmService.getTenantManager().getTenant(tenantId).getAssociatedOrganizationUUID();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityApplicationManagementException("Failed to organization id for tenant domain: " + tenantDomain, (Throwable)e);
            }
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(tenantId);
            privilegedCarbonContext.setTenantDomain(tenantDomain);
            privilegedCarbonContext.setUsername(appOwner);
            IdentityApplicationManagementUtil.setAllowUpdateSystemApplicationThreadLocal((Boolean)true);
            AppsCommonDataHolder.getInstance().getOrgApplicationManager().shareOrganizationApplication(organizationId, appId, true, Collections.emptyList());
            if (StringUtils.equalsIgnoreCase((String)"Console", (String)appName)) {
                AppPortalUtils.addAdministratorRole(appOwner, appId, tenantId, tenantDomain);
            }
        }
        catch (OrganizationManagementException e) {
            throw new IdentityApplicationManagementException("Failed to share system application.", (Throwable)e);
        }
        finally {
            IdentityApplicationManagementUtil.removeAllowUpdateSystemApplicationThreadLocal();
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private static void addAdministratorRole(String appOwner, String appId, int tenantId, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            String userID = AppPortalUtils.getUserId(appOwner, tenantId);
            String adminGroupId = AppPortalUtils.getAdminGroupId(tenantId);
            List<Object> groupIds = Collections.emptyList();
            if (StringUtils.isNotEmpty((String)adminGroupId)) {
                groupIds = Collections.singletonList(adminGroupId);
            }
            AppsCommonDataHolder.getInstance().getRoleManagementServiceV2().addRole("Administrator", Collections.singletonList(userID), groupIds, Collections.emptyList(), "application", appId, tenantDomain);
        }
        catch (IdentityRoleManagementException e) {
            throw new IdentityApplicationManagementException("Failed to add Administrator role for the console", (Throwable)e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAdministratorRoleId(String roleName, String audience, String audienceId, String tenantDomain) throws IdentityRoleManagementException {
        return AppsCommonDataHolder.getInstance().getRoleManagementServiceV2().getRoleIdByName(roleName, audience, audienceId, tenantDomain);
    }

    private static void assignAdministratorRole(String userId, String roleId, int tenantId, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            AppsCommonDataHolder.getInstance().getRoleManagementServiceV2().updateUserListOfRole(roleId, Collections.singletonList(userId), Collections.emptyList(), tenantDomain);
        }
        catch (IdentityRoleManagementException e) {
            throw new IdentityApplicationManagementException("Failed to assign Administrator role of the console to :" + userId, (Throwable)e);
        }
    }

    private static String getUserId(String appOwner, int tenantId) throws org.wso2.carbon.user.api.UserStoreException {
        UserRealm userRealm = (UserRealm)AppsCommonDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
        UserStoreManager userStoreManager = userRealm.getUserStoreManager();
        return ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(appOwner);
    }

    private static void updateClaimConfigs(ServiceProvider serviceProvider) {
        ClaimConfig claimConfig = new ClaimConfig();
        claimConfig.setClaimMappings(AppPortalUtils.getRequestedClaimMappings());
        claimConfig.setLocalClaimDialect(true);
        serviceProvider.setClaimConfig(claimConfig);
    }

    private static void updateLocalAndOutboundConfiguration(ServiceProvider serviceProvider) {
        LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = new LocalAndOutboundAuthenticationConfig();
        localAndOutboundAuthenticationConfig.setUseUserstoreDomainInLocalSubjectIdentifier(true);
        localAndOutboundAuthenticationConfig.setUseTenantDomainInLocalSubjectIdentifier(true);
        localAndOutboundAuthenticationConfig.setSkipConsent(true);
        localAndOutboundAuthenticationConfig.setSkipLogoutConsent(true);
        serviceProvider.setLocalAndOutBoundAuthenticationConfig(localAndOutboundAuthenticationConfig);
    }

    private static void updateInboundConfiguration(String consumerKey, ServiceProvider serviceProvider) {
        InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = new InboundAuthenticationRequestConfig();
        inboundAuthenticationRequestConfig.setInboundAuthKey(consumerKey);
        inboundAuthenticationRequestConfig.setInboundAuthType("oauth2");
        inboundAuthenticationRequestConfig.setInboundConfigType("standardAPP");
        List<InboundAuthenticationRequestConfig> inboundAuthenticationRequestConfigs = Arrays.asList(inboundAuthenticationRequestConfig);
        InboundAuthenticationConfig inboundAuthenticationConfig = new InboundAuthenticationConfig();
        inboundAuthenticationConfig.setInboundAuthenticationRequestConfigs(inboundAuthenticationRequestConfigs.toArray(new InboundAuthenticationRequestConfig[0]));
        serviceProvider.setInboundAuthenticationConfig(inboundAuthenticationConfig);
    }

    private static void enableNewBehaviour(ServiceProvider serviceProvider, String portalPath, String tenantDomain) {
        if (StringUtils.isNotEmpty((String)portalPath)) {
            String accessUrl = IdentityUtil.getServerURL((String)portalPath, (boolean)true, (boolean)true);
            if (!"carbon.super".equals(tenantDomain)) {
                accessUrl = accessUrl.replace(portalPath, "/t/" + tenantDomain.trim() + portalPath);
            }
            serviceProvider.setAccessUrl(accessUrl);
        }
        ArrayList<ServiceProviderProperty> serviceProviderProperties = new ArrayList<ServiceProviderProperty>();
        ServiceProviderProperty spProperty1 = new ServiceProviderProperty();
        spProperty1.setName("isSystemReservedApp");
        spProperty1.setValue("true");
        spProperty1.setDisplayName("Is System Reserved Application");
        serviceProviderProperties.add(spProperty1);
        if ("Console".equals(serviceProvider.getApplicationName())) {
            ServiceProviderProperty spProperty2 = new ServiceProviderProperty();
            spProperty2.setName("shareWithAllChildren");
            spProperty2.setValue("true");
            serviceProviderProperties.add(spProperty2);
        }
        serviceProvider.setSpProperties(serviceProviderProperties.toArray(new ServiceProviderProperty[0]));
        AssociatedRolesConfig associatedRolesConfig = new AssociatedRolesConfig();
        associatedRolesConfig.setAllowedAudience("application");
        serviceProvider.setAssociatedRolesConfig(associatedRolesConfig);
    }

    private static void enableLegacyBehaviour(ServiceProvider serviceProvider, String portalPath) {
        serviceProvider.setManagementApp(true);
        serviceProvider.setSaasApp(true);
        if (StringUtils.isNotEmpty((String)portalPath)) {
            serviceProvider.setAccessUrl(IdentityUtil.getServerURL((String)portalPath, (boolean)true, (boolean)true));
        }
    }

    private static ClaimMapping[] getRequestedClaimMappings() {
        Claim emailClaim = new Claim();
        emailClaim.setClaimUri("http://wso2.org/claims/emailaddress");
        ClaimMapping emailClaimMapping = new ClaimMapping();
        emailClaimMapping.setRequested(true);
        emailClaimMapping.setLocalClaim(emailClaim);
        emailClaimMapping.setRemoteClaim(emailClaim);
        Claim displayNameClaim = new Claim();
        displayNameClaim.setClaimUri("http://wso2.org/claims/displayName");
        ClaimMapping displayNameClaimMapping = new ClaimMapping();
        displayNameClaimMapping.setRequested(true);
        displayNameClaimMapping.setLocalClaim(displayNameClaim);
        displayNameClaimMapping.setRemoteClaim(displayNameClaim);
        Claim usernameClaim = new Claim();
        usernameClaim.setClaimUri("http://wso2.org/claims/username");
        ClaimMapping usernameClaimMapping = new ClaimMapping();
        usernameClaimMapping.setRequested(true);
        usernameClaimMapping.setLocalClaim(usernameClaim);
        usernameClaimMapping.setRemoteClaim(usernameClaim);
        Claim profileUrlClaim = new Claim();
        profileUrlClaim.setClaimUri("http://wso2.org/claims/url");
        ClaimMapping profileUrlClaimMapping = new ClaimMapping();
        profileUrlClaimMapping.setRequested(true);
        profileUrlClaimMapping.setLocalClaim(profileUrlClaim);
        profileUrlClaimMapping.setRemoteClaim(profileUrlClaim);
        return new ClaimMapping[]{emailClaimMapping, displayNameClaimMapping, usernameClaimMapping, profileUrlClaimMapping};
    }

    private static String getAdminGroupId(int tenantID) throws IdentityApplicationManagementException {
        try {
            RealmService realmService = AppsCommonDataHolder.getInstance().getRealmService();
            String adminGroupName = realmService.getTenantUserRealm(tenantID).getRealmConfiguration().getAdminRoleName();
            if (adminGroupName == null) {
                return null;
            }
            if (adminGroupName.startsWith("Internal" + CarbonConstants.DOMAIN_SEPARATOR)) {
                adminGroupName = adminGroupName.replace("Internal" + CarbonConstants.DOMAIN_SEPARATOR, "");
            }
            try {
                return ((AbstractUserStoreManager)realmService.getTenantUserRealm(tenantID).getUserStoreManager()).getGroupIdByGroupName(adminGroupName);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                return null;
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityApplicationManagementException("Fail to resolve the admin group ID of the tenant: " + tenantID, (Throwable)e);
        }
    }
}

