/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.stub.UserIdentityManagementAdminServiceStub;
import org.wso2.carbon.identity.mgt.stub.dto.ChallengeQuestionDTO;
import org.wso2.carbon.identity.mgt.stub.dto.UserChallengesDTO;
import org.wso2.sample.inforecovery.client.authenticator.AuthenticationException;
import org.wso2.sample.inforecovery.client.authenticator.ServiceAuthenticator;

public class IdentityManagementAdminClient {
    public static final String CHALLENGE_QUESTION = "challenge.question";
    protected static Log log = LogFactory.getLog(IdentityManagementAdminClient.class);
    protected UserIdentityManagementAdminServiceStub stub = null;

    public IdentityManagementAdminClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserIdentityManagementAdminServiceStub(configContext, url + "services/UserIdentityManagementAdminService");
            ServiceAuthenticator authenticator = ServiceAuthenticator.getInstance();
            ServiceClient client = this.stub._getServiceClient();
            try {
                authenticator.authenticate(client);
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public ChallengeQuestionDTO[] getChallengeQuestions() throws AxisFault {
        try {
            return this.stub.getAllChallengeQuestions();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void setChallengeQuestions(ChallengeQuestionDTO[] challengeQuestionDTOs) throws AxisFault {
        try {
            this.stub.setChallengeQuestions(challengeQuestionDTOs);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void setChallengeQuestionsOfUser(String userId, UserChallengesDTO[] userChallengesDTOs) throws AxisFault {
        try {
            this.stub.setChallengeQuestionsOfUser(userId, userChallengesDTOs);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public UserChallengesDTO[] getChallengeQuestionsOfUser(String userId) throws AxisFault {
        try {
            return this.stub.getChallengeQuestionsOfUser(userId);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public boolean isReadOnlyUserStore(String username, String tenantDomain) throws AxisFault {
        try {
            return this.stub.isReadOnlyUserStore(username, tenantDomain);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return false;
        }
    }

    private String[] handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

