/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.client;

import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;
import org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue;
import org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName;
import org.wso2.carbon.user.mgt.stub.types.carbon.UIPermissionNode;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserRealmInfo;
import org.wso2.sample.inforecovery.client.authenticator.AuthenticationException;
import org.wso2.sample.inforecovery.client.authenticator.ServiceAuthenticator;

public class UserAdminClient {
    protected static Log log = LogFactory.getLog(UserAdminClient.class);
    protected UserAdminStub stub = null;

    public UserAdminClient(String cookie, String url, String serviceName, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserAdminStub(configContext, url + serviceName);
            ServiceAuthenticator authenticator = ServiceAuthenticator.getInstance();
            ServiceClient client = this.stub._getServiceClient();
            try {
                authenticator.authenticate(client);
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public UserAdminClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserAdminStub(configContext, url + "UserAdmin");
            ServiceClient client = this.stub._getServiceClient();
            ServiceAuthenticator authenticator = ServiceAuthenticator.getInstance();
            try {
                authenticator.authenticate(client);
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addRole(String roleName, String[] userList, String[] permissions, boolean isSharedRole) throws AxisFault {
        try {
            this.stub.addRole(roleName, userList, permissions, isSharedRole);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addInternalRole(String roleName, String[] userList, String[] permissions) throws AxisFault {
        try {
            this.stub.addInternalRole(roleName, userList, permissions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws AxisFault {
        try {
            this.stub.addUser(userName, password, roles, claims, profileName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void changePassword(String userName, String newPassword) throws AxisFault {
        try {
            this.stub.changePassword(userName, newPassword);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteRole(String roleName) throws AxisFault {
        try {
            this.stub.deleteRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws AxisFault {
        try {
            this.stub.updateRoleName(roleName, newRoleName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteUser(String userName) throws AxisFault {
        try {
            this.stub.deleteUser(userName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public FlaggedName[] getAllRolesNames(String filter, int limit) throws AxisFault {
        try {
            return this.stub.getAllRolesNames(filter, limit);
        }
        catch (Exception e) {
            this.handleException(e);
            return new FlaggedName[0];
        }
    }

    public FlaggedName[] getRolesOfUser(String userName, String filter, int limit) throws AxisFault {
        try {
            return this.stub.getRolesOfUser(userName, filter, limit);
        }
        catch (Exception e) {
            this.handleException(e);
            return new FlaggedName[0];
        }
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter, int limit) throws AxisFault {
        try {
            return this.stub.getUsersOfRole(roleName, filter, limit);
        }
        catch (Exception e) {
            this.handleException(e);
            return new FlaggedName[0];
        }
    }

    public UserRealmInfo getUserRealmInfo() throws AxisFault {
        UserRealmInfo info = null;
        try {
            info = this.stub.getUserRealmInfo();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    public String[] listUsers(String filter, int limit) throws AxisFault {
        try {
            return this.stub.listUsers(filter, limit);
        }
        catch (Exception e) {
            this.handleException(e);
            return new String[0];
        }
    }

    public FlaggedName[] listAllUsers(String filter, int limit) throws AxisFault {
        try {
            return this.stub.listAllUsers(filter, limit);
        }
        catch (Exception e) {
            this.handleException(e);
            return new FlaggedName[0];
        }
    }

    public UIPermissionNode getAllUIPermissions() throws AxisFault {
        try {
            return this.stub.getAllUIPermissions();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public UIPermissionNode getRolePermissions(String roleName) throws AxisFault {
        try {
            return this.stub.getRolePermissions(roleName);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public void setRoleUIPermission(String roleName, String[] rawResources) throws AxisFault {
        try {
            this.stub.setRoleUIPermission(roleName, rawResources);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void bulkImportUsers(String userStoreDomain, String fileName, DataHandler handler, String defaultPassword) throws AxisFault {
        try {
            this.stub.bulkImportUsers(userStoreDomain, fileName, handler, defaultPassword);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void changePasswordByUser(String userName, String oldPassword, String newPassword) throws AxisFault {
        try {
            this.stub.changePasswordByUser(userName, oldPassword, newPassword);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addRemoveRolesOfUser(String userName, String[] newRoles, String[] deletedRoles) throws AxisFault {
        try {
            this.stub.addRemoveRolesOfUser(userName, newRoles, deletedRoles);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void addRemoveUsersOfRole(String roleName, String[] newUsers, String[] deletedUsers) throws AxisFault {
        try {
            this.stub.addRemoveUsersOfRole(roleName, newUsers, deletedUsers);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public FlaggedName[] listUserByClaim(ClaimValue claimValue, String filter, int limit) throws AxisFault {
        try {
            ClaimValue abcdClaimValue = new ClaimValue();
            abcdClaimValue.setClaimURI(claimValue.getClaimURI());
            abcdClaimValue.setValue(claimValue.getValue());
            return this.stub.listUserByClaim(abcdClaimValue, filter, limit);
        }
        catch (Exception e) {
            this.handleException(e);
            return new FlaggedName[0];
        }
    }

    public boolean hasMultipleUserStores() throws AxisFault {
        try {
            return this.stub.hasMultipleUserStores();
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    protected String[] handleException(Exception e) throws AxisFault {
        String errorMessage = "Unknown";
        if (e instanceof UserAdminUserAdminException) {
            UserAdminUserAdminException adminException = (UserAdminUserAdminException)e;
            if (adminException.getFaultMessage().getUserAdminException() != null) {
                errorMessage = adminException.getFaultMessage().getUserAdminException().getMessage();
            }
        } else {
            errorMessage = e.getMessage();
        }
        log.error((Object)errorMessage, (Throwable)e);
        throw new AxisFault(errorMessage, (Throwable)e);
    }

    public boolean isSharedRolesEnabled() throws AxisFault {
        try {
            return this.stub.isSharedRolesEnabled();
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }
}

