/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.client;

import java.util.Arrays;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.profile.stub.UserProfileMgtServiceStub;
import org.wso2.carbon.identity.user.profile.stub.types.UserFieldDTO;
import org.wso2.carbon.identity.user.profile.stub.types.UserProfileDTO;
import org.wso2.sample.inforecovery.client.UserProfileClient;
import org.wso2.sample.inforecovery.client.authenticator.ServiceAuthenticator;

public class UserProfileClient {
    private static Log log = LogFactory.getLog(UserProfileClient.class);
    private UserProfileMgtServiceStub stub = null;
    private String serviceEndPoint = null;

    public UserProfileClient(String url, ConfigurationContext configContext) throws Exception {
        try {
            this.serviceEndPoint = url + "services/UserProfileMgtService";
            this.stub = new UserProfileMgtServiceStub(configContext, this.serviceEndPoint);
            ServiceAuthenticator authenticator = ServiceAuthenticator.getInstance();
            authenticator.authenticate(this.stub._getServiceClient());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static String extractDomainFromName(String nameWithDomain) {
        int index = nameWithDomain.indexOf("/");
        if (index > 0) {
            String[] names = nameWithDomain.split("/");
            return names[0];
        }
        return null;
    }

    public void setUserProfile(String username, UserProfileDTO profile) throws Exception {
        try {
            this.stub.setUserProfile(username, profile);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void deleteUserProfile(String username, String profileName) throws Exception {
        try {
            this.stub.deleteUserProfile(username, profileName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserProfileDTO[] getUserProfiles(String userName) throws Exception {
        try {
            return this.stub.getUserProfiles(userName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserProfileDTO getProfileFieldsForInternalStore() throws Exception {
        try {
            return this.stub.getProfileFieldsForInternalStore();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean isReadOnlyUserStore() throws Exception {
        try {
            return this.stub.isReadOnlyUserStore();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserProfileDTO getUserProfile(String username, String profile) throws Exception {
        try {
            return this.stub.getUserProfile(username, profile);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public UserFieldDTO[] getOrderedUserFields(UserFieldDTO[] userFields) throws Exception {
        Arrays.sort(userFields, new UserFieldComparator(this));
        return userFields;
    }

    public boolean isAddProfileEnabled() throws Exception {
        try {
            return this.stub.isAddProfileEnabled();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean isAddProfileEnabledForDomain(String domain) throws Exception {
        try {
            return this.stub.isAddProfileEnabledForDomain(domain);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }
}

