/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.client.authenticator;

import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.wso2.sample.inforecovery.client.authenticator.AuthenticationException;

public class ServiceAuthenticator {
    private static ServiceAuthenticator instance = null;
    private String accessUsername = null;
    private String accessPassword = null;

    private ServiceAuthenticator() {
    }

    public static ServiceAuthenticator getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ServiceAuthenticator();
        return instance;
    }

    public void authenticate(ServiceClient client) throws AuthenticationException {
        if (this.accessUsername == null || this.accessPassword == null) {
            throw new AuthenticationException("Authentication username or password not set");
        }
        Options option = client.getOptions();
        HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
        auth.setUsername(this.accessUsername);
        auth.setPassword(this.accessPassword);
        auth.setPreemptiveAuthentication(true);
        option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
        option.setManageSession(true);
    }

    public void setAccessUsername(String accessUsername) {
        this.accessUsername = accessUsername;
    }

    public void setAccessPassword(String accessPassword) {
        this.accessPassword = accessPassword;
    }
}

