/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.user.profile.stub.types.UserFieldDTO;
import org.wso2.carbon.identity.user.profile.stub.types.UserProfileDTO;
import org.wso2.sample.inforecovery.client.UserProfileClient;
import org.wso2.sample.inforecovery.controller.UserProfileController;
import org.wso2.sample.inforecovery.dto.ClaimUIDto;

public class AccountOverviewController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserProfileController.class);
    UserProfileClient client;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserProfileClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        UserProfileDTO userProfileDTO = null;
        try {
            userProfileDTO = this.client.getUserProfile(req.getParameter("username"), "default");
        }
        catch (Exception e) {
            String msg = "Error occurred while retrieving user profile";
            log.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        UserFieldDTO[] fieldValues = userProfileDTO.getFieldValues();
        ArrayList<ClaimUIDto> claimsUi = new ArrayList<ClaimUIDto>();
        ArrayList filteredClaims = new ArrayList();
        String viewPage = "account_overview.jsp";
        if (fieldValues != null) {
            for (UserFieldDTO fieldValue : fieldValues) {
                ClaimUIDto tempDto = new ClaimUIDto();
                if (fieldValue == null) continue;
                tempDto.setClaimUri(fieldValue.getClaimUri());
                tempDto.setDisplayName(fieldValue.getDisplayName());
                tempDto.setClaimValue(fieldValue.getFieldValue());
                claimsUi.add(tempDto);
            }
            req.setAttribute("claims", (Object)claimsUi.toArray(new ClaimUIDto[claimsUi.size()]));
            session.setAttribute("claims", (Object)filteredClaims.toArray(new ClaimUIDto[claimsUi.size()]));
            session.setAttribute("userProfileDTO", (Object)userProfileDTO);
        }
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        boolean success = true;
        String username = req.getParameter("username");
        HttpSession session = req.getSession(false);
        UserFieldDTO[] userFields = null;
        UserProfileDTO userProfile = (UserProfileDTO)session.getAttribute("userProfileDTO");
        String profileConfiguration = userProfile.getProfileConifuration();
        try {
            userFields = this.client.getOrderedUserFields(userProfile.getFieldValues());
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        if (userFields != null) {
            for (UserFieldDTO field : userFields) {
                String value = req.getParameter(field.getClaimUri());
                if (value == null) {
                    value = "";
                }
                field.setFieldValue(value);
            }
        }
        UserProfileDTO userprofile = new UserProfileDTO();
        userprofile.setProfileName(userProfile.getProfileName());
        userprofile.setFieldValues(userFields);
        userprofile.setProfileConifuration(profileConfiguration);
        try {
            this.client.setUserProfile(username, userprofile);
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        String viewPage = "edit_user_status.jsp";
        req.setAttribute("updatedStatus", (Object)success);
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    private String getDisplayName(String uri) {
        int startIndex = uri.lastIndexOf("/");
        return uri.substring(startIndex + 1);
    }
}

