/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.captcha.mgt.beans.xsd.CaptchaInfoBean;
import org.wso2.sample.inforecovery.client.UserInformationRecoveryClient;

public class AccountSetupController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private UserInformationRecoveryClient client;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserInformationRecoveryClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String radio = req.getParameter("recoveryMethod");
        HttpSession session = req.getSession(false);
        if (session != null) {
            CaptchaInfoBean captchaInfoBean;
            try {
                captchaInfoBean = this.client.generateCaptcha();
            }
            catch (Exception e) {
                return;
            }
            if (captchaInfoBean == null) {
                return;
            }
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            String captchaImagePath = captchaInfoBean.getImagePath();
            String captchaImageUrl = carbonServerUrl + "/" + captchaImagePath;
            String captchaSecretKey = captchaInfoBean.getSecretKey();
            req.setAttribute("captchaImageUrl", (Object)captchaImageUrl);
            req.setAttribute("captchaSecretKey", (Object)captchaSecretKey);
            req.setAttribute("captchaImagePath", (Object)captchaImagePath);
            session.setAttribute("confirmation", (Object)captchaInfoBean.getSecretKey());
            req.setAttribute("validateAction", (Object)"validateAccountSetup");
            RequestDispatcher dispatcher = req.getRequestDispatcher("/account_setup_verification.jsp");
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        }
    }
}

