/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.wso2.sample.inforecovery.client.authenticator.ServiceAuthenticator;

public class IndexController
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext ctx = config.getServletContext();
        ServiceAuthenticator sAuthenticator = ServiceAuthenticator.getInstance();
        sAuthenticator.setAccessUsername(ctx.getInitParameter("accessUsername"));
        sAuthenticator.setAccessPassword(ctx.getInitParameter("accessPassword"));
        String trustStorePath = ctx.getInitParameter("trustStorePath");
        System.setProperty("javax.net.ssl.trustStore", Thread.currentThread().getContextClassLoader().getResource(trustStorePath).getPath());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String requestPage = req.getRequestURI();
        String destinationUri = requestPage.substring(requestPage.indexOf("/infoRecover") + 12);
        RequestDispatcher view = null;
        HttpSession session = req.getSession(true);
        if (session != null) {
            if (destinationUri.contains("userInfoView")) {
                destinationUri = "/userInfoView";
            } else if (destinationUri.contains("validate") && !destinationUri.contains("validateAccountSetup")) {
                destinationUri = "/validate";
            } else if (destinationUri.contains("verify")) {
                if (req.getParameter("confirmation") != null) {
                    destinationUri = "/userInfoView";
                    session.setAttribute("emailConfirmation", (Object)req.getParameter("confirmation"));
                } else {
                    destinationUri = "/verify";
                }
            } else if (destinationUri.contains("signup")) {
                destinationUri = "/signup";
            } else if (destinationUri.contains("confirmReg")) {
                destinationUri = "/confirmReg";
            } else if (destinationUri.contains("recoverAccount")) {
                destinationUri = "/recoverAccount";
            }
            view = req.getRequestDispatcher(destinationUri);
            view.forward((ServletRequest)req, (ServletResponse)res);
        }
    }
}

