/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentSessionBean;
import org.wso2.carbon.identity.sso.agent.util.SSOAgentConfigs;
import org.wso2.carbon.identity.user.profile.stub.types.UserProfileDTO;
import org.wso2.sample.inforecovery.client.UserAdminClient;
import org.wso2.sample.inforecovery.client.UserInformationRecoveryClient;
import org.wso2.sample.inforecovery.client.UserProfileClient;

public class PasswordSetupController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInformationRecoveryClient client;
    UserAdminClient userAdminClient;
    UserProfileClient userProfileClient;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserInformationRecoveryClient(carbonServerUrl, configContext);
            this.userAdminClient = new UserAdminClient(null, "https://localhost:9443/services/", null);
            this.userProfileClient = new UserProfileClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        String confirmation = (String)session.getAttribute("confirmation");
        String username = (String)session.getAttribute("username");
        String newPassword = req.getParameter("password");
        String viewPage = null;
        if (confirmation != null && session != null) {
            UserProfileDTO userProfileDTO = null;
            try {
                userProfileDTO = this.userProfileClient.getUserProfile(username, "default");
                session.setAttribute("userProfileDTO", (Object)userProfileDTO);
            }
            catch (Exception e) {
                String msg = "Error occurred while retrieving user profile";
                throw new ServletException(msg, (Throwable)e);
            }
            try {
                this.userAdminClient.changePassword(username, newPassword);
                viewPage = "./setupSecurityQuestions?username=" + username;
                req.setAttribute("validationStatus", (Object)true);
                SSOAgentSessionBean sessionBean = new SSOAgentSessionBean();
                SSOAgentSessionBean.SAMLSSOSessionBean samlssoSessionBean = new SSOAgentSessionBean.SAMLSSOSessionBean(new SSOAgentSessionBean());
                samlssoSessionBean.setSubjectId(username);
                sessionBean.setSAMLSSOSessionBean(samlssoSessionBean);
                session.setAttribute(SSOAgentConfigs.getSessionBeanName(), (Object)sessionBean);
            }
            catch (Exception e) {
                req.setAttribute("errors", (Object)"Missing confirmation code or invalid session. Cannot proceed.");
                viewPage = "error.jsp";
            }
        } else {
            req.setAttribute("errors", (Object)"Missing confirmation code or invalid session. Cannot proceed.");
            viewPage = "error.jsp";
        }
        res.sendRedirect(viewPage);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }
}

