/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.stub.dto.UserChallengesDTO;
import org.wso2.sample.inforecovery.client.UserInformationRecoveryClient;

public class QnAProcessorController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInformationRecoveryClient client;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserInformationRecoveryClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        String confirmation = (String)session.getAttribute("confirmation");
        String username = (String)session.getAttribute("username");
        String[] qids = (String[])session.getAttribute("qids");
        String answer = req.getParameter("answer");
        String currentquestionId = (String)session.getAttribute("currentqid");
        Boolean valid = (Boolean)session.getAttribute("valid");
        int step = (Integer)session.getAttribute("step");
        String currentqid = null;
        String viewPage = null;
        VerificationBean vBean = null;
        String[] newqids = null;
        if (qids != null && qids.length > 0) {
            newqids = new String[qids.length - 1];
            int i = qids.length - 1;
            int j = 0;
            while (i >= 0) {
                currentqid = qids[i];
                if (i >= 1) {
                    newqids[i - 1] = currentqid;
                }
                --i;
                ++j;
            }
        }
        if (answer != null && currentquestionId != null) {
            vBean = this.client.checkAnswer(username, confirmation, currentquestionId, answer);
            if (!vBean.getVerified()) {
                req.setAttribute("errors", (Object)"The answer you provided is incorrect. Cannot proceed.");
                viewPage = "error.jsp";
                session.setAttribute("valid", (Object)Boolean.FALSE);
                session.setAttribute("step", (Object)0);
            } else if (step > 1) {
                viewPage = "process_qna.jsp";
                session.setAttribute("valid", (Object)Boolean.TRUE);
                confirmation = vBean.getKey();
                UserChallengesDTO dto = this.client.getChallengeQuestion(username, confirmation, currentqid);
                session.setAttribute("confirmation", (Object)dto.getKey());
                session.setAttribute("qids", (Object)newqids);
                session.setAttribute("question", (Object)dto.getQuestion());
                session.setAttribute("currentqid", (Object)currentqid);
                session.setAttribute("step", (Object)(step - 1));
            } else {
                viewPage = "password_reset.jsp";
                session.setAttribute("currentqid", null);
                session.setAttribute("step", (Object)0);
                session.setAttribute("confirmation", (Object)vBean.getKey());
                session.setAttribute("valid", null);
            }
        } else {
            UserChallengesDTO dto = this.client.getChallengeQuestion(username, confirmation, currentqid);
            session.setAttribute("confirmation", (Object)dto.getKey());
            session.setAttribute("qids", (Object)newqids);
            session.setAttribute("question", (Object)dto.getQuestion());
            session.setAttribute("currentqid", (Object)currentqid);
            session.setAttribute("valid", (Object)Boolean.TRUE);
            viewPage = "process_qna.jsp";
        }
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }
}

