/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.mgt.stub.dto.ChallengeQuestionDTO;
import org.wso2.carbon.identity.mgt.stub.dto.UserChallengesDTO;
import org.wso2.sample.inforecovery.client.IdentityManagementAdminClient;
import org.wso2.sample.inforecovery.client.UserProfileClient;

public class SecurityQuestionSetupController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SecurityQuestionSetupController.class);
    UserProfileClient client;
    IdentityManagementAdminClient identityManagementAdminClient;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserProfileClient(carbonServerUrl, configContext);
            this.identityManagementAdminClient = new IdentityManagementAdminClient(null, carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        ChallengeQuestionDTO[] challengeQuestionDTOs = null;
        String userName = req.getParameter("username");
        try {
            challengeQuestionDTOs = this.identityManagementAdminClient.getChallengeQuestions();
        }
        catch (Exception e) {
            String msg = "Error occurred while loading security questions";
            log.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
        HashMap<String, ArrayList<String>> questionSets = new HashMap<String, ArrayList<String>>();
        for (ChallengeQuestionDTO challengeQuestionDTO : challengeQuestionDTOs) {
            ArrayList<String> questions = (ArrayList<String>)questionSets.get(challengeQuestionDTO.getQuestionSetId());
            if (questions != null) {
                questions.add(challengeQuestionDTO.getQuestion());
                questionSets.put(challengeQuestionDTO.getQuestionSetId(), questions);
                continue;
            }
            questions = new ArrayList<String>();
            questions.add(challengeQuestionDTO.getQuestion());
            questionSets.put(challengeQuestionDTO.getQuestionSetId(), questions);
        }
        if (questionSets != null) {
            req.setAttribute("questionSet1", questionSets.get("http://wso2.org/claims/challengeQuestion1"));
            req.setAttribute("questionSet2", questionSets.get("http://wso2.org/claims/challengeQuestion2"));
        }
        String viewPage = "setup_security_question.jsp";
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        boolean success = true;
        String username = req.getParameter("username");
        if (username != null) {
            username = session.getAttribute("username").toString();
        }
        String answer1 = req.getParameter("answer1");
        String answer2 = req.getParameter("answer2");
        String question1 = req.getParameter("question1");
        String question2 = req.getParameter("question2");
        UserChallengesDTO userChallengesDTO1 = new UserChallengesDTO();
        userChallengesDTO1.setQuestion(question1);
        userChallengesDTO1.setAnswer(answer1);
        UserChallengesDTO userChallengesDTO2 = new UserChallengesDTO();
        userChallengesDTO2.setQuestion(question2);
        userChallengesDTO2.setAnswer(answer2);
        UserChallengesDTO[] userChallengesDTOs = new UserChallengesDTO[]{userChallengesDTO1, userChallengesDTO2};
        try {
            this.identityManagementAdminClient.setChallengeQuestionsOfUser(username, userChallengesDTOs);
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        String viewPage = "./editUser?username=" + username;
        req.setAttribute("securityQuestionSetupStage", (Object)success);
        res.sendRedirect(viewPage);
    }

    private String getDisplayName(String uri) {
        int startIndex = uri.lastIndexOf("/");
        return uri.substring(startIndex + 1);
    }
}

