/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.captcha.mgt.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.sample.inforecovery.client.UserInformationRecoveryClient;

public class SelfSignupConfirmationController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private UserInformationRecoveryClient client;
    private static final String CONFIRMATION = "confirmation";
    private static final String USER_STORE_DOMAIN = "userstoredomain";
    private static final String USER_NAME = "userName";
    private static final String CAPTCHA = "captcha";
    private static final String CARBON_SERVER_URL = "carbonServerUrl";
    private static final String CAPTCHA_IMAGE_URL = "captchaImageUrl";
    private static final String CAPTCHA_ANSWER = "captchaAnswer";
    private static final String STATUS = "status";
    private static final String CONFIGURATION_CONTEXT = "ConfigurationContext";

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute(CONFIGURATION_CONTEXT);
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter(CARBON_SERVER_URL);
            this.client = new UserInformationRecoveryClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession();
        session.setAttribute(CONFIRMATION, (Object)req.getParameter(CONFIRMATION));
        String userstoredomain = req.getParameter(USER_STORE_DOMAIN);
        String username = req.getParameter(USER_NAME.toLowerCase());
        if (!"PRIMARY".equalsIgnoreCase(userstoredomain) && userstoredomain != null) {
            username = userstoredomain + "/" + username;
        }
        session.setAttribute(USER_NAME, (Object)username);
        CaptchaInfoBean bean = this.client.generateCaptcha();
        session.setAttribute(CAPTCHA, (Object)bean);
        String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter(CARBON_SERVER_URL);
        session.setAttribute(CAPTCHA_IMAGE_URL, (Object)(carbonServerUrl + bean.getImagePath()));
        RequestDispatcher view = req.getRequestDispatcher("signup_confirm.jsp");
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        String userName = (String)session.getAttribute(USER_NAME);
        String code = (String)session.getAttribute(CONFIRMATION);
        CaptchaInfoBean captcha = (CaptchaInfoBean)session.getAttribute(CAPTCHA);
        captcha.setUserAnswer(req.getParameter(CAPTCHA_ANSWER));
        VerificationBean bean = this.client.confirmUserSelfRegistration(userName, code, captcha, null);
        req.setAttribute(STATUS, (Object)bean);
        RequestDispatcher view = req.getRequestDispatcher("signup_confirm_status.jsp");
        view.forward((ServletRequest)req, (ServletResponse)res);
    }
}

