/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.carbon.identity.mgt.stub.dto.UserIdentityClaimDTO;
import org.wso2.sample.inforecovery.client.UserInformationRecoveryClient;
import org.wso2.sample.inforecovery.dto.ClaimUIDto;

public class SelfSignupController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInformationRecoveryClient client;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserInformationRecoveryClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        UserIdentityClaimDTO[] claims = this.client.getUserIdentitySupportedClaims("http://wso2.org/claims");
        ArrayList<ClaimUIDto> claimsUi = new ArrayList<ClaimUIDto>();
        ArrayList<UserIdentityClaimDTO> filteredClaims = new ArrayList<UserIdentityClaimDTO>();
        String viewPage = "signup.jsp";
        if (claims != null) {
            for (UserIdentityClaimDTO claim : claims) {
                ClaimUIDto tempDto = new ClaimUIDto();
                if (claim == null) continue;
                tempDto.setClaimUri(claim.getClaimUri());
                tempDto.setDisplayName(this.getDisplayName(claim.getClaimUri()));
                claimsUi.add(tempDto);
                filteredClaims.add(claim);
            }
            req.setAttribute("claims", (Object)claimsUi.toArray(new ClaimUIDto[claimsUi.size()]));
            session.setAttribute("claims", (Object)filteredClaims.toArray(new UserIdentityClaimDTO[claimsUi.size()]));
        }
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        String userName = req.getParameter("username");
        String password = req.getParameter("password");
        String tenantDomain = "carbon.super";
        UserIdentityClaimDTO[] claims = (UserIdentityClaimDTO[])session.getAttribute("claims");
        if (claims != null) {
            for (UserIdentityClaimDTO claim : claims) {
                if (claim == null) continue;
                claim.setClaimValue(req.getParameter(claim.getClaimUri()));
            }
        }
        VerificationBean bean = this.client.registerUser(userName, password, claims, "default", tenantDomain);
        String viewPage = "signup_status.jsp";
        req.setAttribute("status", (Object)bean);
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    private String getDisplayName(String uri) {
        int startIndex = uri.lastIndexOf("/");
        return uri.substring(startIndex + 1);
    }
}

