/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.inforecovery.controller;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.sample.inforecovery.client.UserInformationRecoveryClient;

public class UpdateController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    UserInformationRecoveryClient client;

    public void init() {
        try {
            ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
            String carbonServerUrl = this.getServletConfig().getServletContext().getInitParameter("carbonServerUrl");
            this.client = new UserInformationRecoveryClient(carbonServerUrl, configContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        String confirmation = (String)session.getAttribute("confirmation");
        String username = (String)session.getAttribute("username");
        String newPassword = req.getParameter("password");
        String viewPage = null;
        if (confirmation != null && session != null) {
            VerificationBean vBean = this.client.resetPassword(username, confirmation, newPassword);
            if (vBean != null && vBean.getVerified()) {
                req.setAttribute("validationStatus", (Object)vBean.getVerified());
                viewPage = "password_reset_result.jsp";
            } else {
                req.setAttribute("errors", (Object)"Missing confirmation code or invalid session. Cannot proceed.");
                viewPage = "error.jsp";
            }
        } else {
            req.setAttribute("errors", (Object)"Missing confirmation code or invalid session. Cannot proceed.");
            viewPage = "error.jsp";
        }
        RequestDispatcher view = req.getRequestDispatcher(viewPage);
        view.forward((ServletRequest)req, (ServletResponse)res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }
}

