/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.sample.group;

import java.io.IOException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.wso2.charon.core.client.SCIMClient;
import org.wso2.charon.core.exceptions.CharonException;
import org.wso2.charon.core.objects.AbstractSCIMObject;
import org.wso2.charon.core.objects.Group;
import org.wso2.charon.core.objects.ListedResource;
import org.wso2.charon.core.objects.SCIMObject;
import org.wso2.charon.core.objects.User;
import org.wso2.charon.core.schema.SCIMConstants;
import org.wso2.scim.sample.utils.SCIMSamplesUtils;

public class CreateGroup {
    private static String userName = "HasiniG";

    public static void main(String[] args) {
        try {
            SCIMSamplesUtils.loadConfiguration();
            SCIMSamplesUtils.setKeyStore();
            SCIMClient scimClient = new SCIMClient();
            Group scimGroup = scimClient.createGroup();
            scimGroup.setExternalId(SCIMSamplesUtils.groupDisplayNameToCreateGroup);
            scimGroup.setDisplayName(SCIMSamplesUtils.groupDisplayNameToCreateGroup);
            String userId = CreateGroup.getSCIMIdOfUser(userName);
            scimGroup.setMember(userId);
            String encodedGroup = scimClient.encodeSCIMObject((AbstractSCIMObject)scimGroup, "json");
            System.out.println("");
            System.out.println("");
            System.out.println("/******Group to be created in json format: " + encodedGroup + "******/");
            System.out.println("");
            PostMethod postMethod = new PostMethod(SCIMSamplesUtils.groupEndpointURL);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            postMethod.addRequestHeader("Authorization", authHeader);
            StringRequestEntity requestEntity = new StringRequestEntity(encodedGroup, "application/json", null);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            HttpClient httpClient = new HttpClient();
            int responseStatus = httpClient.executeMethod((HttpMethod)postMethod);
            String response = postMethod.getResponseBodyAsString();
            System.out.println("");
            System.out.println("");
            System.out.println("/******SCIM group creation response status: " + responseStatus);
            System.out.println("SCIM group creation response data: " + response + "******/");
            System.out.println("");
        }
        catch (CharonException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSCIMIdOfUser(String userName) throws Exception {
        String userId = null;
        try {
            HttpClient httpFilterUserClient = new HttpClient();
            GetMethod getMethod = new GetMethod(SCIMSamplesUtils.userEndpointURL);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            getMethod.addRequestHeader("Authorization", authHeader);
            String filter = "filter=userNameEq" + userName;
            getMethod.setQueryString(filter);
            int responseCode = httpFilterUserClient.executeMethod((HttpMethod)getMethod);
            String response = getMethod.getResponseBodyAsString();
            SCIMClient scimClient = new SCIMClient();
            if (scimClient.evaluateResponseStatus(responseCode)) {
                ListedResource listedUserResource = scimClient.decodeSCIMResponseWithListedResource(response, SCIMConstants.identifyFormat((String)"application/json"), 1);
                List filteredUsers = listedUserResource.getScimObjects();
                for (SCIMObject filteredUser : filteredUsers) {
                    userId = ((User)filteredUser).getId();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Error in obtaining the SCIM Id for user: " + userName);
        }
        catch (CharonException e) {
            throw new Exception("Error in obtaining the SCIM Id for user: " + userName);
        }
        return userId;
    }
}

