/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.sample.group;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.wso2.charon.core.client.SCIMClient;
import org.wso2.charon.core.exceptions.CharonException;
import org.wso2.charon.core.objects.AbstractSCIMObject;
import org.wso2.charon.core.objects.Group;
import org.wso2.charon.core.objects.ListedResource;
import org.wso2.charon.core.objects.SCIMObject;
import org.wso2.charon.core.schema.SCIMConstants;
import org.wso2.scim.sample.utils.SCIMSamplesUtils;

public class UpdateGroup {
    public static void main(String[] args) {
        try {
            SCIMSamplesUtils.loadConfiguration();
            SCIMSamplesUtils.setKeyStore();
            SCIMClient scimClient = new SCIMClient();
            Group scimGroup = scimClient.createGroup();
            scimGroup.setDisplayName(SCIMSamplesUtils.updatedGroupDisplayName);
            String encodedGroup = scimClient.encodeSCIMObject((AbstractSCIMObject)scimGroup, "json");
            String groupId = UpdateGroup.getSCIMIdOfGroup(SCIMSamplesUtils.groupDisplayNameToCreateGroup);
            System.out.println("");
            System.out.println("");
            System.out.println("/******Updated Group in json format: " + encodedGroup + "******/");
            System.out.println("");
            String url = SCIMSamplesUtils.groupEndpointURL + "/" + groupId;
            PutMethod putMethod = new PutMethod(url);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            putMethod.addRequestHeader("Authorization", authHeader);
            StringRequestEntity putRequestEntity = new StringRequestEntity(encodedGroup, "application/json", null);
            putMethod.setRequestEntity((RequestEntity)putRequestEntity);
            HttpClient httpUpdateClient = new HttpClient();
            int updateResponseStatus = httpUpdateClient.executeMethod((HttpMethod)putMethod);
            String updateResponse = putMethod.getResponseBodyAsString();
            System.out.println("");
            System.out.println("");
            System.out.println("/******SCIM group update response status: " + updateResponseStatus);
            System.out.println("SCIM group update response data: " + updateResponse + "******/");
            System.out.println("");
        }
        catch (CharonException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSCIMIdOfGroup(String groupName) throws Exception {
        String groupId = null;
        try {
            HttpClient httpFilterUserClient = new HttpClient();
            GetMethod getMethod = new GetMethod(SCIMSamplesUtils.groupEndpointURL);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            getMethod.addRequestHeader("Authorization", authHeader);
            String filter = "filter=displayNameEq" + groupName;
            getMethod.setQueryString(filter);
            int responseCode = httpFilterUserClient.executeMethod((HttpMethod)getMethod);
            String response = getMethod.getResponseBodyAsString();
            SCIMClient scimClient = new SCIMClient();
            if (scimClient.evaluateResponseStatus(responseCode)) {
                ListedResource listedGroupResource = scimClient.decodeSCIMResponseWithListedResource(response, SCIMConstants.identifyFormat((String)"application/json"), 2);
                List filteredGroups = listedGroupResource.getScimObjects();
                for (SCIMObject filteredGroup : filteredGroups) {
                    groupId = ((Group)filteredGroup).getId();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Error in obtaining the SCIM Id for user: " + groupName);
        }
        catch (CharonException e) {
            throw new Exception("Error in obtaining the SCIM Id for user: " + groupName);
        }
        return groupId;
    }
}

