/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.sample.user;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.wso2.charon.core.client.SCIMClient;
import org.wso2.charon.core.exceptions.CharonException;
import org.wso2.charon.core.objects.ListedResource;
import org.wso2.charon.core.objects.SCIMObject;
import org.wso2.charon.core.objects.User;
import org.wso2.charon.core.schema.SCIMConstants;
import org.wso2.scim.sample.utils.SCIMSamplesUtils;

public class DeleteUser {
    public static void main(String[] args) {
        try {
            SCIMSamplesUtils.loadConfiguration();
            SCIMSamplesUtils.setKeyStore();
            String userId = DeleteUser.getSCIMIdOfUser(SCIMSamplesUtils.userNameToDeleteUser);
            String url = SCIMSamplesUtils.userEndpointURL + "/" + userId;
            DeleteMethod deleteMethod = new DeleteMethod(url);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            deleteMethod.addRequestHeader("Authorization", authHeader);
            HttpClient httpDeleteClient = new HttpClient();
            int deleteResponseStatus = httpDeleteClient.executeMethod((HttpMethod)deleteMethod);
            String deleteResponse = deleteMethod.getResponseBodyAsString();
            System.out.println("");
            System.out.println("");
            System.out.println("/******SCIM user delete response status: " + deleteResponseStatus);
            System.out.println("SCIM user delete response data: " + deleteResponse + "******/");
            System.out.println("");
        }
        catch (CharonException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSCIMIdOfUser(String userName) throws Exception {
        String userId = null;
        try {
            HttpClient httpFilterUserClient = new HttpClient();
            GetMethod getMethod = new GetMethod(SCIMSamplesUtils.userEndpointURL);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            getMethod.addRequestHeader("Authorization", authHeader);
            String filter = "filter=userNameEq" + userName;
            getMethod.setQueryString(filter);
            int responseCode = httpFilterUserClient.executeMethod((HttpMethod)getMethod);
            String response = getMethod.getResponseBodyAsString();
            SCIMClient scimClient = new SCIMClient();
            if (scimClient.evaluateResponseStatus(responseCode)) {
                ListedResource listedUserResource = scimClient.decodeSCIMResponseWithListedResource(response, SCIMConstants.identifyFormat((String)"application/json"), 1);
                List filteredUsers = listedUserResource.getScimObjects();
                for (SCIMObject filteredUser : filteredUsers) {
                    userId = ((User)filteredUser).getId();
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Error in obtaining the SCIM Id for user: " + userName);
        }
        catch (CharonException e) {
            throw new Exception("Error in obtaining the SCIM Id for user: " + userName);
        }
        return userId;
    }
}

