/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.developerstudio.eclipse.utils.internal.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.wso2.developerstudio.eclipse.utils.data.ITemporaryFileTag;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;

public class TempFileTag
implements ITemporaryFileTag {
    private String id;
    private boolean tagEnded;
    private List<File> locations;

    public TempFileTag(String id) {
        this.setId(id);
    }

    public TempFileTag() {
        this.setId(String.valueOf(Calendar.getInstance().getTime().getTime()));
    }

    private void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private void setTagEnded(boolean tagEnded) {
        this.tagEnded = tagEnded;
    }

    @Override
    public boolean isTagEnded() {
        return this.tagEnded;
    }

    @Override
    public List<File> getLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList<File>();
        }
        return this.locations;
    }

    @Override
    public void removeMe() {
    }

    @Override
    public void clear() {
        for (File file : this.getLocations()) {
            if (!file.exists()) continue;
            if (file.isFile()) {
                file.delete();
                continue;
            }
            FileUtils.deleteDirectories(file);
        }
    }

    @Override
    public void endTag() {
        this.setTagEnded(true);
    }

    @Override
    public void pauseTag() {
        this.endTag();
    }

    @Override
    public void clearAndEnd() {
        this.clear();
        this.endTag();
    }

    @Override
    public void restartTag() {
        this.setTagEnded(false);
    }

    @Override
    public void resumeTag() {
        this.restartTag();
    }
}

