/*
 * Decompiled with CFR 0.152.
 */
package org.wurbelizer.console.wurbel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.wurbelizer.misc.DefaultLogger;
import org.wurbelizer.misc.Logger;
import org.wurbelizer.misc.Verbosity;
import org.wurbelizer.wurbel.AbstractWurbler;
import org.wurbelizer.wurbel.SourceException;
import org.wurbelizer.wurbel.WurbelException;
import org.wurbelizer.wurbel.WurbelResult;

public class ConsoleWurbler
extends AbstractWurbler {
    private final int phase;
    private final Set<Integer> collectedPhases;
    private String analyzeDir;
    private final Logger logger;
    private Verbosity verbosity;

    public ConsoleWurbler(String[] args, int phase, Set<Integer> collectedPhases) throws WurbelException {
        this.phase = phase;
        this.collectedPhases = Objects.requireNonNull(collectedPhases);
        this.logger = new DefaultLogger();
        this.verbosity = Verbosity.DEFAULT;
        int wurbArgCount = 0;
        boolean wurbletLoaded = false;
        for (int argc = 0; argc < args.length; ++argc) {
            String arg = args[argc];
            if (arg.startsWith("--out=")) {
                this.setPrintStream(this.createOutputStream(arg.substring(6), false));
                args[argc] = null;
                continue;
            }
            if (arg.startsWith("++out=")) {
                this.setPrintStream(this.createOutputStream(arg.substring(6), true));
                args[argc] = null;
                continue;
            }
            if (arg.startsWith("--analyzedir=")) {
                this.analyzeDir = arg.substring(10);
                args[argc] = null;
                continue;
            }
            if (!wurbletLoaded && !arg.startsWith("--")) {
                this.loadWurblet(arg, null, null);
                wurbletLoaded = true;
                args[argc] = null;
                continue;
            }
            if (arg.startsWith("--verbosity=")) {
                try {
                    this.verbosity = Verbosity.valueOf((String)arg.substring(12));
                }
                catch (RuntimeException ex) {
                    this.verbosity = Verbosity.DEFAULT;
                }
                continue;
            }
            ++wurbArgCount;
        }
        if (!this.isFixedArgs()) {
            String[] wurbletArgs = new String[wurbArgCount];
            wurbArgCount = 0;
            for (String arg : args) {
                if (arg == null) continue;
                wurbletArgs[wurbArgCount++] = arg;
            }
            this.setArgs(wurbletArgs);
        }
    }

    public WurbelResult wurbel() throws WurbelException, SourceException {
        boolean executed = this.runWurblet(this.phase, this.collectedPhases);
        return new WurbelResult(executed ? 1 : 0, 0, executed ? WurbelResult.UpdateType.UPDATED : WurbelResult.UpdateType.UNCHANGED);
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getInvocationCount() {
        return 1;
    }

    public File getAnalyzeFile(String name) {
        return new File(this.analyzeDir, name);
    }

    private PrintStream createOutputStream(String name, boolean append) throws WurbelException {
        try {
            return new PrintStream(new FileOutputStream(name, append));
        }
        catch (FileNotFoundException ex) {
            throw new WurbelException("cannot create output stream: " + name, (Throwable)ex);
        }
    }

    private static void usage() {
        System.out.println("usage: java org.wurbelizer.ConsoleWurbler [--|++out=<outputfile>] [--analyzedir=<dir>] [--verbosity=default|info|debug] <wurblet> [wurblet options and args...]");
        System.exit(1);
    }

    private static void run(String[] args) {
        TreeSet<Integer> collectedPhases = new TreeSet<Integer>();
        try {
            int phase = 1;
            while (true) {
                new ConsoleWurbler(args, phase, collectedPhases).wurbel();
                Integer nextPhase = collectedPhases.higher(phase);
                if (nextPhase != null) {
                    phase = nextPhase;
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException | SourceException | WurbelException ex) {
            System.err.println("/*");
            ex.printStackTrace();
            System.err.println("*/");
        }
    }

    private static void globRun(String glob, String[] args) {
        try {
            Pattern pattern;
            File[] files;
            int ndx = glob.lastIndexOf(File.separatorChar);
            File globDir = new File(ndx > 0 ? glob.substring(0, ndx) : ".");
            if (ndx > 0) {
                glob = glob.substring(ndx + 1);
            }
            if ((files = globDir.listFiles((arg_0, arg_1) -> ConsoleWurbler.lambda$globRun$0(pattern = Pattern.compile(glob), arg_0, arg_1))) != null) {
                Arrays.sort(files, Comparator.comparing(File::getPath));
                for (File file : files) {
                    String[] sargs = new String[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        String a = args[i];
                        if (a.equals("@")) {
                            a = file.getPath();
                        }
                        sargs[i] = a;
                    }
                    ConsoleWurbler.run(sargs);
                }
            }
        }
        catch (RuntimeException ex) {
            System.err.println("/*");
            ex.printStackTrace();
            System.err.println("*/");
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            ConsoleWurbler.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("--glob=")) continue;
            String glob = arg.substring(7);
            args[i] = null;
            String[] globArgs = new String[args.length - 1];
            int ndx = 0;
            for (String a : args) {
                if (a == null) continue;
                globArgs[ndx++] = a;
            }
            ConsoleWurbler.globRun(glob, globArgs);
            return;
        }
        ConsoleWurbler.run(args);
    }

    private static /* synthetic */ boolean lambda$globRun$0(Pattern pattern, File dir, String name) {
        return pattern.matcher(name).matches();
    }
}

