/*
 * Decompiled with CFR 0.152.
 */
package org.wurbelizer.console.wurbile;

import java.io.File;
import java.io.IOException;
import org.wurbelizer.misc.DefaultLogger;
import org.wurbelizer.misc.Logger;
import org.wurbelizer.misc.Verbosity;
import org.wurbelizer.wurbile.SourceWurbiler;
import org.wurbelizer.wurbile.WurbileException;

public class ConsoleWurbiler {
    private static void usage() {
        System.out.println("usage: java org.wurbelizer.ConsoleWurbiler [--verbose=default|info|debug] [--indent=n] [--extends=<classpath>] [--package=<package>] <wurbelizable>.wrbl");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            ConsoleWurbiler.usage();
        }
        String wrblname = null;
        String parentClass = null;
        String packageName = null;
        int indent = -1;
        Verbosity verbosity = Verbosity.DEFAULT;
        for (int argc = 0; argc < args.length; ++argc) {
            String arg = args[argc];
            if (arg.startsWith("--indent=")) {
                indent = Integer.parseInt(arg.substring(9));
                continue;
            }
            if (arg.startsWith("--extends=")) {
                parentClass = arg.substring(10);
                continue;
            }
            if (arg.startsWith("--package=")) {
                packageName = arg.substring(10);
                continue;
            }
            if (arg.startsWith("--verbosity=")) {
                try {
                    verbosity = Verbosity.valueOf((String)arg.substring(12));
                }
                catch (RuntimeException ex) {
                    verbosity = Verbosity.DEFAULT;
                }
                continue;
            }
            if (argc != args.length - 1) continue;
            wrblname = arg;
        }
        if (wrblname == null) {
            ConsoleWurbiler.usage();
        }
        try {
            int errors;
            File wrblFile = new File(wrblname);
            String dirname = wrblFile.getParent();
            if (dirname == null) {
                dirname = ".";
            }
            File outputDir = new File(dirname);
            SourceWurbiler wurbiler = new SourceWurbiler(wrblFile, outputDir, outputDir, (Logger)new DefaultLogger(), verbosity);
            if (indent != -1) {
                wurbiler.setIndent(indent);
            }
            if (packageName != null) {
                wurbiler.setPackageName(packageName);
            }
            if (parentClass != null) {
                wurbiler.setParentClass(parentClass);
            }
            if ((errors = wurbiler.compile()) > 0) {
                System.err.println(errors + " error" + (errors > 1 ? "s" : ""));
                System.exit(2);
            }
        }
        catch (IOException | RuntimeException | WurbileException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

