/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.canvas;

import java.nio.ByteBuffer;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import wvlet.airframe.canvas.Canvas;
import wvlet.airframe.canvas.Memory;
import wvlet.airframe.canvas.UnsafeCanvas$;
import wvlet.airframe.canvas.UnsafeUtil$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0015*\u0005AB\u0011\"\u000e\u0001\u0003\u0006\u0004%\t!\u000b\u001c\t\u0011u\u0002!\u0011!Q\u0001\n]B\u0011B\u0010\u0001\u0003\u0006\u0004%\t!K \t\u0011\r\u0003!\u0011!Q\u0001\n\u0001C\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0001\"Ia\t\u0001BC\u0002\u0013\u0005\u0011F\u000e\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005o!)\u0001\n\u0001C\u0001\u0013\")q\n\u0001C!!\")a\u000b\u0001C!/\")A\f\u0001C!;\")!\r\u0001C!G\")\u0001\u000e\u0001C!S\")1\u000e\u0001C!Y\")a\u000e\u0001C!_\")\u0011\u000f\u0001C!e\")q\u000f\u0001C!q\")Q\u0010\u0001C!}\"1Q\u0010\u0001C!\u0003'Aq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011Q\u000e\u0001\u0005B\u0005u\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\t\u0019\n\u0001C!\u0003+;q!a&*\u0011\u0003\tIJ\u0002\u0004)S!\u0005\u00111\u0014\u0005\u0007\u0011\u0012\"\t!!(\t\u000f\u0005}E\u0005\"\u0001\u0002\"\"9\u0011q\u0014\u0013\u0005\u0002\u0005-&\u0001D+og\u00064WmQ1om\u0006\u001c(B\u0001\u0016,\u0003\u0019\u0019\u0017M\u001c<bg*\u0011A&L\u0001\tC&\u0014hM]1nK*\ta&A\u0003xm2,Go\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a4\u001b\u0005I\u0013B\u0001\u001b*\u0005\u0019\u0019\u0015M\u001c<bg\u0006!!-Y:f+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g-A\u0003cCN,\u0007%A\u0004bI\u0012\u0014Xm]:\u0016\u0003\u0001\u0003\"\u0001O!\n\u0005\tK$\u0001\u0002'p]\u001e\f\u0001\"\u00193ee\u0016\u001c8\u000fI\u0001\u0005g&TX-A\u0003tSj,\u0007%A\u0005sK\u001a,'/\u001a8dK\u0006Q!/\u001a4fe\u0016t7-\u001a\u0011\u0002\rqJg.\u001b;?)\u0015Q5\nT'O!\t\u0011\u0004\u0001C\u00036\u0013\u0001\u0007q\u0007C\u0003?\u0013\u0001\u0007\u0001\tC\u0003E\u0013\u0001\u0007\u0001\tC\u0003G\u0013\u0001\u0007q'\u0001\u0005sK\u0006$')\u001f;f)\t\tF\u000b\u0005\u00029%&\u00111+\u000f\u0002\u0005\u0005f$X\rC\u0003V\u0015\u0001\u0007\u0001)\u0001\u0004pM\u001a\u001cX\r^\u0001\fe\u0016\fGMQ8pY\u0016\fg\u000e\u0006\u0002Y7B\u0011\u0001(W\u0005\u00035f\u0012qAQ8pY\u0016\fg\u000eC\u0003V\u0017\u0001\u0007\u0001)A\u0005sK\u0006$7\u000b[8siR\u0011a,\u0019\t\u0003q}K!\u0001Y\u001d\u0003\u000bMCwN\u001d;\t\u000bUc\u0001\u0019\u0001!\u0002\u000fI,\u0017\rZ%oiR\u0011Am\u001a\t\u0003q\u0015L!AZ\u001d\u0003\u0007%sG\u000fC\u0003V\u001b\u0001\u0007\u0001)\u0001\tsK\u0006$\u0017J\u001c;CS\u001e,e\u000eZ5b]R\u0011AM\u001b\u0005\u0006+:\u0001\r\u0001Q\u0001\te\u0016\fG\rT8oOR\u0011\u0001)\u001c\u0005\u0006+>\u0001\r\u0001Q\u0001\u0012e\u0016\fG\rT8oO\nKw-\u00128eS\u0006tGC\u0001!q\u0011\u0015)\u0006\u00031\u0001A\u0003%\u0011X-\u00193GY>\fG\u000f\u0006\u0002tmB\u0011\u0001\b^\u0005\u0003kf\u0012QA\u00127pCRDQ!V\tA\u0002\u0001\u000b!B]3bI\u0012{WO\u00197f)\tIH\u0010\u0005\u00029u&\u001110\u000f\u0002\u0007\t>,(\r\\3\t\u000bU\u0013\u0002\u0019\u0001!\u0002\u0013I,\u0017\r\u001a\"zi\u0016\u001cH#C@\u0002\u0006\u0005\u001d\u00111BA\b!\rA\u0014\u0011A\u0005\u0004\u0003\u0007I$\u0001B+oSRDQ!V\nA\u0002\u0001Ca!!\u0003\u0014\u0001\u0004\t\u0014\u0001\u00023fgRDa!!\u0004\u0014\u0001\u0004\u0001\u0015A\u00033fgR|eMZ:fi\"1\u0011\u0011C\nA\u0002\u0001\u000ba\u0001\\3oORDG#C@\u0002\u0016\u0005]\u0011qDA\u0011\u0011\u0015)F\u00031\u0001A\u0011\u001d\tI\u0001\u0006a\u0001\u00033\u0001B\u0001OA\u000e#&\u0019\u0011QD\u001d\u0003\u000b\u0005\u0013(/Y=\t\r\u00055A\u00031\u0001e\u0011\u0019\t\t\u0002\u0006a\u0001I\u0006IqO]5uK\nKH/\u001a\u000b\u0006\u007f\u0006\u001d\u0012\u0011\u0006\u0005\u0006+V\u0001\r\u0001\u0011\u0005\u0007\u0003W)\u0002\u0019A)\u0002\u0003Y\fAb\u001e:ji\u0016\u0014un\u001c7fC:$Ra`A\u0019\u0003gAQ!\u0016\fA\u0002\u0001Ca!a\u000b\u0017\u0001\u0004A\u0016AC<sSR,7\u000b[8siR)q0!\u000f\u0002<!)Qk\u0006a\u0001\u0001\"1\u00111F\fA\u0002y\u000b\u0001b\u001e:ji\u0016Le\u000e\u001e\u000b\u0006\u007f\u0006\u0005\u00131\t\u0005\u0006+b\u0001\r\u0001\u0011\u0005\u0007\u0003WA\u0002\u0019\u00013\u0002#]\u0014\u0018\u000e^3J]R\u0014\u0015nZ#oI&\fg\u000eF\u0003\u0000\u0003\u0013\nY\u0005C\u0003V3\u0001\u0007\u0001\t\u0003\u0004\u0002,e\u0001\r\u0001Z\u0001\noJLG/\u001a'p]\u001e$Ra`A)\u0003'BQ!\u0016\u000eA\u0002\u0001Ca!a\u000b\u001b\u0001\u0004\u0001\u0015AE<sSR,Gj\u001c8h\u0005&<WI\u001c3jC:$Ra`A-\u00037BQ!V\u000eA\u0002\u0001Ca!a\u000b\u001c\u0001\u0004\u0001\u0015AC<sSR,g\t\\8biR)q0!\u0019\u0002d!)Q\u000b\ba\u0001\u0001\"1\u00111\u0006\u000fA\u0002M\f1b\u001e:ji\u0016$u.\u001e2mKR)q0!\u001b\u0002l!)Q+\ba\u0001\u0001\"1\u00111F\u000fA\u0002e\f!b\u001e:ji\u0016\u0014\u0015\u0010^3t)%y\u0018\u0011OA:\u0003o\nY\bC\u0003V=\u0001\u0007\u0001\tC\u0004\u0002vy\u0001\r!!\u0007\u0002\u0007M\u00148\r\u0003\u0004\u0002zy\u0001\r\u0001Z\u0001\ngJ\u001cwJ\u001a4tKRDa!!\u0005\u001f\u0001\u0004!G#C@\u0002\u0000\u0005\u0005\u00151QAC\u0011\u0015)v\u00041\u0001A\u0011\u0019\t)h\ba\u0001c!1\u0011\u0011P\u0010A\u0002\u0001Ca!!\u0005 \u0001\u0004\u0001\u0015!B:mS\u000e,G#B\u0019\u0002\f\u00065\u0005\"B+!\u0001\u0004\u0001\u0005BBA\tA\u0001\u0007\u0001)A\u0006u_\nKH/Z!se\u0006LXCAA\r\u0003\u001d\u0011X\r\\3bg\u0016,\u0012a`\u0001\r+:\u001c\u0018MZ3DC:4\u0018m\u001d\t\u0003e\u0011\u001a\"\u0001J\u001c\u0015\u0005\u0005e\u0015\u0001B<sCB$r!MAR\u0003O\u000bI\u000bC\u0004\u0002&\u001a\u0002\r!!\u0007\u0002\u0007\u0005\u0014(\u000fC\u0003VM\u0001\u0007A\r\u0003\u0004\u0002\u0012\u0019\u0002\r\u0001\u001a\u000b\u0004c\u00055\u0006bBAXO\u0001\u0007\u0011\u0011W\u0001\u0004EV4\u0007\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0004]&|'BAA^\u0003\u0011Q\u0017M^1\n\t\u0005}\u0016Q\u0017\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b")
public final class UnsafeCanvas
extends Canvas {
    private final Object base;
    private final long address;
    private final long size;
    private final Object reference;

    public static Canvas wrap(ByteBuffer byteBuffer) {
        return UnsafeCanvas$.MODULE$.wrap(byteBuffer);
    }

    public static Canvas wrap(byte[] byArray, int n, int n2) {
        return UnsafeCanvas$.MODULE$.wrap(byArray, n, n2);
    }

    public Object base() {
        return this.base;
    }

    public long address() {
        return this.address;
    }

    @Override
    public long size() {
        return this.size;
    }

    public Object reference() {
        return this.reference;
    }

    @Override
    public byte readByte(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getByte(this.base(), this.address() + offset);
    }

    @Override
    public boolean readBoolean(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getBoolean(this.base(), this.address() + offset);
    }

    @Override
    public short readShort(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getShort(this.base(), this.address() + offset);
    }

    @Override
    public int readInt(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getInt(this.base(), this.address() + offset);
    }

    @Override
    public int readIntBigEndian(long offset) {
        return Integer.reverseBytes(this.readInt(offset));
    }

    @Override
    public long readLong(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getLong(this.base(), this.address() + offset);
    }

    @Override
    public long readLongBigEndian(long offset) {
        return Long.reverseBytes(this.readLong(offset));
    }

    @Override
    public float readFloat(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getFloat(this.base(), this.address() + offset);
    }

    @Override
    public double readDouble(long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getDouble(this.base(), this.address() + offset);
    }

    @Override
    public void readBytes(long offset, Canvas dest, long destOffset, long length) {
        Canvas canvas = dest;
        if (canvas instanceof UnsafeCanvas) {
            UnsafeCanvas unsafeCanvas = (UnsafeCanvas)canvas;
            UnsafeUtil$.MODULE$.unsafe().copyMemory(this.base(), this.address() + offset, unsafeCanvas.base(), unsafeCanvas.address() + destOffset, length);
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(15).append("readBytes from ").append(canvas.getClass()).toString());
    }

    @Override
    public void readBytes(long offset, byte[] dest, int destOffset, int length) {
        UnsafeUtil$.MODULE$.unsafe().copyMemory(this.base(), this.address() + offset, dest, UnsafeUtil$.MODULE$.arrayByteBaseOffset() + (long)destOffset, length);
    }

    @Override
    public void writeByte(long offset, byte v) {
        UnsafeUtil$.MODULE$.unsafe().putByte(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeBoolean(long offset, boolean v) {
        UnsafeUtil$.MODULE$.unsafe().putBoolean(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeShort(long offset, short v) {
        UnsafeUtil$.MODULE$.unsafe().putShort(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeInt(long offset, int v) {
        UnsafeUtil$.MODULE$.unsafe().putInt(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeIntBigEndian(long offset, int v) {
        UnsafeUtil$.MODULE$.unsafe().putInt(this.base(), this.address() + offset, Integer.reverseBytes(v));
    }

    @Override
    public void writeLong(long offset, long v) {
        UnsafeUtil$.MODULE$.unsafe().putLong(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeLongBigEndian(long offset, long v) {
        UnsafeUtil$.MODULE$.unsafe().putLong(this.base(), this.address() + offset, Long.reverseBytes(v));
    }

    @Override
    public void writeFloat(long offset, float v) {
        UnsafeUtil$.MODULE$.unsafe().putFloat(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeDouble(long offset, double v) {
        UnsafeUtil$.MODULE$.unsafe().putDouble(this.base(), this.address() + offset, v);
    }

    @Override
    public void writeBytes(long offset, byte[] src, int srcOffset, int length) {
        UnsafeUtil$.MODULE$.unsafe().copyMemory(src, UnsafeUtil$.MODULE$.arrayByteBaseOffset() + (long)srcOffset, this.base(), this.address() + offset, length);
    }

    @Override
    public void writeBytes(long offset, Canvas src, long srcOffset, long length) {
        Canvas canvas = src;
        if (canvas instanceof UnsafeCanvas) {
            UnsafeCanvas unsafeCanvas = (UnsafeCanvas)canvas;
            UnsafeUtil$.MODULE$.unsafe().copyMemory(unsafeCanvas.base(), unsafeCanvas.address() + srcOffset, this.base(), this.address() + offset, length);
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(14).append("writeBytes to ").append(canvas.getClass()).toString());
    }

    @Override
    public Canvas slice(long offset, long length) {
        if (offset == 0L && length == this.size()) {
            return this;
        }
        if (offset + length > this.size()) {
            throw new IllegalArgumentException(new StringBuilder(32).append(length).append(" is longer than the Canvas size ").append(this.size()).toString());
        }
        return new UnsafeCanvas(this.base(), this.address() + offset, length, this.reference());
    }

    @Override
    public byte[] toByteArray() {
        if (!RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(this.size()))) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Canvas size ").append(this.size()).append(" exceeds Array[Byte] size limit").toString());
        }
        byte[] b = new byte[(int)this.size()];
        UnsafeUtil$.MODULE$.unsafe().copyMemory(this.base(), this.address(), b, UnsafeUtil$.MODULE$.arrayByteBaseOffset(), this.size());
        return b;
    }

    @Override
    public void release() {
        if (this.base() == null) {
            Object object = this.reference();
            if (object instanceof Memory) {
                Memory memory = (Memory)object;
                memory.release();
                return;
            }
            return;
        }
    }

    public UnsafeCanvas(Object base, long address, long size, Object reference) {
        this.base = base;
        this.address = address;
        this.size = size;
        this.reference = reference;
    }
}

