/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.control.CircuitBreakerRecoveryPolicy;

public final class CircuitBreakerRecoveryPolicy$
implements Serializable {
    public static final CircuitBreakerRecoveryPolicy$ MODULE$ = new CircuitBreakerRecoveryPolicy$();

    private CircuitBreakerRecoveryPolicy$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CircuitBreakerRecoveryPolicy$.class);
    }

    public CircuitBreakerRecoveryPolicy recoverImmediately() {
        return new CircuitBreakerRecoveryPolicy(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public void recordSuccess() {
            }

            public void recordFailure() {
            }

            public void reset() {
            }

            public boolean canRecover() {
                return true;
            }
        };
    }

    public CircuitBreakerRecoveryPolicy recoverAfterConsecutiveSuccesses(int numberOfSuccess) {
        return new CircuitBreakerRecoveryPolicy(numberOfSuccess, this){
            private final int numberOfSuccess$1;
            private final AtomicInteger counter;
            {
                this.numberOfSuccess$1 = numberOfSuccess$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.counter = new AtomicInteger(0);
            }

            public void recordSuccess() {
                this.counter.incrementAndGet();
            }

            public void recordFailure() {
                this.counter.set(0);
            }

            public void reset() {
                this.counter.set(0);
            }

            public boolean canRecover() {
                return this.counter.get() >= this.numberOfSuccess$1;
            }
        };
    }

    public CircuitBreakerRecoveryPolicy recoverAfterWait(int elapsedTimeMillis) {
        return new CircuitBreakerRecoveryPolicy(elapsedTimeMillis, this){
            private final int elapsedTimeMillis$1;
            private final AtomicLong timestamp;
            {
                this.elapsedTimeMillis$1 = elapsedTimeMillis$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.timestamp = new AtomicLong(Long.MAX_VALUE);
            }

            public void recordSuccess() {
                this.timestamp.compareAndSet(Long.MAX_VALUE, System.currentTimeMillis());
            }

            public void recordFailure() {
                this.timestamp.set(Long.MAX_VALUE);
            }

            public void reset() {
                this.timestamp.set(Long.MAX_VALUE);
            }

            public boolean canRecover() {
                return this.timestamp.get() <= System.currentTimeMillis() - (long)this.elapsedTimeMillis$1;
            }
        };
    }
}

