/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.util.Map;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WeakHashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;
import scala.util.Try$;
import scala.util.matching.Regex;
import wvlet.airframe.control.CommandLineTokenizer$;
import wvlet.airframe.control.OS$;
import wvlet.airframe.control.OSType;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class Shell$
implements LogSupport {
    public static Shell$ MODULE$;
    private final WeakHashMap<String, Option<String>> cmdPathCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Shell$();
    }

    private Logger logger$lzycompute() {
        Shell$ shell$ = this;
        synchronized (shell$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private <U> U withAccessTo(Field f, Object obj, Function0<U> body) {
        Object object;
        boolean a = f.isAccessible();
        try {
            if (!a) {
                f.setAccessible(true);
            }
            object = body.apply();
        }
        finally {
            if (!a) {
                f.setAccessible(a);
            }
        }
        return (U)object;
    }

    public int kill(int pid, String signal) {
        BoxedUnit boxedUnit;
        Process p = this.launchProcess(new StringOps(Predef$.MODULE$.augmentString("kill -%s %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signal, BoxesRunTime.boxToInteger((int)pid)})));
        p.waitFor();
        int exitCode = p.exitValue();
        if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 52, 10), (Object)new java.lang.StringBuilder(31).append("killed process ").append(pid).append(" with exit code ").append(exitCode).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return exitCode;
    }

    public String kill$default$2() {
        return "TERM";
    }

    public int killTree(int pid, String signal) {
        int arg$macro$1 = pid;
        this.exec(new StringOps("kill -STOP %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)})));
        ProcessBuilder pb = this.prepareProcessBuilder(new java.lang.StringBuilder(22).append("ps -o pid -p ").append(pid).append(" | sed 1d").toString(), true);
        Process$.MODULE$.apply(pb).lineStream().foreach((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToInteger((int)Shell$.$anonfun$killTree$1(signal, line)));
        this.exec(new java.lang.StringBuilder(7).append("kill -").append(signal).append(" ").append(pid).toString());
        return this.exec(new java.lang.StringBuilder(11).append("kill -CONT ").append(pid).toString());
    }

    public String killTree$default$2() {
        return "TERM";
    }

    public String escape(String s) {
        Regex r = new StringOps(Predef$.MODULE$.augmentString("([^\\\\])(\\\")")).r();
        StringBuilder b = new StringBuilder();
        IntRef cursor = IntRef.create((int)0);
        r.findAllIn((CharSequence)s).matchData().foreach((Function1 & Serializable & scala.Serializable)m -> {
            Shell$.$anonfun$escape$1(b, s, cursor, m);
            return BoxedUnit.UNIT;
        });
        b.append(s.substring(cursor.elem));
        return b.result();
    }

    public String unescape(String s) {
        Regex r = new StringOps(Predef$.MODULE$.augmentString("(\\\\)([\\\\/\\\\\"bfnrt])")).r();
        StringBuilder b = new StringBuilder();
        IntRef cursor = IntRef.create((int)0);
        r.findAllIn((CharSequence)s).matchData().foreach((Function1 & Serializable & scala.Serializable)m -> {
            Shell$.$anonfun$unescape$1(b, s, cursor, m);
            return BoxedUnit.UNIT;
        });
        b.append(s.substring(cursor.elem));
        return b.result();
    }

    public void launchRemoteDaemon(String host, String cmdLine) {
        this.execRemote(host, new java.lang.StringBuilder(26).append(cmdLine).append(" < /dev/null > /dev/null &").toString());
    }

    public int getProcessIDOfCurrentJVM() {
        RuntimeMXBean r = ManagementFactory.getRuntimeMXBean();
        String n = r.getName();
        return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])n.split("@"))).headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Shell$.$anonfun$getProcessIDOfCurrentJVM$1(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
    }

    public Option<Object> getProcessID(Process p) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> (int)p.pid()).toOption().orElse((Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            try {
                Field f = p.getClass().getDeclaredField("pid");
                int pid = BoxesRunTime.unboxToInt(MODULE$.withAccessTo(f, p, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)f.get(p))));
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)pid));
            }
            catch (Throwable e) {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public Process launchJava(String args) {
        Option<String> javaCmd = this.findJavaCommand(this.findJavaCommand$default$1());
        if (javaCmd.isEmpty()) {
            throw new IllegalStateException("No JVM is found. Set JAVA_HOME environmental variable");
        }
        String cmdLine = new StringOps(Predef$.MODULE$.augmentString("%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaCmd.get(), args}));
        return this.launchProcess(cmdLine);
    }

    /*
     * WARNING - void declaration
     */
    public int exec(String cmdLine) {
        void var3_3;
        BoxedUnit boxedUnit;
        ProcessBuilder pb = this.prepareProcessBuilder(cmdLine, true);
        int exitCode = Process$.MODULE$.apply(pb).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)out -> {
            Shell$.$anonfun$exec$1(out);
            return BoxedUnit.UNIT;
        }));
        if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 168, 10), (Object)new java.lang.StringBuilder(28).append("exec command ").append(cmdLine).append(" with exitCode:").append(exitCode).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Process launchProcess(String cmdLine) {
        void var3_3;
        BoxedUnit boxedUnit;
        ProcessBuilder pb = this.prepareProcessBuilder(cmdLine, true);
        Process p = pb.start();
        if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 175, 10), (Object)new java.lang.StringBuilder(20).append("exec command [pid:").append(this.getProcessID(p)).append("] ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(pb.command()).asScala()).mkString(" ")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public int execRemote(String hostname, String cmdLine) {
        BoxedUnit boxedUnit;
        ProcessBuilder pb = this.prepareProcessBuilderFromSeq((Seq<String>)((Seq)new .colon.colon((Object)"ssh", (List)new .colon.colon((Object)hostname, (List)new .colon.colon((Object)this.quote(cmdLine), (List)Nil$.MODULE$)))), true);
        int exitCode = Process$.MODULE$.apply(pb).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)out -> {
            Shell$.$anonfun$execRemote$1(out);
            return BoxedUnit.UNIT;
        }));
        if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 182, 10), (Object)new java.lang.StringBuilder(28).append("exec command ").append(cmdLine).append(" with exitCode:").append(exitCode).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return exitCode;
    }

    private String quote(String s) {
        return s.replaceAll("\\\"", "\\\\\"");
    }

    public ProcessBuilder prepareProcessBuilder(String cmdLine, boolean inheritIO) {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 191, 10), (Object)new java.lang.StringBuilder(9).append("cmdLine: ").append(cmdLine).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] tokens = (String[])((Object[])new String[]{this.getCommand("sh"), "-c", OS$.MODULE$.isWindows() ? this.quote(cmdLine) : cmdLine});
        return this.prepareProcessBuilderFromSeq((Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).toIndexedSeq(), inheritIO);
    }

    /*
     * WARNING - void declaration
     */
    public ProcessBuilder prepareProcessBuilderFromSeq(Seq<String> tokens, boolean inheritIO) {
        void var3_3;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 197, 10), (Object)new java.lang.StringBuilder(21).append("command line tokens: ").append(tokens.mkString(", ")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ProcessBuilder pb = new ProcessBuilder((String[])tokens.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object object = inheritIO ? pb.inheritIO() : BoxedUnit.UNIT;
        scala.collection.immutable.Map env = this.getEnv();
        if (OS$.MODULE$.isWindows()) {
            env = env.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CYGWIN"), (Object)"notty"));
        }
        Map<String, String> envMap = pb.environment();
        env.foreach((Function1 & Serializable & scala.Serializable)e -> (String)envMap.put((String)e._1(), (String)e._2()));
        return var3_3;
    }

    public scala.collection.immutable.Map<String, String> getEnv() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.sys.process.Process launchCmdExe(String cmdLine) {
        BoxedUnit boxedUnit;
        String c = new StringOps(Predef$.MODULE$.augmentString("%s /c \"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCommand("cmd"), cmdLine}));
        if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 215, 10), (Object)new java.lang.StringBuilder(14).append("exec command: ").append(c).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Process$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])CommandLineTokenizer$.MODULE$.tokenize(c)), (Option)None$.MODULE$, this.getEnv().toSeq()).run();
    }

    private WeakHashMap<String, Option<String>> cmdPathCache() {
        return this.cmdPathCache;
    }

    public String getCommand(String name) {
        String cmd;
        Option<String> option = this.findCommand(name);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("CommandTrait not found: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        String string = cmd = (String)some.value();
        return string;
    }

    public Option<String> findSh() {
        return this.findCommand("sh");
    }

    /*
     * WARNING - void declaration
     */
    public String[] getExecPath() {
        void var2_3;
        String string = System.getenv("PATH");
        String string2 = string == null ? "" : string.toString();
        String[] path = string2.split("[;:]");
        return var2_3;
    }

    public String progName(String p) {
        return OS$.MODULE$.isWindows() ? new java.lang.StringBuilder(4).append(p).append(".exe").toString() : p;
    }

    public Option<String> findCommand(String name) {
        return (Option)this.cmdPathCache().getOrElseUpdate((Object)name, (Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            BoxedUnit boxedUnit;
            String[] path = OS$.MODULE$.isWindows() ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.getExecPath())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"c:/cygwin/bin", (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : MODULE$.getExecPath();
            String prog = MODULE$.progName(name);
            Option exe = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2, prog), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.exists())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath());
            if (MODULE$.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                MODULE$.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 263, 15), (Object)(exe.isDefined() ? new StringOps(Predef$.MODULE$.augmentString("%s is found at %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, exe.get()})) : new StringOps(Predef$.MODULE$.augmentString("%s is not found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return var3_3;
        });
    }

    public Option<String> sysProp(String key) {
        return Option$.MODULE$.apply((Object)System.getProperty(key));
    }

    public Option<String> env(String key) {
        return Option$.MODULE$.apply((Object)System.getenv(key));
    }

    /*
     * WARNING - void declaration
     */
    public Option<String> findJavaHome() {
        void var2_2;
        BoxedUnit boxedUnit;
        Option e = this.env("JAVA_HOME").orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.sysProp("java.home"));
        Option p = e.map((Function1 & Serializable & scala.Serializable)x$5 -> Shell$.resolveCygpath$1(x$5));
        if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 293, 10), (Object)new java.lang.StringBuilder(16).append("Found JAVA_HOME=").append(p.get()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public Option<String> findJavaCommand(String javaCmdName) {
        return (Option)this.cmdPathCache().getOrElseUpdate((Object)javaCmdName, (Function0 & Serializable & scala.Serializable)() -> this.search$1(javaCmdName));
    }

    public String findJavaCommand$default$1() {
        return "java";
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$killTree$1(String signal$1, String line) {
        int childPID = new StringOps(Predef$.MODULE$.augmentString(line.trim())).toInt();
        return MODULE$.killTree(childPID, signal$1);
    }

    public static final /* synthetic */ void $anonfun$escape$1(StringBuilder b$1, String s$1, IntRef cursor$1, Regex.Match m) {
        b$1.append(s$1.substring(cursor$1.elem, m.start()));
        b$1.append(m.group(2));
        cursor$1.elem = m.end();
    }

    public static final /* synthetic */ void $anonfun$unescape$1(StringBuilder b$2, String s$2, IntRef cursor$2, Regex.Match m) {
        b$2.append(s$2.substring(cursor$2.elem, m.start()));
        b$2.append(m.group(2));
        cursor$2.elem = m.end();
    }

    public static final /* synthetic */ int $anonfun$getProcessIDOfCurrentJVM$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ void $anonfun$exec$1(String out) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            MODULE$.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 167, 71), (Object)out);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$execRemote$1(String out) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            MODULE$.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 181, 71), (Object)out);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final String resolveCygpath$1(String p) {
        Option m;
        return OS$.MODULE$.isWindows() ? ((m = new StringOps(Predef$.MODULE$.augmentString("/cygdrive/(\\w)(/.*)")).r().findFirstMatchIn((CharSequence)p)).isDefined() ? new StringOps(Predef$.MODULE$.augmentString("%s:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Regex.MatchData)m.get()).group(1), ((Regex.MatchData)m.get()).group(2)})) : p) : p;
    }

    private static final String javaBin$1(String java_home, String javaCmdName$1) {
        return new java.lang.StringBuilder(5).append(java_home).append("/bin/").append(MODULE$.progName(javaCmdName$1)).toString();
    }

    private static final boolean hasJavaCommand$1(String java_home, String javaCmdName$1) {
        File java_path = new File(Shell$.javaBin$1(java_home, javaCmdName$1));
        return java_path.exists();
    }

    public static final /* synthetic */ boolean $anonfun$findJavaCommand$1(String javaCmdName$1, File x) {
        return x.isDirectory() && (x.getName().startsWith("jdk") || x.getName().startsWith("jre")) && Shell$.hasJavaCommand$1(x.getAbsolutePath(), javaCmdName$1);
    }

    private static final String[] listJDKIn$1(String path, String javaCmdName$1) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Shell$.$anonfun$findJavaCommand$1(javaCmdName$1, x))))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private static final Option latestJDK$1(String[] jdkPath) {
        None$ none$;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jdkPath)).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String[] sorted = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jdkPath)).sorted((Ordering)Ordering.String$.MODULE$))).reverse();
            none$ = new Some((Object)sorted[0]);
        }
        return none$;
    }

    private final Option search$1(String javaCmdName$1) {
        Some some;
        Option java_home2;
        Option option;
        Option e = this.findJavaHome();
        Option option2 = e;
        if (option2 instanceof Some) {
            option = e;
        } else if (None$.MODULE$.equals(option2)) {
            Seq l;
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("/home/runner/work/airframe/airframe/airframe-control/.jvm/src/main/scala/wvlet/airframe/control/Shell.scala", "Shell.scala", 331, 18), (Object)"No java command found. Searching for JDK...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            OSType oSType = OS$.MODULE$.getType();
            Object object = ((Object)((Object)OSType.Windows)).equals((Object)oSType) ? Shell$.latestJDK$1(Shell$.listJDKIn$1("c:/Program Files/Java", javaCmdName$1)) : (((Object)((Object)OSType.Mac)).equals((Object)oSType) ? ((l = (Seq)((TraversableLike)new .colon.colon((Object)"/System/Library/Frameworkds/JavaVM.framework/Home", (List)new .colon.colon((Object)"/System/Library/Frameworkds/JavaVM.framework/Versions/CurrentJDK/Home", (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)java_home -> BoxesRunTime.boxToBoolean((boolean)Shell$.hasJavaCommand$1(java_home, javaCmdName$1)))).isEmpty() ? None$.MODULE$ : new Some(l.apply(0))) : None$.MODULE$);
            option = object;
        } else {
            throw new MatchError(option2);
        }
        Option option3 = java_home2 = option;
        if (option3 instanceof Some) {
            Some some2 = (Some)option3;
            String x = (String)some2.value();
            some = new Some((Object)Shell$.javaBin$1(x, javaCmdName$1).trim());
        } else if (None$.MODULE$.equals(option3)) {
            String javaPath = Process$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("which %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaCmdName$1}))).$bang$bang().trim();
            some = javaPath.isEmpty() ? None$.MODULE$ : new Some((Object)javaPath);
        } else {
            throw new MatchError(option3);
        }
        Some ret = some;
        return ret;
    }

    private Shell$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.cmdPathCache = new WeakHashMap();
    }
}

