/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import wvlet.airframe.metrics.TimeParser;
import wvlet.airframe.metrics.TimeParser$;
import wvlet.airframe.metrics.TimeVector;
import wvlet.airframe.metrics.TimeVector$;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindowBuilder$;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.package$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0012%\u0001-B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005u!A1\t\u0001B\u0001B\u0003%A\tC\u0003K\u0001\u0011\u00051\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003Q\u0001\u0011\u0005A\u000bC\u0003c\u0001\u0011\u00051\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003l\u0001\u0011\u0005!\u000eC\u0003m\u0001\u0011\u0005!\u000eC\u0003n\u0001\u0011\u0005!\u000eC\u0003o\u0001\u0011\u0005!\u000eC\u0003p\u0001\u0011\u0005!\u000eC\u0003q\u0001\u0011\u0005!\u000eC\u0003r\u0001\u0011\u0005!\u000eC\u0003s\u0001\u0011\u0005!\u000eC\u0003t\u0001\u0011\u0005!\u000eC\u0003u\u0001\u0011\u0005!\u000eC\u0003v\u0001\u0011\u0005a\u000fC\u0003{\u0001\u0011\u0005a\u000fC\u0003|\u0001\u0011\u0005a\u000fC\u0003}\u0001\u0011\u0005a\u000fC\u0003~\u0001\u0011\u0005a\u000fC\u0003\u007f\u0001\u0011\u0005a\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\n\u0003w\u0001\u0011\u0013!C\u0005\u0003{Aq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u001dI\u0011Q\u000e\u0013\u0002\u0002#\u0005\u0011q\u000e\u0004\tG\u0011\n\t\u0011#\u0001\u0002r!1!j\bC\u0001\u0003sB\u0011\"a\u001f #\u0003%\t!! \t\u0013\u0005\u0005u$!A\u0005\n\u0005\r%!\u0005+j[\u0016<\u0016N\u001c3po\n+\u0018\u000e\u001c3fe*\u0011QEJ\u0001\b[\u0016$(/[2t\u0015\t9\u0003&\u0001\u0005bSJ4'/Y7f\u0015\u0005I\u0013!B<wY\u0016$8\u0001A\n\u0004\u00011\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024m5\tAG\u0003\u00026Q\u0005\u0019An\\4\n\u0005]\"$A\u0003'pON+\b\u000f]8si\u0006!!p\u001c8f+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011!\u0018.\\3\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u000b5>tWm\u00144gg\u0016$\u0018!\u0002>p]\u0016\u0004\u0013aC2veJ,g\u000e\u001e+j[\u0016\u00042!L#H\u0013\t1eF\u0001\u0004PaRLwN\u001c\t\u0003w!K!!\u0013\u001f\u0003\u001bi{g.\u001a3ECR,G+[7f\u0003\u0019a\u0014N\\5u}Q\u0019AJT(\u0011\u00055\u0003Q\"\u0001\u0013\t\u000ba\"\u0001\u0019\u0001\u001e\t\u000f\r#\u0001\u0013!a\u0001\t\u0006Qq/\u001b;i\u001f\u001a47/\u001a;\u0015\u00051\u0013\u0006\"B*\u0006\u0001\u00049\u0015!\u0001;\u0015\u00051+\u0006\"\u0002,\u0007\u0001\u00049\u0016a\u00033bi\u0016$\u0016.\\3TiJ\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001./\u001b\u0005Y&B\u0001/+\u0003\u0019a$o\\8u}%\u0011aLL\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_]\u0005\u0011r/\u001b;i+:L\u0007\u0010V5nK>3gm]3u)\taE\rC\u0003f\u000f\u0001\u0007a-\u0001\u0005v]&DH+[7f!\tis-\u0003\u0002i]\t!Aj\u001c8h\u0003\rqwn^\u000b\u0002\u000f\u0006\u0011\"-Z4j]:LgnZ(g)\",\u0007j\\;s\u00031)g\u000eZ(g)\",\u0007j\\;s\u0003E\u0011WmZ5o]&twm\u00144UQ\u0016$\u0015-_\u0001\fK:$wJ\u001a+iK\u0012\u000b\u00170\u0001\ncK\u001eLgN\\5oO>3G\u000b[3XK\u0016\\\u0017\u0001D3oI>3G\u000b[3XK\u0016\\\u0017a\u00052fO&tg.\u001b8h\u001f\u001a$\u0006.Z'p]RD\u0017!D3oI>3G\u000b[3N_:$\b.\u0001\ncK\u001eLgN\\5oO>3G\u000b[3ZK\u0006\u0014\u0018\u0001D3oI>3G\u000b[3ZK\u0006\u0014\u0018!\u0002;pI\u0006LX#A<\u0011\u00055C\u0018BA=%\u0005)!\u0016.\\3XS:$wn^\u0001\ti\"L7\u000fS8ve\u0006AA\u000f[5t/\u0016,7.A\u0005uQ&\u001cXj\u001c8uQ\u0006AA\u000f[5t3\u0016\f'/A\u0005zKN$XM\u001d3bs\u0006Y\u0001/\u0019:tK>3gm]3u)\u001d9\u00151AA\u0004\u0003#Aa!!\u0002\u001a\u0001\u00049\u0016!A8\t\u000f\u0005%\u0011\u00041\u0001\u0002\f\u0005Qq/\u001b8e_^,f.\u001b;\u0011\u00075\u000bi!C\u0002\u0002\u0010\u0011\u0012a\u0002V5nK^Kg\u000eZ8x+:LG\u000fC\u0005\u0002\u0014e\u0001\n\u00111\u0001\u0002\u0016\u0005Y\u0011\r\u001a6vgRlWM\u001c;t!\u0019\t9\"!\t\u0002(9!\u0011\u0011DA\u000f\u001d\rQ\u00161D\u0005\u0002_%\u0019\u0011q\u0004\u0018\u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u0005\r\u0019V-\u001d\u0006\u0004\u0003?q\u0003cA'\u0002*%\u0019\u00111\u0006\u0013\u0003\u0015QKW.\u001a,fGR|'\u000fK\u0002\u001a\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kq\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011HA\u001a\u0005\u001d!\u0018-\u001b7sK\u000e\fQ\u0003]1sg\u0016|eMZ:fi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002@)\"\u0011QCA!W\t\t\u0019\u0005\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\r\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA'\u0003\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00031\tGM[;ti>3gm]3u)\u00159\u00151KA,\u0011\u0019\t)f\u0007a\u0001\u000f\u00061qN\u001a4tKRDq!a\u0005\u001c\u0001\u0004\t)\"A\u0003qCJ\u001cX\rF\u0002x\u0003;Ba!a\u0018\u001d\u0001\u00049\u0016aA:ue\u0006IaM]8n%\u0006tw-\u001a\u000b\u0006o\u0006\u0015\u0014\u0011\u000e\u0005\u0007\u0003Oj\u0002\u0019\u00014\u0002\u001bM$\u0018M\u001d;V]&DH+[7f\u0011\u0019\tY'\ba\u0001M\u0006YQM\u001c3V]&DH+[7f\u0003E!\u0016.\\3XS:$wn\u001e\"vS2$WM\u001d\t\u0003\u001b~\u0019Ba\b\u0017\u0002tA\u0019Q&!\u001e\n\u0007\u0005]dF\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002p\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a +\u0007\u0011\u000b\t%A\u0006sK\u0006$'+Z:pYZ,GCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAF}\u0005!A.\u00198h\u0013\u0011\ty)!#\u0003\r=\u0013'.Z2u\u0001")
public class TimeWindowBuilder
implements LogSupport {
    private final ZoneOffset zone;
    private final Option<ZonedDateTime> currentTime;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Option<ZonedDateTime> $lessinit$greater$default$2() {
        return TimeWindowBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger logger$lzycompute() {
        TimeWindowBuilder timeWindowBuilder = this;
        synchronized (timeWindowBuilder) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ZoneOffset zone() {
        return this.zone;
    }

    public TimeWindowBuilder withOffset(ZonedDateTime t) {
        return new TimeWindowBuilder(this.zone(), (Option<ZonedDateTime>)new Some((Object)t));
    }

    public TimeWindowBuilder withOffset(String dateTimeStr) {
        return (TimeWindowBuilder)TimeParser$.MODULE$.parse(dateTimeStr, this.zone()).map((Function1 & Serializable & scala.Serializable)d -> this.withOffset((ZonedDateTime)d)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(18).append("Invalid datetime: ").append(dateTimeStr).toString());
        });
    }

    public TimeWindowBuilder withUnixTimeOffset(long unixTime) {
        return this.withOffset(ZonedDateTime.ofInstant(Instant.ofEpochSecond(unixTime), package$.MODULE$.UTC()));
    }

    public ZonedDateTime now() {
        return (ZonedDateTime)this.currentTime.getOrElse((Function0 & Serializable & scala.Serializable)() -> ZonedDateTime.now(this.zone()));
    }

    public ZonedDateTime beginningOfTheHour() {
        return this.now().truncatedTo(ChronoUnit.HOURS);
    }

    public ZonedDateTime endOfTheHour() {
        return this.beginningOfTheHour().plusHours(1L);
    }

    public ZonedDateTime beginningOfTheDay() {
        return this.now().truncatedTo(ChronoUnit.DAYS);
    }

    public ZonedDateTime endOfTheDay() {
        return this.beginningOfTheDay().plusDays(1L);
    }

    public ZonedDateTime beginningOfTheWeek() {
        return this.now().truncatedTo(ChronoUnit.DAYS).with(DayOfWeek.MONDAY);
    }

    public ZonedDateTime endOfTheWeek() {
        return this.beginningOfTheWeek().plusWeeks(1L);
    }

    public ZonedDateTime beginningOfTheMonth() {
        return this.now().withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
    }

    public ZonedDateTime endOfTheMonth() {
        return this.beginningOfTheMonth().plusMonths(1L);
    }

    public ZonedDateTime beginningOfTheYear() {
        return this.now().withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
    }

    public ZonedDateTime endOfTheYear() {
        return this.beginningOfTheYear().plusYears(1L);
    }

    public TimeWindow today() {
        return new TimeWindow(this.beginningOfTheDay(), this.endOfTheDay());
    }

    public TimeWindow thisHour() {
        return new TimeWindow(this.beginningOfTheHour(), this.endOfTheHour());
    }

    public TimeWindow thisWeek() {
        return new TimeWindow(this.beginningOfTheWeek(), this.endOfTheWeek());
    }

    public TimeWindow thisMonth() {
        return new TimeWindow(this.beginningOfTheMonth(), this.endOfTheMonth());
    }

    public TimeWindow thisYear() {
        return new TimeWindow(this.beginningOfTheYear(), this.endOfTheYear());
    }

    public TimeWindow yesterday() {
        return this.today().minus(1L, ChronoUnit.DAYS);
    }

    private ZonedDateTime parseOffset(String o, TimeWindowUnit windowUnit, Seq<TimeVector> adjustments) {
        Regex pattern;
        Option option;
        while ((option = (pattern = new StringOps(Predef$.MODULE$.augmentString("^(?<duration>[^/]+)(?<sep>/(?<offset>.+))")).r()).findFirstMatchIn((CharSequence)o)) instanceof Some) {
            TimeVector duration;
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            String d = m.group("duration");
            TimeVector timeVector = duration = TimeVector$.MODULE$.apply(d);
            adjustments = (Seq)adjustments.$plus$colon((Object)timeVector, Seq$.MODULE$.canBuildFrom());
            o = m.group("offset");
        }
        if (None$.MODULE$.equals(option)) {
            String string = o;
            if ("now".equals(string)) {
                return this.adjustOffset(this.now(), adjustments);
            }
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TimeVector$.MODULE$.apply(o));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                TimeVector x = (TimeVector)success.value();
                if (x.x() <= 0L) {
                    return x.timeWindowFrom(this.adjustOffset(this.now(), (Seq<TimeVector>)adjustments)).start();
                }
                return x.timeWindowFrom(this.adjustOffset(this.now(), (Seq<TimeVector>)adjustments)).end();
            }
            if (try_ instanceof Failure) {
                Tuple2 tuple2;
                Tuple2 tuple22 = tuple2 = o.endsWith(")") ? new Tuple2((Object)o.substring(0, o.length() - 1), (Object)BoxesRunTime.boxToBoolean((boolean)false)) : new Tuple2((Object)o, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String timeString = (String)tuple2._1();
                boolean truncate = tuple2._2$mcZ$sp();
                Tuple2 tuple23 = new Tuple2((Object)timeString, (Object)BoxesRunTime.boxToBoolean((boolean)truncate));
                String timeString2 = (String)tuple23._1();
                boolean truncate2 = tuple23._2$mcZ$sp();
                return (ZonedDateTime)TimeParser$.MODULE$.parse(timeString2, this.zone()).map((Function1 & Serializable & scala.Serializable)offset -> this.adjustOffset((ZonedDateTime)offset, (Seq<TimeVector>)adjustments)).map((Function1 & Serializable & scala.Serializable)offset -> {
                    if (truncate2) {
                        return windowUnit.truncate((ZonedDateTime)offset);
                    }
                    return offset;
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Invalid offset string: ").append(o).toString());
                });
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)option);
    }

    private ZonedDateTime adjustOffset(ZonedDateTime offset, Seq<TimeVector> adjustments) {
        return (ZonedDateTime)adjustments.foldLeft((Object)offset, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                ZonedDateTime offset = (ZonedDateTime)tuple2._1();
                TimeVector duration = (TimeVector)tuple2._2();
                return duration.unit().increment(offset, duration.x());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public TimeWindow parse(String str) {
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("^(?<duration>[^/]+)(?<sep>/(?<offset>.*))?")).r();
        Option option = pattern.findFirstMatchIn((CharSequence)str);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            String d = m.group("duration");
            Option<TimeParser.TimeParseResult> option2 = TimeParser$.MODULE$.parseTimeAndUnit(d, this.zone());
            if (option2 instanceof Some) {
                ZonedDateTime zonedDateTime;
                Some some2 = (Some)option2;
                TimeParser.TimeParseResult exactStartTime = (TimeParser.TimeParseResult)some2.value();
                String string = m.group("offset");
                if (string == null) {
                    TimeVector thisUnit = new TimeVector(-1L, 1L, exactStartTime.unit());
                    zonedDateTime = thisUnit.timeWindowFrom(exactStartTime.dateTime()).end();
                } else {
                    zonedDateTime = this.parseOffset(string, TimeWindowUnit$Second$.MODULE$, this.parseOffset$default$3());
                }
                ZonedDateTime offset = zonedDateTime;
                return new TimeWindow(exactStartTime.dateTime(), offset);
            }
            if (None$.MODULE$.equals(option2)) {
                TimeVector duration = TimeVector$.MODULE$.apply(d);
                String string = m.group("offset");
                if (string == null) {
                    ZonedDateTime context = duration.unit().truncate(this.now());
                    return duration.timeWindowFrom(context);
                }
                ZonedDateTime offset = this.parseOffset(string, duration.unit(), this.parseOffset$default$3());
                return duration.timeWindowFrom(offset);
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(14).append("TimeRange.of(").append(str).append(")").toString());
        }
        throw new MatchError((Object)option);
    }

    private Seq<TimeVector> parseOffset$default$3() {
        return Nil$.MODULE$;
    }

    public TimeWindow fromRange(long startUnixTime, long endUnixTime) {
        return new TimeWindow(Instant.ofEpochSecond(startUnixTime).atZone(this.zone()), Instant.ofEpochSecond(endUnixTime).atZone(this.zone()));
    }

    public TimeWindowBuilder(ZoneOffset zone, Option<ZonedDateTime> currentTime) {
        this.zone = zone;
        this.currentTime = currentTime;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

