/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.codegen;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class ClassScanner$
implements LogSupport {
    public static final ClassScanner$ MODULE$ = new ClassScanner$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        ClassScanner$ classScanner$ = this;
        synchronized (classScanner$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    public String decodePath(String path) {
        return URLDecoder.decode(path, StandardCharsets.UTF_8);
    }

    public Seq<String> scanClasses(ClassLoader cl, Seq<String> targetPackageNames) {
        Seq urls = this.loop$1(cl);
        Builder b = package$.MODULE$.Seq().newBuilder();
        urls.foreach((Function1 & Serializable)x -> (Builder)b.$plus$plus$eq((IterableOnce)this.findClasses$1((URL)x, (Seq)targetPackageNames)));
        return (Seq)((SeqOps)((IterableOps)b.result()).filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.contains("$anon$")))).distinct();
    }

    private String toFilePath(String packageName) {
        return new StringBuilder(1).append(packageName.replaceAll("\\.", "/")).append("/").toString();
    }

    private Seq<String> scanClassesInDirectory(String dir, Seq<String> targetPackageNames) {
        Builder classes;
        block0: {
            classes = package$.MODULE$.Seq().newBuilder();
            File baseDir = new File(dir);
            if (!baseDir.exists() || !baseDir.isDirectory()) break block0;
            Seq dirs = (Seq)((IterableOps)targetPackageNames.map((Function1 & Serializable)packageName -> MODULE$.toFilePath((String)packageName))).map((Function1 & Serializable)path -> new File(baseDir, (String)path));
            dirs.foreach((Function1 & Serializable)x -> {
                ClassScanner$.loop$2(baseDir, x, classes);
                return BoxedUnit.UNIT;
            });
        }
        return (Seq)classes.result();
    }

    private Seq<String> scanClassesInJar(String jarFile, Seq<String> targetPackageNames) {
        JarFile jf = new JarFile(jarFile);
        Enumeration<JarEntry> entryEnum = jf.entries();
        Seq targetPaths = (Seq)targetPackageNames.map((Function1 & Serializable)packageName -> MODULE$.toFilePath((String)packageName));
        Builder classes = package$.MODULE$.Seq().newBuilder();
        while (entryEnum.hasMoreElements()) {
            BoxedUnit boxedUnit;
            JarEntry jarEntry = entryEnum.nextElement();
            String entryName = jarEntry.getName();
            if (entryName.endsWith(".class") && targetPaths.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)entryName.startsWith(p)))) {
                String clsName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(entryName), ".class").replaceAll("\\/", ".");
                boxedUnit = classes.$plus$eq((Object)clsName);
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Seq)classes.result();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClassScanner$.class);
    }

    private final Seq loop$1(ClassLoader c) {
        Seq seq;
        while (true) {
            ClassLoader classLoader;
            if ((classLoader = c) == null) {
                seq = (Seq)package$.MODULE$.Seq().empty();
                break;
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                seq = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs())).$plus$plus((IterableOnce)this.loop$1(uRLClassLoader.getParent()));
                break;
            }
            c = c.getParent();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq findClasses$1(URL url, Seq targetPackageNames$1) {
        URL uRL = url;
        String string = uRL.getProtocol();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            File d = new File(uRL.getPath());
            if (d.exists() && d.isDirectory()) {
                return this.scanClassesInDirectory(this.decodePath(uRL.getPath()), (Seq<String>)targetPackageNames$1);
            }
        }
        String string3 = uRL.getProtocol();
        String string4 = "file";
        if (string3 == null) {
            if (string4 != null) {
                return (Seq<String>)package$.MODULE$.Seq().empty();
            }
        } else if (!string3.equals(string4)) return (Seq<String>)package$.MODULE$.Seq().empty();
        if (!uRL.getPath().endsWith(".jar")) return (Seq<String>)package$.MODULE$.Seq().empty();
        return this.scanClassesInJar(this.decodePath(uRL.getPath()), (Seq<String>)targetPackageNames$1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void loop$2(File baseDir, File f, Builder classes$1) {
        File file;
        File file2 = f;
        if (file2 != null) {
            File file3 = file2;
            if (f.isDirectory()) {
                BoxedUnit boxedUnit;
                File[] files = file3.listFiles();
                if (files != null) {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$1 -> {
                        ClassScanner$.loop$2(baseDir, x$1, classes$1);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        if (file2 != null && (file = file2).getPath().endsWith(".class")) {
            String className = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(file.getPath()), ".class").replace(baseDir.getPath(), "").replaceFirst("\\/", "").replaceAll("\\/", ".");
            classes$1.$plus$eq((Object)className);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ClassScanner$() {
    }
}

