/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ReusableBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.internal.RPCCallContext;
import wvlet.airframe.surface.MethodParameter;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.surface.TypeName$;
import wvlet.airframe.ulid.ULID;
import wvlet.log.LogTimestampFormatter$;

public final class HttpLogs$ {
    public static final HttpLogs$ MODULE$ = new HttpLogs$();
    private static final Set<String> defaultExcludeHeaders = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Authorization", "Cookie"}))).map((Function1 & Serializable)x$2 -> x$2.toLowerCase());
    private static final scala.collection.concurrent.Map<String, String> headerSanitizeCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();

    public ListMap<String, Object> unixTimeLogs(long currentTimeMillis) {
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)BoxesRunTime.boxToLong((long)(currentTimeMillis / 1000L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"start_time_ms"), (Object)BoxesRunTime.boxToLong((long)currentTimeMillis)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event_time"), (Object)LogTimestampFormatter$.MODULE$.formatTimestampWithNoSpaace(currentTimeMillis))}));
    }

    public long unixTimeLogs$default$1() {
        return System.currentTimeMillis();
    }

    public Map<String, Object> commonRequestLogs(HttpMessage.Request request) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"method"), (Object)request.method().toString()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)request.path()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uri"), (Object)this.sanitize(request.uri())));
        String queryString = this.extractQueryString(request.uri());
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(queryString)) ? m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"query_string"), (Object)queryString)) : BoxedUnit.UNIT;
        m.$plus$plus$eq(this.requestHeaderLogs(request));
        return (Map)m.result();
    }

    public Map<String, Object> commonResponseLogs(HttpMessage.Response response) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status_code"), (Object)BoxesRunTime.boxToInteger((int)response.statusCode())));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status_code_name"), (Object)response.status().reason()));
        response.contentLength().foreach((Function1 & Serializable)x$1 -> HttpLogs$.$anonfun$commonResponseLogs$1(m, BoxesRunTime.unboxToLong((Object)x$1)));
        m.$plus$plus$eq(this.responseHeaderLogs(response));
        return (Map)m.result();
    }

    public Map<String, Object> requestHeaderLogs(HttpMessage.Request request) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_header"), this.headerLogs(request.header()))}));
    }

    public Map<String, Object> responseHeaderLogs(HttpMessage.Response response) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_header"), this.headerLogs(response.header()))}));
    }

    private Set<String> defaultExcludeHeaders() {
        return defaultExcludeHeaders;
    }

    public Map<String, Object> headerLogs(HttpMultiMap headerMap) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        headerMap.entries().foreach((Function1 & Serializable)e -> {
            if (!MODULE$.defaultExcludeHeaders().contains((Object)e.key().toLowerCase())) {
                String v = headerMap.getAll(e.key()).mkString(";");
                return m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.sanitizeHeader(e.key())), (Object)v));
            }
            return BoxedUnit.UNIT;
        });
        return (Map)m.result();
    }

    public Map<String, Object> rpcMethodLogs(RPCMethod rpcMethod) {
        return rpcMethod.logData();
    }

    public ListMap<String, Object> rpcLogs(RPCCallContext rpcContext) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_interface"), (Object)TypeName$.MODULE$.sanitizeTypeName(rpcContext.rpcInterfaceCls().getName())));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_class"), (Object)rpcContext.rpcMethodSurface().owner().fullName()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_method"), (Object)rpcContext.rpcMethodSurface().name()));
        ListMap<String, Object> rpcArgs = this.extractRpcArgLog(rpcContext);
        Object object = rpcArgs.nonEmpty() ? m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_args"), rpcArgs)) : BoxedUnit.UNIT;
        return (ListMap)m.result();
    }

    public ListMap<String, Object> extractRpcArgLog(RPCCallContext rpcContext) {
        ReusableBuilder rpcArgsBuilder = ListMap$.MODULE$.newBuilder();
        ((IterableOps)rpcContext.rpcMethodSurface().args().zip(rpcContext.rpcArgs())).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpLogs$.$anonfun$extractRpcArgLog$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return (ReusableBuilder)rpcArgsBuilder.$plus$plus$eq((IterableOnce)HttpLogs$.traverseParam$1((Parameter)p, arg));
            }
            throw new MatchError((Object)tuple2);
        });
        return (ListMap)rpcArgsBuilder.result();
    }

    public ListMap<String, Object> errorLogs(Throwable e) {
        ReusableBuilder m;
        block1: {
            Throwable throwable;
            block2: {
                block0: {
                    m = ListMap$.MODULE$.newBuilder();
                    throwable = this.findCause$1(e);
                    if (throwable != null) break block0;
                    break block1;
                }
                if (!(throwable instanceof HttpServerException)) break block2;
                HttpServerException httpServerException = (HttpServerException)throwable;
                if (httpServerException.getCause() == null) break block1;
                Throwable rootCause = this.findCause$1(httpServerException.getCause());
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)rootCause));
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)rootCause.getMessage()));
                break block1;
            }
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)throwable));
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)throwable.getMessage()));
        }
        return (ListMap)m.result();
    }

    private String sanitize(String s) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x0$1 -> HttpLogs$.$anonfun$sanitize$1(BoxesRunTime.unboxToChar((Object)x0$1))).mkString();
    }

    private scala.collection.concurrent.Map<String, String> headerSanitizeCache() {
        return headerSanitizeCache;
    }

    private String sanitizeHeader(String h) {
        return (String)this.headerSanitizeCache().getOrElseUpdate((Object)h, (Function0 & Serializable)() -> h.replaceAll("-", "_").toLowerCase());
    }

    public String extractQueryString(String uri) {
        int qPos = uri.indexOf(63);
        if (qPos < 0 || qPos == uri.length() - 1) {
            return "";
        }
        return uri.substring(qPos + 1, uri.length());
    }

    public static final /* synthetic */ ReusableBuilder $anonfun$commonResponseLogs$1(ReusableBuilder m$1, long x$1) {
        return (ReusableBuilder)m$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_content_length"), (Object)BoxesRunTime.boxToLong((long)x$1)));
    }

    private static final ListMap traverseObject$1(Surface s, Object arg) {
        ReusableBuilder builder = ListMap$.MODULE$.newBuilder();
        s.params().foreach((Function1 & Serializable)p -> Try$.MODULE$.apply((Function0 & Serializable)() -> (ReusableBuilder)builder.$plus$plus$eq((IterableOnce)HttpLogs$.traverseParam$1(p, p.get(arg)))));
        return (ListMap)builder.result();
    }

    private static final ListMap traverseParam$1(Parameter p, Object arg) {
        Object object = arg;
        if (object instanceof HttpMessage.Request) {
            return ListMap$.MODULE$.empty();
        }
        String string = p.surface().fullName();
        String string2 = "com.twitter.finagle.http.Request";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof HttpContext) {
            return ListMap$.MODULE$.empty();
        }
        if (p.isSecret()) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof ULID) {
            ULID uLID = (ULID)object;
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)uLID)}));
        }
        if (p.surface().params().length() > 0) {
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)HttpLogs$.traverseObject$1(p.surface(), arg))}));
        }
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), arg)}));
    }

    public static final /* synthetic */ boolean $anonfun$extractRpcArgLog$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final Throwable findCause$1(Throwable e) {
        while (true) {
            ExecutionException executionException;
            Throwable throwable;
            if ((throwable = e) instanceof Exception) {
                Exception exception = (Exception)throwable;
                String string = exception.getClass().getName();
                String string2 = "java.lang.reflect.InvocationTargetException";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    e = exception.getCause();
                    continue;
                }
            }
            if (!(throwable instanceof ExecutionException) || (executionException = (ExecutionException)throwable).getCause() == null) break;
            e = executionException.getCause();
        }
        return e;
    }

    public static final /* synthetic */ Object $anonfun$sanitize$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return BoxesRunTime.boxToCharacter((char)c);
    }

    private HttpLogs$() {
    }
}

