/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import wvlet.log.io.Resource;

public final class Resource$ {
    public static final Resource$ MODULE$ = new Resource$();

    public <U> U open(Class<?> referenceClass, String resourceFileName, Function1<BufferedInputStream, U> body) {
        Object object;
        Option<URL> u = this.find(referenceClass, resourceFileName);
        if (u.isEmpty()) {
            throw scala.sys.package$.MODULE$.error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Resource %s (in %s) not found"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{resourceFileName, referenceClass.getSimpleName()})));
        }
        try (BufferedInputStream s = new BufferedInputStream(((URL)u.get()).openStream());){
            object = body.apply((Object)s);
        }
        return (U)object;
    }

    private String packagePath(Class<?> referenceClass) {
        return this.packagePath(referenceClass.getPackage());
    }

    private String packagePath(Package basePackage) {
        return this.packagePath(basePackage.getName());
    }

    private String packagePath(String packageName) {
        String packageAsPath = packageName.replaceAll("\\.", "/");
        if (packageAsPath.endsWith("/")) {
            return packageAsPath;
        }
        return new StringBuilder(1).append(packageAsPath).append("/").toString();
    }

    private ClassLoader currentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Option<URLClassLoader> findNextURLClassLoader(ClassLoader cl) {
        while (true) {
            ClassLoader classLoader;
            if ((classLoader = cl) instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                return new Some((Object)uRLClassLoader);
            }
            if (classLoader == null) {
                return None$.MODULE$;
            }
            cl = classLoader.getParent();
        }
    }

    private String resolveResourcePath(String packageName, String resourceFileName) {
        String path = this.packagePath(packageName);
        return this.prependSlash(new StringBuilder(0).append(path).append(resourceFileName).toString());
    }

    private String prependSlash(String name) {
        if (name.startsWith("/")) {
            return name;
        }
        return new StringBuilder(1).append("/").append(name).toString();
    }

    public Option<URL> find(Class<?> referenceClass, String resourceFileName) {
        return this.find(this.packagePath(referenceClass), resourceFileName);
    }

    public Option<URL> find(String absoluteResourcePath) {
        return this.find("", absoluteResourcePath.startsWith("/") ? absoluteResourcePath.substring(1) : absoluteResourcePath);
    }

    public Option<URL> find(String packageName, String resourceFileName) {
        String resourcePath = this.resolveResourcePath(packageName, resourceFileName);
        return this.loop$1(this.currentClassLoader(), resourcePath).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)MODULE$.getClass().getResource(resourcePath)));
    }

    private String extractLogicalName(String packagePath, String resourcePath) {
        String p = !packagePath.endsWith("/") ? new StringBuilder(1).append(packagePath).append("/").toString() : packagePath;
        int pos = resourcePath.indexOf(p);
        if (pos < 0) {
            return null;
        }
        String logicalName = resourcePath.substring(pos + p.length());
        return logicalName;
    }

    private Seq<Resource.VirtualFile> collectFileResources(String resourceURLString, String packagePath, Function1<String, Object> resourceFilter) {
        Builder b;
        block1: {
            String logicalName = this.extractLogicalName(packagePath, resourceURLString);
            if (logicalName == null) {
                throw new IllegalArgumentException(new StringBuilder(26).append("packagePath=").append(packagePath).append(", resourceURL=").append(resourceURLString).toString());
            }
            b = package$.MODULE$.Seq().newBuilder();
            File file = new File(new URL(resourceURLString).toURI());
            Object object = BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)file.getPath())) ? b.$plus$eq((Object)new Resource.SystemFile(file, logicalName)) : BoxedUnit.UNIT;
            if (!file.isDirectory()) break block1;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])file.listFiles()), (Function1 & Serializable)childFile -> {
                String childResourceURL = new StringBuilder(0).append(resourceURLString).append((Object)(resourceURLString.endsWith("/") ? "" : "/")).append(childFile.getName()).toString();
                return (Builder)b.$plus$plus$eq(MODULE$.collectFileResources(childResourceURL, packagePath, resourceFilter));
            });
        }
        return (Seq)b.result();
    }

    private Seq<Resource.VirtualFile> listResources(URL resourceURL, String packageName, Function1<String, Object> resourceFilter) {
        Growable growable;
        String protocol;
        String pkgPath = this.packagePath(packageName);
        Builder fileList = package$.MODULE$.Seq().newBuilder();
        if (resourceURL == null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        String string = protocol = resourceURL.getProtocol();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String resourceURLString = resourceURL.toString();
            growable = fileList.$plus$plus$eq(this.collectFileResources(resourceURLString, pkgPath, resourceFilter));
        } else {
            String string3 = protocol;
            String string4 = "jar";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String path = resourceURL.getPath();
                int pos = path.indexOf("!");
                if (pos < 0) {
                    throw new IllegalArgumentException(new StringBuilder(22).append("invalid resource URL: ").append(resourceURL).toString());
                }
                String jarPath = path.substring(0, pos).replaceAll("%20", " ");
                String filePath = path.substring(0, pos).replaceAll("%20", " ").replaceAll("%25", "%").replace("file:", "");
                String jarURLString = new StringBuilder(4).append("jar:").append(jarPath).toString();
                JarFile jf = new JarFile(filePath);
                Enumeration<JarEntry> entryEnum = jf.entries();
                while (entryEnum.hasMoreElements()) {
                    JarEntry jarEntry = entryEnum.nextElement();
                    String physicalURL = new StringBuilder(2).append(jarURLString).append("!/").append(jarEntry.getName()).toString();
                    URL jarFileURL = new URL(physicalURL);
                    String logicalName = this.extractLogicalName(pkgPath, jarEntry.getName());
                    Object object = logicalName != null && BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)logicalName)) ? fileList.$plus$eq((Object)new Resource.FileInJar(jarFileURL, logicalName, jarEntry.isDirectory())) : BoxedUnit.UNIT;
                }
            } else {
                throw new UnsupportedOperationException(new StringBuilder(52).append("resources other than file or jar are not supported: ").append(resourceURL).toString());
            }
            growable = BoxedUnit.UNIT;
        }
        return (Seq)fileList.result();
    }

    public Seq<Resource.VirtualFile> listResources(String packageName) {
        return this.listResources(packageName, (Function1<String, Object>)(Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Resource$.$anonfun$listResources$1(f)), this.listResources$default$3());
    }

    public Seq<Resource.VirtualFile> listResources(String packageName, Function1<String, Object> resourceFilter, ClassLoader classLoader) {
        Builder b = package$.MODULE$.Seq().newBuilder();
        this.findResourceURLs(classLoader, packageName).foreach((Function1 & Serializable)u -> (Builder)b.$plus$plus$eq(MODULE$.listResources((URL)u, packageName, resourceFilter)));
        return (Seq)b.result();
    }

    public ClassLoader listResources$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Seq<URL> findResourceURLs(ClassLoader cl, String name) {
        String path = this.packagePath(name);
        Builder b = package$.MODULE$.Seq().newBuilder();
        this.loop$2(this.currentClassLoader(), path, b);
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(String packageName, Class<A> toSearch, ClassLoader classLoader) {
        Seq<Resource.VirtualFile> classFileList = this.listResources(packageName, (Function1<String, Object>)(Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.endsWith(".class")), classLoader);
        Builder b = package$.MODULE$.Seq().newBuilder();
        classFileList.foreach((Function1 & Serializable)vf -> {
            Resource$.$anonfun$findClasses$2(packageName, toSearch, b, classLoader, vf);
            return BoxedUnit.UNIT;
        });
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(Package searchPath, Class<A> toSearch, ClassLoader classLoader) {
        return this.findClasses(searchPath.getName(), toSearch, classLoader);
    }

    public <A> ClassLoader findClasses$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    private final Option loop$1(ClassLoader cl, String resourcePath$1) {
        Option<URLClassLoader> option;
        while ((option = this.findNextURLClassLoader(cl)) instanceof Some) {
            Some some = (Some)option;
            URLClassLoader urlClassLoader = (URLClassLoader)some.value();
            URL uRL = urlClassLoader.getResource(resourcePath$1);
            if (uRL != null) {
                URL uRL2 = uRL;
                return new Some((Object)uRL2);
            }
            if (uRL == null) {
                cl = urlClassLoader.getParent();
                continue;
            }
            throw new MatchError((Object)uRL);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$listResources$1(String f) {
        return true;
    }

    private final void loop$2(ClassLoader cl, String path$1, Builder b$3) {
        Option<URLClassLoader> option;
        while ((option = this.findNextURLClassLoader(cl)) instanceof Some) {
            Some some = (Some)option;
            URLClassLoader urlClassLoader = (URLClassLoader)some.value();
            Enumeration<URL> e = urlClassLoader.findResources(path$1);
            while (e.hasMoreElements()) {
                URL elem = e.nextElement();
                b$3.$plus$eq((Object)elem);
            }
            cl = urlClassLoader.getParent();
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
    }

    private static final Option componentName$1(String path) {
        int dot = path.lastIndexOf(".");
        if (dot <= 0) {
            return None$.MODULE$;
        }
        return new Some((Object)path.substring(0, dot).replaceAll("/", "."));
    }

    private static final Option findClass$1(String name, ClassLoader classLoader$1) {
        Some some;
        try {
            some = new Some(Class.forName(name, false, classLoader$1));
        }
        catch (ClassNotFoundException e) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$findClasses$3(String packageName$2, Class toSearch$1, Builder b$4, ClassLoader classLoader$1, String cn) {
        String className = new StringBuilder(1).append(packageName$2).append(".").append(cn).toString();
        Resource$.findClass$1(className, classLoader$1).foreach((Function1 & Serializable)cl -> {
            if (!Modifier.isAbstract(cl.getModifiers()) && toSearch$1.isAssignableFrom((Class<?>)cl)) {
                return b$4.$plus$eq(cl);
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$findClasses$2(String packageName$2, Class toSearch$1, Builder b$4, ClassLoader classLoader$1, Resource.VirtualFile vf) {
        Resource$.componentName$1(vf.logicalPath()).foreach((Function1 & Serializable)cn -> {
            Resource$.$anonfun$findClasses$3(packageName$2, toSearch$1, b$4, classLoader$1, cn);
            return BoxedUnit.UNIT;
        });
    }

    private Resource$() {
    }
}

