/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import wvlet.airframe.metrics.TimeParser;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.package$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TimeParser$
implements LogSupport {
    public static final TimeParser$ MODULE$ = new TimeParser$();
    private static final DateTimeFormatter localDatePattern;
    private static final DateTimeFormatter localDateTimePattern;
    private static final List<DateTimeFormatter> zonedDateTimePatterns;
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
        localDatePattern = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        localDateTimePattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS]");
        zonedDateTimePatterns = new .colon.colon((Object)"yyyy-MM-dd HH:mm:ss[.SSS][ z][XXXXX][XXXX]['['VV']']", (List)new .colon.colon((Object)"yyyy-MM-dd'T'HH:mm:ss[.SSS][ z][XXXXX][XXXX]['['VV']']", (List)Nil$.MODULE$)).map((Function1 & Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1));
    }

    private Logger logger$lzycompute() {
        TimeParser$ timeParser$ = this;
        synchronized (timeParser$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public DateTimeFormatter localDatePattern() {
        return localDatePattern;
    }

    public DateTimeFormatter localDateTimePattern() {
        return localDateTimePattern;
    }

    public List<DateTimeFormatter> zonedDateTimePatterns() {
        return zonedDateTimePatterns;
    }

    public Option<TimeParser.TimeParseResult> parseLocalDateTime(String s, ZoneOffset zone) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> LocalDateTime.parse(s, MODULE$.localDateTimePattern())).map((Function1 & Serializable)d -> new TimeParser.TimeParseResult(ZonedDateTime.of(d, zone), TimeWindowUnit$Second$.MODULE$)).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> LocalDate.parse(s, MODULE$.localDatePattern())).map((Function1 & Serializable)d -> new TimeParser.TimeParseResult(d.atStartOfDay(zone), TimeWindowUnit$Day$.MODULE$))).toOption();
    }

    public Option<TimeParser.TimeParseResult> parseZonedDateTime(String s) {
        return this.loop$1(this.zonedDateTimePatterns().toList(), s);
    }

    public Option<ZonedDateTime> parseAtLocalTimeZone(String s) {
        return this.parse(s, package$.MODULE$.systemTimeZone());
    }

    public Option<ZonedDateTime> parse(String s, ZoneOffset zone) {
        return this.parseTimeAndUnit(s, zone).map((Function1 & Serializable)x$2 -> x$2.dateTime());
    }

    public Option<TimeParser.TimeParseResult> parseTimeAndUnit(String s, ZoneOffset zone) {
        return this.parseLocalDateTime(s, zone).orElse((Function0 & Serializable)() -> MODULE$.parseZonedDateTime(s));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeParser$.class);
    }

    private final Option loop$1(List lst, String s$2) {
        Try try_;
        while (true) {
            if (lst.isEmpty()) {
                return None$.MODULE$;
            }
            DateTimeFormatter formatter = (DateTimeFormatter)lst.head();
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ZonedDateTime.parse(s$2, formatter));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ZonedDateTime dt = (ZonedDateTime)success.value();
                return new Some((Object)new TimeParser.TimeParseResult(dt, TimeWindowUnit$Second$.MODULE$));
            }
            if (!(try_ instanceof Failure)) break;
            lst = (List)lst.tail();
        }
        throw new MatchError((Object)try_);
    }

    private TimeParser$() {
    }
}

