/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.launcher;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageContext;
import wvlet.airframe.codec.ParamListCodec;
import wvlet.airframe.launcher.ClassOptionSchema;
import wvlet.airframe.launcher.CommandLauncherBaseCompat;
import wvlet.airframe.launcher.LauncherConfig;
import wvlet.airframe.launcher.LauncherInfo;
import wvlet.airframe.launcher.LauncherInfo$;
import wvlet.airframe.launcher.LauncherInstance;
import wvlet.airframe.launcher.LauncherResult;
import wvlet.airframe.launcher.MethodOptionSchema;
import wvlet.airframe.launcher.OptionParser;
import wvlet.airframe.launcher.OptionSchema;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.airframe.surface.CName;
import wvlet.airframe.surface.CName$;
import wvlet.airframe.surface.MethodSurface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\u000b\u0016\u0001qA\u0011\"\f\u0001\u0003\u0006\u0004%\t!\u0006\u0018\t\u0011I\u0002!\u0011!Q\u0001\n=B\u0011b\r\u0001\u0003\u0006\u0004%\t!\u0006\u001b\t\u0011a\u0002!\u0011!Q\u0001\nUB\u0011\"\u000f\u0001\u0003\u0006\u0004%\t!\u0006\u001e\t\u0011!\u0003!\u0011!Q\u0001\nmB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006-\u0002!\ta\u0016\u0005\u00069\u0002!\t!\u0018\u0005\u0006M\u0002!\t!\u0018\u0005\u0006O\u0002!\t!\u0018\u0005\u0007Q\u0002!\t!F5\t\r1\u0004A\u0011A\u000bn\u0011\u0019a\b\u0001\"\u0001\u0016{\"A\u0011Q\u0001\u0001\u0005\u0002U\t9\u0001\u0003\u0005\u0002$\u0001!\t!FA\u0013\u0011!\t)\u0004\u0001C\u0001+\u0005]\u0002\u0002CA \u0001\u0011\u0005Q#!\u0011\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\ty1i\\7nC:$G*Y;oG\",'O\u0003\u0002\u0017/\u0005AA.Y;oG\",'O\u0003\u0002\u00193\u0005A\u0011-\u001b:ge\u0006lWMC\u0001\u001b\u0003\u00159h\u000f\\3u\u0007\u0001\u0019B\u0001A\u000f$OA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0013\u000e\u0003UI!AJ\u000b\u00033\r{W.\\1oI2\u000bWO\\2iKJ\u0014\u0015m]3D_6\u0004\u0018\r\u001e\t\u0003Q-j\u0011!\u000b\u0006\u0003Ue\t1\u0001\\8h\u0013\ta\u0013F\u0001\u0006M_\u001e\u001cV\u000f\u001d9peR\fA\u0002\\1v]\u000eDWM]%oM>,\u0012a\f\t\u0003IAJ!!M\u000b\u0003\u00191\u000bWO\\2iKJLeNZ8\u0002\u001b1\fWO\\2iKJLeNZ8!\u00031y\u0007\u000f^5p]B\u000b'o]3s+\u0005)\u0004C\u0001\u00137\u0013\t9TC\u0001\u0007PaRLwN\u001c)beN,'/A\u0007paRLwN\u001c)beN,'\u000fI\u0001\fgV\u00147i\\7nC:$7/F\u0001<!\raDi\u0012\b\u0003{\ts!AP!\u000e\u0003}R!\u0001Q\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013BA\" \u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0012$\u0003\u0007M+\u0017O\u0003\u0002D?A\u0011A\u0005A\u0001\rgV\u00147i\\7nC:$7\u000fI\u0001\u000fI\u00164\u0017-\u001e7u\u0007>lW.\u00198e!\rq2*T\u0005\u0003\u0019~\u0011aa\u00149uS>t\u0007\u0003\u0002\u0010O!NK!aT\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0013R\u0013\t\u0011VC\u0001\tMCVt7\r[3s\u0013:\u001cH/\u00198dKB\u0011a\u0004V\u0005\u0003+~\u00111!\u00118z\u0003\u0019a\u0014N\\5u}Q)q\tW-[7\")Q\u0006\u0003a\u0001_!)1\u0007\u0003a\u0001k!)\u0011\b\u0003a\u0001w!)\u0011\n\u0003a\u0001\u0015\u0006!a.Y7f+\u0005q\u0006CA0d\u001d\t\u0001\u0017\r\u0005\u0002??%\u0011!mH\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c?\u0005YA-Z:de&\u0004H/[8o\u0003\u0015)8/Y4f\u0003A9\u0018\u000e\u001e5MCVt7\r[3s\u0013:4w\u000eF\u0002HU.DQ\u0001\u0018\u0007A\u0002yCQA\u001a\u0007A\u0002y\u000b!b\u001c9uS>tG*[:u+\u0005q\u0007c\u0001\u001fE_B\u0011\u0001/\u001f\b\u0003c^t!A\u001d<\u000f\u0005M,hB\u0001 u\u0013\u0005Q\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002y+\u0005aq\n\u001d;j_:\u0004\u0016M]:fe&\u0011!p\u001f\u0002\t\u00072{\u0005\u000f^5p]*\u0011\u00010F\u0001\u0004C\u0012$G#B$\u007f\u007f\u0006\u0005\u0001\"\u0002/\u000f\u0001\u0004q\u0006\"\u00024\u000f\u0001\u0004q\u0006BBA\u0002\u001d\u0001\u0007q)A\bd_6l\u0017M\u001c3MCVt7\r[3s\u0003%\u0001(/\u001b8u\u0011\u0016d\u0007\u000f\u0006\u0004\u0002\n\u0005=\u0011\u0011\u0004\t\u0004=\u0005-\u0011bAA\u0007?\t!QK\\5u\u0011\u001d\t\tb\u0004a\u0001\u0003'\ta\u0002\\1v]\u000eDWM]\"p]\u001aLw\rE\u0002%\u0003+I1!a\u0006\u0016\u00059a\u0015-\u001e8dQ\u0016\u00148i\u001c8gS\u001eDq!a\u0007\u0010\u0001\u0004\ti\"A\u0003ti\u0006\u001c7\u000e\u0005\u0003=\u0003?\u0001\u0016bAA\u0011\r\n!A*[:u\u0003=\u0001(/\u001b8u\u001b\u0016$\bn\u001c3IK2\u0004H\u0003CA\u0005\u0003O\tI#a\r\t\u000f\u0005E\u0001\u00031\u0001\u0002\u0014!9\u00111\u0006\tA\u0002\u00055\u0012!A7\u0011\u0007\u0011\ny#C\u0002\u00022U\u0011!#T3uQ>$w\n\u001d;j_:\u001c6\r[3nC\"9\u00111\u0004\tA\u0002\u0005u\u0011!\u00059sS:$\b*\u001a7q\u0013:$XM\u001d8bYR1\u0011\u0011BA\u001d\u0003wAq!!\u0005\u0012\u0001\u0004\t\u0019\u0002C\u0004\u0002\u001cE\u0001\r!!\u0010\u0011\tq\nybR\u0001\bKb,7-\u001e;f))\t\u0019%!\u0013\u0002L\u00055\u00131\u000b\t\u0004I\u0005\u0015\u0013bAA$+\tqA*Y;oG\",'OU3tk2$\bbBA\t%\u0001\u0007\u00111\u0003\u0005\b\u00037\u0011\u0002\u0019AA\u000f\u0011\u001d\tyE\u0005a\u0001\u0003#\nA!\u0019:hgB\u0019A\b\u00120\t\u000f\u0005U#\u00031\u0001\u0002X\u0005A1\u000f[8x\u0011\u0016d\u0007\u000fE\u0002\u001f\u00033J1!a\u0017 \u0005\u001d\u0011un\u001c7fC:\faBZ5oIN+(mQ8n[\u0006tG\r\u0006\u0003\u0002b\u0005\r\u0004c\u0001\u0010L\u000f\")Al\u0005a\u0001=\u0002")
public class CommandLauncher
implements CommandLauncherBaseCompat,
LogSupport {
    private final LauncherInfo launcherInfo;
    private final OptionParser optionParser;
    private final Seq<CommandLauncher> subCommands;
    private final Option<Function1<LauncherInstance, Object>> defaultCommand;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public <B> CommandLauncher addCommandModule(String name, String description, TypeTags.TypeTag<B> evidence$5) {
        return CommandLauncherBaseCompat.addCommandModule$(this, name, description, evidence$5);
    }

    private Logger logger$lzycompute() {
        CommandLauncher commandLauncher = this;
        synchronized (commandLauncher) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public LauncherInfo launcherInfo() {
        return this.launcherInfo;
    }

    public OptionParser optionParser() {
        return this.optionParser;
    }

    public Seq<CommandLauncher> subCommands() {
        return this.subCommands;
    }

    public String name() {
        return this.launcherInfo().name();
    }

    public String description() {
        return this.launcherInfo().description();
    }

    public String usage() {
        return this.launcherInfo().usage();
    }

    public CommandLauncher withLauncherInfo(String name, String description) {
        return new CommandLauncher(new LauncherInfo(name, description, this.launcherInfo().usage(), LauncherInfo$.MODULE$.apply$default$4()), this.optionParser(), this.subCommands(), this.defaultCommand);
    }

    public Seq<OptionParser.CLOption> optionList() {
        return this.optionParser().optionList();
    }

    public CommandLauncher add(String name, String description, CommandLauncher commandLauncher) {
        return new CommandLauncher(this.launcherInfo(), this.optionParser(), (Seq<CommandLauncher>)((Seq)this.subCommands().$colon$plus((Object)commandLauncher.withLauncherInfo(name, description))), this.defaultCommand);
    }

    public void printHelp(LauncherConfig launcherConfig, List<LauncherInstance> stack) {
        this.printHelpInternal(launcherConfig, (List<CommandLauncher>)stack.map((Function1 & Serializable)x$7 -> x$7.launcher()));
    }

    public void printMethodHelp(LauncherConfig launcherConfig, MethodOptionSchema m, List<LauncherInstance> stack) {
        LauncherInstance h = (LauncherInstance)stack.head();
        List globalOptions = ((List)stack.tail()).flatMap((Function1 & Serializable)x$8 -> x$8.launcher().optionParser().optionList());
        LauncherInfo li = h.launcher().launcherInfo();
        String help = launcherConfig.helpMessagePrinter().render(li.name(), m.args(), (Option<String>)(li.usage().isEmpty() ? None$.MODULE$ : new Some((Object)li.usage())), li.description(), m.options(), (Seq<OptionParser.CLOption>)globalOptions, (Seq<CommandLauncher>)((Seq)package$.MODULE$.Seq().empty()));
        Predef$.MODULE$.print((Object)help);
    }

    public void printHelpInternal(LauncherConfig launcherConfig, List<CommandLauncher> stack) {
        CommandLauncher l = (CommandLauncher)stack.head();
        OptionSchema schema = l.optionParser().schema();
        List globalOptions = ((List)stack.tail()).flatMap((Function1 & Serializable)x$9 -> x$9.optionParser().optionList());
        String help = launcherConfig.helpMessagePrinter().render(l.name(), schema.args(), (Option<String>)(l.usage().isEmpty() ? None$.MODULE$ : new Some((Object)l.usage())), l.description(), schema.options(), (Seq<OptionParser.CLOption>)globalOptions, (Seq<CommandLauncher>)((Seq)l.subCommands().filterNot((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CommandLauncher.$anonfun$printHelpInternal$2(x)))));
        Predef$.MODULE$.print((Object)help);
    }

    public LauncherResult execute(LauncherConfig launcherConfig, List<LauncherInstance> stack, Seq<String> args2, boolean showHelp) {
        BoxedUnit boxedUnit;
        OptionParser.OptionParserResult result = this.optionParser().parse((String[])args2.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "Launcher.scala", 264, 10), (Object)result);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean showHelpMessage = result.showHelp() | showHelp;
        OptionSchema optionSchema = this.optionParser().schema();
        if (optionSchema instanceof ClassOptionSchema) {
            LauncherInstance head;
            ClassOptionSchema classOptionSchema = (ClassOptionSchema)optionSchema;
            byte[] parseTree_mp = result.parseTree().toMsgPack();
            MessageCodec codec = launcherConfig.codecFactory().withMapOutput().of(classOptionSchema.surface());
            MessageContext h = new MessageContext();
            codec.unpack(MessagePack$.MODULE$.newUnpacker(parseTree_mp), h);
            h.getError().map((Function1 & Serializable)e -> {
                throw new IllegalArgumentException(new StringBuilder(31).append("Error occurered in launching ").append(classOptionSchema.surface()).append(": ").append(e.getMessage()).toString());
            });
            Object obj = h.getLastValue();
            LauncherInstance launcherInstance = head = new LauncherInstance(this, obj);
            List nextStack = stack.$colon$colon((Object)launcherInstance);
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument()))) {
                if (showHelpMessage) {
                    this.printHelp(launcherConfig, (List<LauncherInstance>)nextStack);
                    return new LauncherResult((List<LauncherInstance>)nextStack, (Option<Object>)None$.MODULE$);
                }
                return (LauncherResult)this.defaultCommand.map((Function1 & Serializable)defaultCommand -> defaultCommand.apply((Object)head)).map((Function1 & Serializable)x -> new LauncherResult((List<LauncherInstance>)nextStack, (Option<Object>)new Some(x))).getOrElse((Function0 & Serializable)() -> new LauncherResult((List<LauncherInstance>)nextStack, (Option<Object>)None$.MODULE$));
            }
            String subCommandName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument()));
            Option<CommandLauncher> option2 = this.findSubCommand(subCommandName);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                CommandLauncher subCommand = (CommandLauncher)some.value();
                return subCommand.execute(launcherConfig, (List<LauncherInstance>)nextStack, (Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument())))), showHelpMessage);
            }
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException(new StringBuilder(21).append("Unknown sub command: ").append(subCommandName).toString());
            }
            throw new MatchError(option2);
        }
        if (optionSchema instanceof MethodOptionSchema) {
            LauncherResult launcherResult;
            MethodOptionSchema methodOptionSchema = (MethodOptionSchema)optionSchema;
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument()))) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Unknown arguments are found: [").append(Predef$.MODULE$.wrapRefArray((Object[])result.unusedArgument()).mkString(", ")).append("]").toString());
            }
            Object parentObj = stack.headOption().map((Function1 & Serializable)x$10 -> x$10.instance()).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("parent should not be empty");
            });
            if (showHelpMessage) {
                LauncherInstance launcherInstance = new LauncherInstance(this, parentObj);
                this.printMethodHelp(launcherConfig, methodOptionSchema, (List<LauncherInstance>)stack.$colon$colon((Object)launcherInstance));
                return new LauncherResult(stack, (Option<Object>)None$.MODULE$);
            }
            try {
                MethodSurface methodSurface = methodOptionSchema.method();
                Seq paramCodecs = (Seq)methodSurface.args().map((Function1 & Serializable)x -> launcherConfig.codecFactory().of(x.surface()));
                ParamListCodec methodArgCodec = new ParamListCodec(methodSurface.name(), methodSurface.args().toIndexedSeq(), paramCodecs, (Option)new Some(parentObj));
                byte[] msgpack = result.parseTree().toMsgPack();
                launcherResult = (LauncherResult)methodArgCodec.unpackMsgPack(msgpack).map((Function1 & Serializable)args -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "Launcher.scala", 338, 22), (Object)new StringBuilder(27).append("calling method ").append(methodSurface).append(" with args: ").append(args.mkString(", ")).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object methodResult = methodSurface.call(parentObj, args);
                    return new LauncherResult(stack, (Option<Object>)new Some(methodResult));
                }).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(17).append("Failed to call ").append(methodSurface).append(": ").append(result.parseTree()).toString());
                });
            }
            catch (InvocationTargetException e2) {
                throw e2.getTargetException();
            }
            catch (Throwable other) {
                throw other;
            }
            return launcherResult;
        }
        throw new MatchError((Object)optionSchema);
    }

    private Option<CommandLauncher> findSubCommand(String name) {
        CName cname = CName$.MODULE$.apply(name);
        return this.subCommands().find((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CommandLauncher.$anonfun$findSubCommand$1(cname, x)));
    }

    public static final /* synthetic */ boolean $anonfun$printHelpInternal$2(CommandLauncher x) {
        return x.launcherInfo().isDefault();
    }

    public static final /* synthetic */ boolean $anonfun$findSubCommand$1(CName cname$1, CommandLauncher x) {
        CName cName = CName$.MODULE$.apply(x.name());
        CName cName2 = cname$1;
        return !(cName != null ? !cName.equals(cName2) : cName2 != null);
    }

    public CommandLauncher(LauncherInfo launcherInfo, OptionParser optionParser, Seq<CommandLauncher> subCommands, Option<Function1<LauncherInstance, Object>> defaultCommand) {
        this.launcherInfo = launcherInfo;
        this.optionParser = optionParser;
        this.subCommands = subCommands;
        this.defaultCommand = defaultCommand;
        CommandLauncherBaseCompat.$init$(this);
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

