/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.util.matching.Regex;
import wvlet.airframe.metrics.TimeVector;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Hour$;
import wvlet.airframe.metrics.TimeWindowUnit$Month$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.TimeWindowUnit$Week$;
import wvlet.airframe.metrics.TimeWindowUnit$Year$;

public final class TimeVector$
implements Serializable {
    public static final TimeVector$ MODULE$ = new TimeVector$();
    private static final Regex durationPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?<prefix>[+-]|last|next)?(?<num>[0-9]+)(?<unit>s|m|d|h|w|M|q|y)"));

    private Regex durationPattern() {
        return durationPattern;
    }

    public TimeVector apply(String s) {
        Option option;
        block27: {
            String string;
            block28: {
                TimeWindowUnit unit;
                int length;
                block29: {
                    String string2 = s;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -1621979774: {
                            if (!"yesterday".equals(string2)) break;
                            return new TimeVector(-1L, 0L, TimeWindowUnit$Day$.MODULE$);
                        }
                        case -1459764838: {
                            if (!"lastHour".equals(string2)) break;
                            return new TimeVector(-1L, 0L, TimeWindowUnit$Hour$.MODULE$);
                        }
                        case -1459328086: {
                            if (!"lastWeek".equals(string2)) break;
                            return new TimeVector(-1L, 0L, TimeWindowUnit$Week$.MODULE$);
                        }
                        case -1459268621: {
                            if (!"lastYear".equals(string2)) break;
                            return new TimeVector(-1L, 0L, TimeWindowUnit$Year$.MODULE$);
                        }
                        case -1037172987: {
                            if (!"tomorrow".equals(string2)) break;
                            return new TimeVector(1L, 1L, TimeWindowUnit$Day$.MODULE$);
                        }
                        case -577153406: {
                            if (!"thisMonth".equals(string2)) break;
                            return new TimeVector(-1L, 1L, TimeWindowUnit$Month$.MODULE$);
                        }
                        case 110534465: {
                            if (!"today".equals(string2)) break;
                            return new TimeVector(-1L, 1L, TimeWindowUnit$Day$.MODULE$);
                        }
                        case 1200457549: {
                            if (!"nextMonth".equals(string2)) break;
                            return new TimeVector(1L, 1L, TimeWindowUnit$Month$.MODULE$);
                        }
                        case 1228159394: {
                            if (!"thisHour".equals(string2)) break;
                            return new TimeVector(-1L, 1L, TimeWindowUnit$Hour$.MODULE$);
                        }
                        case 1228596146: {
                            if (!"thisWeek".equals(string2)) break;
                            return new TimeVector(-1L, 1L, TimeWindowUnit$Week$.MODULE$);
                        }
                        case 1228655611: {
                            if (!"thisYear".equals(string2)) break;
                            return new TimeVector(-1L, 1L, TimeWindowUnit$Year$.MODULE$);
                        }
                        case 1424049015: {
                            if (!"nextHour".equals(string2)) break;
                            return new TimeVector(1L, 1L, TimeWindowUnit$Hour$.MODULE$);
                        }
                        case 1424485767: {
                            if (!"nextWeek".equals(string2)) break;
                            return new TimeVector(1L, 1L, TimeWindowUnit$Week$.MODULE$);
                        }
                        case 1424545232: {
                            if (!"nextYear".equals(string2)) break;
                            return new TimeVector(1L, 1L, TimeWindowUnit$Year$.MODULE$);
                        }
                        case 1996541322: {
                            if (!"lastMonth".equals(string2)) break;
                            return new TimeVector(-1L, 0L, TimeWindowUnit$Month$.MODULE$);
                        }
                    }
                    option = this.durationPattern().findFirstMatchIn((CharSequence)s);
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException(new StringBuilder(18).append("Invalid duration: ").append(s).toString());
                    }
                    if (!(option instanceof Some)) break block27;
                    Some some = (Some)option;
                    Regex.Match m = (Regex.Match)some.value();
                    length = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group("num")));
                    unit = TimeWindowUnit$.MODULE$.of(m.group("unit"));
                    string = m.group("prefix");
                    switch (string == null ? 0 : string.hashCode()) {
                        case 0: {
                            if (string != null) break block28;
                            break block29;
                        }
                        case 43: {
                            if (!"+".equals(string)) break block28;
                            break block29;
                        }
                        case 45: {
                            if ("-".equals(string)) {
                                break;
                            }
                            break block28;
                        }
                        case 3314326: {
                            if ("last".equals(string)) {
                                break;
                            }
                            break block28;
                        }
                        case 3377907: {
                            if (!"next".equals(string)) break block28;
                            break block29;
                        }
                        default: {
                            break block28;
                        }
                    }
                    return new TimeVector(-length, 0L, unit);
                }
                return new TimeVector(length, 0L, unit);
            }
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown duration prefix: ").append(string).toString());
        }
        throw new MatchError((Object)option);
    }

    public TimeVector succinctTimeVector(long startUnixTime, long endUnixTime) {
        TimeWindow r = TimeWindow$.MODULE$.withUTC().fromRange(startUnixTime, endUnixTime);
        double secondDiff = endUnixTime - startUnixTime;
        return this.loop$1(TimeWindowUnit$.MODULE$.units().reverse(), endUnixTime, startUnixTime, r, secondDiff);
    }

    public TimeVector apply(long x, long offset, TimeWindowUnit unit) {
        return new TimeVector(x, offset, unit);
    }

    public Option<Tuple3<Object, Object, TimeWindowUnit>> unapply(TimeVector x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)x$0.x()), (Object)BoxesRunTime.boxToLong((long)x$0.offset()), (Object)x$0.unit()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeVector$.class);
    }

    private final TimeVector loop$1(List unitsToUse, long endUnixTime$1, long startUnixTime$1, TimeWindow r$1, double secondDiff$1) {
        while (!unitsToUse.isEmpty()) {
            TimeWindowUnit unit = (TimeWindowUnit)unitsToUse.head();
            long numUnits = r$1.howMany(unit);
            ZonedDateTime startTruncated = unit.truncate(r$1.start());
            ZonedDateTime endTruncated = unit.truncate(r$1.end());
            TimeWindow truncated = new TimeWindow(startTruncated, endTruncated);
            long truncatedSecondDiff = truncated.secondDiff();
            if (numUnits > 0L && RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((secondDiff$1 - (double)truncatedSecondDiff) / (double)(numUnits * (long)unit.secondsInUnit()))) <= 0.001) {
                return new TimeVector(numUnits, 0L, unit);
            }
            unitsToUse = (List)unitsToUse.tail();
        }
        return new TimeVector(endUnixTime$1 - startUnixTime$1, 0L, TimeWindowUnit$Second$.MODULE$);
    }

    private TimeVector$() {
    }
}

