/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.surface.reflect;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.surface.Primitive$;
import wvlet.airframe.surface.Primitive$Boolean$;
import wvlet.airframe.surface.Primitive$Byte$;
import wvlet.airframe.surface.Primitive$Char$;
import wvlet.airframe.surface.Primitive$Double$;
import wvlet.airframe.surface.Primitive$Float$;
import wvlet.airframe.surface.Primitive$Int$;
import wvlet.airframe.surface.Primitive$Long$;
import wvlet.airframe.surface.Primitive$Short$;
import wvlet.airframe.surface.Primitive$String$;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.surface.Zero$;
import wvlet.airframe.surface.reflect.ReflectTypeUtil$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TypeConverter$
implements LogSupport {
    public static final TypeConverter$ MODULE$ = new TypeConverter$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        TypeConverter$ typeConverter$ = this;
        synchronized (typeConverter$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <T> Option<Object> convert(T value, Surface targetType) {
        Class<?> s;
        if (value == null) {
            return new Some(Zero$.MODULE$.zeroOf(targetType));
        }
        if (targetType.isPrimitive()) {
            return this.convertToPrimitive(value, targetType);
        }
        if (targetType.isOption()) {
            if (ReflectTypeUtil$.MODULE$.isOptionCls(ReflectTypeUtil$.MODULE$.cls(value))) {
                return Option$.MODULE$.apply(value);
            }
            return Option$.MODULE$.apply(this.convert(value, (Surface)targetType.typeArgs().apply(0)));
        }
        if (ReflectTypeUtil$.MODULE$.isArray(targetType) && ReflectTypeUtil$.MODULE$.isArrayCls(ReflectTypeUtil$.MODULE$.cls(value))) {
            return Option$.MODULE$.apply(value);
        }
        Class<?> t = targetType.rawType();
        if (t.isAssignableFrom(s = ReflectTypeUtil$.MODULE$.cls(value))) {
            return new Some(value);
        }
        if (ReflectTypeUtil$.MODULE$.isBuffer(s)) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "TypeConverter.scala", 54, 16), (Object)new StringBuilder(21).append("convert buffer ").append(value).append(" into ").append(targetType).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Buffer buf = (Buffer)value;
            Seq<Surface> gt = targetType.typeArgs();
            Class<?> e = ((Surface)gt.apply(0)).rawType();
            if (ReflectTypeUtil$.MODULE$.isArray(targetType)) {
                Object[] arr = (Object[])ClassTag$.MODULE$.apply(e).newArray(buf.length());
                buf.copyToArray((Object)arr);
                return new Some((Object)arr);
            }
            if (ReflectTypeUtil$.MODULE$.isList(t)) {
                return new Some((Object)buf.toList());
            }
            if (ReflectTypeUtil$.MODULE$.isIndexedSeq(t)) {
                return new Some((Object)buf.toIndexedSeq());
            }
            if (ReflectTypeUtil$.MODULE$.isSeq(t)) {
                return new Some((Object)buf.toSeq());
            }
            if (ReflectTypeUtil$.MODULE$.isSet(t)) {
                return new Some((Object)buf.toSet());
            }
            if (ReflectTypeUtil$.MODULE$.isMap(t)) {
                return new Some((Object)buf.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "TypeConverter.scala", 73, 17), (Object)new StringBuilder(19).append("cannot convert ").append(s.getSimpleName()).append(" to ").append(t.getSimpleName()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }
        return this.convertToCls(value, targetType.rawType());
    }

    public <A> Option<A> convertToCls(Object value, Class<A> targetType) {
        Class<?> cl = ReflectTypeUtil$.MODULE$.cls(value);
        if (targetType.isAssignableFrom(cl)) {
            return new Some(value);
        }
        if (ReflectTypeUtil$.MODULE$.hasStringUnapplyConstructor(targetType)) {
            return ReflectTypeUtil$.MODULE$.companionObject(targetType).flatMap((Function1 & Serializable)co -> {
                Method m = ReflectTypeUtil$.MODULE$.cls(co).getDeclaredMethod("unapply", (Class[])((Object[])new Class[]{String.class}));
                Option v = (Option)m.invoke(co, (Object[])new String[]{value.toString()});
                Option option = v;
                if (option instanceof Some) {
                    return v;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                        MODULE$.logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, new LogSource("", "TypeConverter.scala", 98, 18), (Object)new StringBuilder(35).append("cannot create an instance of ").append(targetType).append(" from ").append(value).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            });
        }
        Option<Constructor<?>> option = this.stringConstructor(targetType);
        if (option instanceof Some) {
            Some some = (Some)option;
            Constructor cc = (Constructor)some.value();
            return new Some(cc.newInstance(value.toString()));
        }
        if (None$.MODULE$.equals(option)) {
            return this.convertToPrimitive(value, Primitive$.MODULE$.apply(targetType));
        }
        throw new MatchError(option);
    }

    public <A> Option<A> convertToPrimitive(Object value, Surface targetType) {
        Object object;
        if (value == null) {
            return None$.MODULE$;
        }
        String s = value.toString();
        Surface surface = targetType;
        if (((Object)Primitive$String$.MODULE$).equals(surface)) {
            object = s;
        } else if (((Object)Primitive$Boolean$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Int$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Float$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Double$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Long$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Short$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Byte$.MODULE$).equals(surface)) {
            object = BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(s)));
        } else if (((Object)Primitive$Char$.MODULE$).equals(surface) && s.length() == 1) {
            object = BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0));
        } else {
            Class<?> clazz = surface.rawType();
            Class<File> clazz2 = File.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                object = new File(s);
            } else {
                Class<?> clazz3 = surface.rawType();
                Class<Date> clazz4 = Date.class;
                if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
                    object = DateFormat.getDateInstance().parse(s);
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "TypeConverter.scala", 132, 15), (Object)new StringBuilder(24).append("Failed to convert \"").append(s).append("\" to ").append(targetType.toString()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = None$.MODULE$;
                }
            }
        }
        String v = object;
        return new Some((Object)v);
    }

    public Option<Constructor<?>> stringConstructor(Class<?> cl) {
        Constructor<?>[] cc2 = cl.getDeclaredConstructors();
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])cc2), (Function1 & Serializable)cc -> BoxesRunTime.boxToBoolean((boolean)TypeConverter$.$anonfun$stringConstructor$1(cc)));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TypeConverter$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$stringConstructor$1(Constructor cc) {
        Class<?>[] pt = cc.getParameterTypes();
        if (pt.length != 1) return false;
        Class<?> clazz = pt[0];
        Class<String> clazz2 = String.class;
        if (clazz != null) {
            if (!clazz.equals(clazz2)) return false;
            return true;
        }
        if (clazz2 == null) return true;
        return false;
    }

    private TypeConverter$() {
    }
}

