/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodec$;
import wvlet.airframe.control.Retry;
import wvlet.airframe.control.Retry$;
import wvlet.airframe.http.HttpClientException$;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpMultiMap$;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.package$;
import wvlet.airframe.json.JSON;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClient$
implements LogSupport {
    public static final HttpClient$ MODULE$ = new HttpClient$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        HttpClient$ httpClient$ = this;
        synchronized (httpClient$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <Req, Resp> Retry.RetryContext baseHttpClientRetry(HttpRequestAdapter<Req> evidence$1, ClassTag<Req> evidence$2, HttpResponseAdapter<Resp> evidence$3) {
        return Retry$.MODULE$.withJitter(15, Retry$.MODULE$.withJitter$default$2(), Retry$.MODULE$.withJitter$default$3(), Retry$.MODULE$.withJitter$default$4()).withResultClassifier((Function1 & Serializable)response -> HttpClientException$.MODULE$.classifyHttpResponse(response, evidence$3)).beforeRetry((Function1 & Serializable)ctx -> MODULE$.defaultBeforeRetryAction((Retry.RetryContext)ctx, evidence$1, evidence$2));
    }

    public <Req, Resp> Retry.RetryContext defaultHttpClientRetry(HttpRequestAdapter<Req> evidence$4, ClassTag<Req> evidence$5, HttpResponseAdapter<Resp> evidence$6) {
        return this.baseHttpClientRetry(evidence$4, evidence$5, evidence$6).withErrorClassifier((Function1 & Serializable)ex -> HttpClientException$.MODULE$.classifyExecutionFailure((Throwable)ex));
    }

    public <Req> Object defaultBeforeRetryAction(Retry.RetryContext ctx, HttpRequestAdapter<Req> evidence$7, ClassTag<Req> evidence$8) {
        String string;
        Some some;
        Object r;
        Class cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$8)).runtimeClass();
        Option option = ctx.context();
        if (option instanceof Some && cls.isAssignableFrom((r = (some = (Some)option).value()).getClass())) {
            HttpRequestAdapter adapter = (HttpRequestAdapter)Predef$.MODULE$.implicitly(evidence$7);
            Object req = r;
            String path = adapter.pathOf(req);
            string = new StringBuilder(23).append("Request to ").append(path).append(" is failed: ").append(ctx.lastError().getMessage()).toString();
        } else {
            string = new StringBuilder(19).append("Request is failed: ").append(ctx.lastError().getMessage()).toString();
        }
        String errorMessage = string;
        int nextWaitMillis = ctx.nextWaitMillis();
        if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "HttpClient.scala", 180, 9), (Object)StringOps$.MODULE$.format$extension("[%s/%s] %s. Retry the request in %.3f sec.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctx.retryCount()), BoxesRunTime.boxToInteger((int)ctx.maxRetry()), errorMessage, BoxesRunTime.boxToDouble((double)((double)nextWaitMillis / 1000.0))})));
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public String urlEncode(String s) {
        return package$.MODULE$.compat().urlEncode(s);
    }

    public <Resource> String buildResourceUri(String path, Resource resource, Surface resourceSurface) {
        BoxedUnit boxedUnit;
        HttpMultiMap queryParams = this.flattenResourceToQueryParams(resource, resourceSurface);
        scala.collection.mutable.StringBuilder pathWithParams = new scala.collection.mutable.StringBuilder();
        pathWithParams.append(path);
        if (queryParams.nonEmpty()) {
            String queryParamString = ((IterableOnceOps)queryParams.entries().map((Function1 & Serializable)x -> new StringBuilder(1).append(x.key()).append("=").append(x.value()).toString())).mkString("&");
            pathWithParams.append("?");
            boxedUnit = pathWithParams.append(queryParamString);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return pathWithParams.result();
    }

    public <Resource> HttpMultiMap flattenResourceToQueryParams(Resource resource, Surface resourceSurface) {
        MessageCodec resourceCodec = MessageCodec$.MODULE$.ofSurface(resourceSurface);
        JSON.JSONObject resourceJson = (JSON.JSONObject)Try$.MODULE$.apply((Function0 & Serializable)() -> resourceCodec.toJSONObject(resource)).getOrElse((Function0 & Serializable)() -> JSON.JSONObject$.MODULE$.empty());
        HttpMultiMap.HttpMultiMapBuilder queryParams = HttpMultiMap$.MODULE$.newBuilder();
        resourceJson.v().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue j = (JSON.JSONValue)tuple2._2();
                if (j instanceof JSON.JSONArray) {
                    JSON.JSONArray jSONArray = (JSON.JSONArray)j;
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(jSONArray.toJSON())));
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue j = (JSON.JSONValue)tuple2._2();
                if (j instanceof JSON.JSONObject) {
                    JSON.JSONObject jSONObject = (JSON.JSONObject)j;
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(jSONObject.toJSON())));
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue other = (JSON.JSONValue)tuple2._2();
                return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(other.toString())));
            }
            throw new MatchError((Object)tuple2);
        });
        return queryParams.result();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClient$.class);
    }

    private HttpClient$() {
    }
}

